/*
 * Decompiled with CFR 0.152.
 */
package mcd.asic;

import java.util.StringJoiner;
import mcd.dict.MegaCdDict;
import omegadrive.util.BufferUtil;
import omegadrive.util.Size;
import omegadrive.util.Util;

public class AsicModel {

    static class StampConfig {
        StampSize stampSize = StampSize._16x16;
        StampMapSize stampMapSize = StampMapSize._256x256;
        StampRepeat stampRepeat = StampRepeat.BLANK;
        StampPriorityMode priorityMode = StampPriorityMode.PM_OFF;
        int stampStartLocation = 0;
        int vCellSize = 1;
        int imgDestBufferLocation = 0;
        int imgTraceTableLocation = 0;
        int hPixelOffset;
        int vPixelOffset;
        int imgOffset;
        int imgHeightPx;
        int imgWidthPx;

        StampConfig() {
        }

        public String toString() {
            return new StringJoiner(", ", StampConfig.class.getSimpleName() + "[", "]").add("stampSize=" + String.valueOf((Object)this.stampSize)).add("stampMapSize=" + String.valueOf((Object)this.stampMapSize)).add("stampRepeat=" + String.valueOf((Object)this.stampRepeat)).add("priorityMode=" + String.valueOf((Object)this.priorityMode)).add("stampStartLocation=" + Util.th(this.stampStartLocation)).add("vCellSize=" + this.vCellSize).add("imgDestBufferLocation=" + Util.th(this.imgDestBufferLocation)).add("imgTraceTableLocation=" + Util.th(this.imgTraceTableLocation)).add("hPixelOffset=" + this.hPixelOffset).add("vPixelOffset=" + this.vPixelOffset).add("imgHeightPx=" + this.imgHeightPx).add("imgWidthPx=" + this.imgWidthPx).toString();
        }
    }

    static class TraceTableEntry {
        int startPos;
        int deltax;
        int deltay;

        TraceTableEntry() {
        }
    }

    static class StampData {
        int stampId;
        int horizontalFlip;
        StampRotationDegrees rotation = StampRotationDegrees._0;

        StampData() {
        }
    }

    static enum StampRotationDegrees {
        _0,
        _90,
        _180,
        _270;

        static StampRotationDegrees[] vals;

        static {
            vals = StampRotationDegrees.values();
        }
    }

    public static enum StampPriorityMode {
        PM_OFF,
        UNDERWRITE,
        OVERWRITE,
        ILLEGAL;

        static StampPriorityMode[] vals;

        static {
            vals = StampPriorityMode.values();
        }
    }

    static enum StampMapSize {
        _256x256(256),
        _4096x4096(4096);

        public final int pixelSize;
        static StampMapSize[] vals;

        private StampMapSize(int px) {
            this.pixelSize = px;
        }

        static {
            vals = StampMapSize.values();
        }
    }

    static enum StampSize {
        _16x16(16),
        _32x32(32);

        public final int pixelSize;
        static StampSize[] vals;

        private StampSize(int px) {
            this.pixelSize = px;
        }

        static {
            vals = StampSize.values();
        }
    }

    static enum StampRepeat {
        BLANK,
        REPEAT_MAP;

        static StampRepeat[] vals;

        static {
            vals = StampRepeat.values();
        }
    }

    public static enum AsicEvent {
        AS_STOP,
        AS_START;

    }

    public static interface AsicOp
    extends BufferUtil.StepDevice {
        public void write(MegaCdDict.RegSpecMcd var1, int var2, int var3, Size var4);

        public int read(MegaCdDict.RegSpecMcd var1, int var2, Size var3);

        public StampPriorityMode getStampPriorityMode();

        public void setStampPriorityMode(int var1);
    }
}

