/*
 * Decompiled with CFR 0.152.
 */
package mcd.bus;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import mcd.asic.AsicModel;
import mcd.bus.McdSubInterruptHandler;
import mcd.bus.MegaCdMainCpuBus;
import mcd.bus.MegaCdSubCpuBusIntf;
import mcd.cdc.Cdc;
import mcd.cdd.Cdd;
import mcd.dict.MegaCdDict;
import mcd.dict.MegaCdMemoryContext;
import mcd.pcm.McdPcm;
import mcd.util.BuramHelper;
import mcd.util.McdRegBitUtil;
import omegadrive.Device;
import omegadrive.bus.DeviceAwareBus;
import omegadrive.bus.md.BusArbiter;
import omegadrive.bus.model.MdM68kBusProvider;
import omegadrive.cpu.m68k.MC68000Wrapper;
import omegadrive.joypad.MdJoypad;
import omegadrive.system.SystemProvider;
import omegadrive.util.BufferUtil;
import omegadrive.util.LogHelper;
import omegadrive.util.MdRuntimeData;
import omegadrive.util.Size;
import omegadrive.util.Util;
import omegadrive.vdp.model.BaseVdpAdapterEventSupport;
import omegadrive.vdp.model.MdVdpProvider;
import org.slf4j.Logger;

public class MegaCdSubCpuBus
extends DeviceAwareBus<MdVdpProvider, MdJoypad>
implements MegaCdSubCpuBusIntf {
    private static final Logger LOG = LogHelper.getLogger(MegaCdSubCpuBus.class.getSimpleName());
    public static final int PCM_CLOCK_DIVIDER_TO_75HZ = 434;
    private ByteBuffer subCpuRam;
    private ByteBuffer sysGateRegs;
    private ByteBuffer commonGateRegs;
    private LogHelper logHelper = new LogHelper();
    private MegaCdMemoryContext memCtx;
    private BufferUtil.CpuDeviceAccess cpuType;
    @Deprecated
    private McdSubInterruptHandler interruptHandler;
    private McdPcm pcm;
    private AsicModel.AsicOp asic;
    private Cdd cdd;
    private Cdc cdc;
    private MC68000Wrapper subCpu;
    private TimerContext timerContext;
    private Counter32p5Khz counter32p5Khz;
    final MdM68kBusProvider.BusWriteRunnable wramRunnable = new MdM68kBusProvider.BusWriteRunnable(){

        @Override
        public void run() {
            MegaCdSubCpuBus.this.memCtx.wramHelper.writeWordRam(MegaCdSubCpuBus.this.cpuType, this.address, this.data, this.size);
        }
    };
    AtomicReference<Runnable> wramRunLater = new AtomicReference();
    public static final double counterCddaLimit = 283.4467120181406;
    public static final double counterCdcDmaLimit = 6.0;
    private double counterCddaAcc = 283.4467120181406;
    private double counterCdcDma = 6.0;
    int subCpuResetFrameCount = 0;

    public MegaCdSubCpuBus(MegaCdMemoryContext ctx) {
        this.cpuType = BufferUtil.CpuDeviceAccess.SUB_M68K;
        this.subCpuRam = ByteBuffer.wrap(ctx.prgRam);
        this.sysGateRegs = ctx.getGateSysRegs(this.cpuType);
        this.commonGateRegs = ctx.commonGateRegsBuf;
        this.memCtx = ctx;
        this.timerContext = new TimerContext();
        this.counter32p5Khz = new Counter32p5Khz();
        MegaCdDict.writeSysRegWord(this.memCtx, this.cpuType, MegaCdDict.RegSpecMcd.MCD_RESET, 1);
        MegaCdDict.writeSysRegWord(this.memCtx, this.cpuType, MegaCdDict.RegSpecMcd.MCD_MEM_MODE, 1);
        MegaCdDict.writeCommonRegWord(this.memCtx, this.cpuType, MegaCdDict.RegSpecMcd.MCD_CDD_CONTROL, 256);
        this.attachDevice(BusArbiter.NO_OP);
    }

    @Override
    public MdM68kBusProvider attachDevice(Device device) {
        if (device instanceof McdSubInterruptHandler) {
            McdSubInterruptHandler ih;
            this.interruptHandler = ih = (McdSubInterruptHandler)device;
        }
        if (device instanceof Cdc) {
            Cdc cdc;
            this.cdc = cdc = (Cdc)device;
        }
        if (device instanceof Cdd) {
            Cdd cdd;
            this.cdd = cdd = (Cdd)device;
        }
        if (device instanceof McdPcm) {
            McdPcm pcm;
            this.pcm = pcm = (McdPcm)device;
        }
        if (device instanceof AsicModel.AsicOp) {
            AsicModel.AsicOp asic;
            this.asic = asic = (AsicModel.AsicOp)device;
        }
        if (device instanceof MC68000Wrapper) {
            MC68000Wrapper c = (MC68000Wrapper)device;
            assert (this.subCpu == null);
            this.subCpu = c;
        }
        if (device instanceof SystemProvider) {
            SystemProvider s;
            this.systemProvider = s = (SystemProvider)device;
        }
        return this;
    }

    @Override
    public int read(int address, Size size) {
        assert (MdRuntimeData.getAccessTypeExt() == BufferUtil.CpuDeviceAccess.SUB_M68K);
        assert (Util.assertCheckBusOp(address, size));
        int res = size.getMask();
        if ((address &= 0xFFFFF) >= 524288 && address < 786432) {
            res = this.memCtx.wramSetup.mode == MegaCdMemoryContext.WordRamMode._2M ? this.memCtx.wramHelper.readWordRam(this.cpuType, address, size) : this.memCtx.wramHelper.readDotMapped(address, size);
        } else if (address >= 786432 && address < 917504) {
            assert (this.memCtx.wramSetup.mode == MegaCdMemoryContext.WordRamMode._1M);
            res = this.memCtx.wramHelper.readWordRam(this.cpuType, address & 0x1FFFF, size);
        } else if (address >= 0 && address < 524288) {
            res = this.readPrgRam(address, size);
        } else if (address >= 1015808 && address < 1016320) {
            res = this.handleMegaCdExpRead(address, size);
        } else if (address >= 983040 && address < 1015808) {
            res = this.pcm.read(address, size);
        } else if (address >= 917504 && address < 983040) {
            res = BuramHelper.readBackupRam(this.memCtx.backupRam, address, size);
        } else if (address >= 1015808) {
            LOG.error("S Read Reserved: {} {}", (Object)Util.th(address), (Object)size);
        } else {
            LogHelper.logWarnOnce(LOG, "S Unexpected read access: {} {}", new Object[]{Util.th(address), size});
        }
        return res & size.getMask();
    }

    @Override
    public void write(int address, int data, Size size) {
        assert (MdRuntimeData.getAccessTypeExt() == BufferUtil.CpuDeviceAccess.SUB_M68K);
        assert (Util.assertCheckBusOp(address, size));
        if ((address &= 0xFFFFF) >= 524288 && address < 786432) {
            if (this.memCtx.wramSetup.mode == MegaCdMemoryContext.WordRamMode._2M) {
                if (this.memCtx.wramSetup.cpu == BufferUtil.CpuDeviceAccess.SUB_M68K) {
                    this.memCtx.wramHelper.writeWordRam(this.cpuType, address, data, size);
                } else {
                    this.wramRunnable.address = address;
                    this.wramRunnable.data = data;
                    this.wramRunnable.size = size;
                }
            } else {
                this.memCtx.wramHelper.writeDotMapped(this.asic.getStampPriorityMode(), address, data, size);
            }
        } else if (address >= 786432 && address < 917504) {
            assert (this.memCtx.wramSetup.mode == MegaCdMemoryContext.WordRamMode._1M);
            this.memCtx.wramHelper.writeWordRam(this.cpuType, address, data, size);
        } else if (address >= 0 && address < 524288) {
            this.memCtx.writeProgRam(address & 0x7FFFF, data, size);
        } else if (address >= 1015808 && address <= 1016320) {
            this.handleMegaCdExpWrite(address, data, size);
        } else if (address >= 983040 && address < 1015808) {
            assert (address < 999424);
            this.pcm.write(address, data, size);
        } else if (address >= 917504 && address < 983040) {
            BuramHelper.writeBackupRam(this.memCtx.backupRam, address, data, size);
        } else if (address >= 1015808) {
            LOG.error("S Write Reserved: {} {} {}", new Object[]{address, data, size});
        } else {
            LogHelper.logWarnOnce(LOG, "S Unexpected write access: {} {}", new Object[]{Util.th(address), size});
        }
    }

    private int readPrgRam(int address, Size size) {
        return switch (size) {
            default -> throw new IncompatibleClassChangeError();
            case Size.BYTE, Size.WORD -> BufferUtil.readBuffer(this.subCpuRam, address & 0x7FFFF, size);
            case Size.LONG -> {
                int res = BufferUtil.readBuffer(this.subCpuRam, address & 0x7FFFF, Size.WORD) & 0xFFFF;
                yield res << 16 | BufferUtil.readBuffer(this.subCpuRam, address + 2 & 0x7FFFF, Size.WORD) & 0xFFFF;
            }
        };
    }

    private int handleMegaCdExpRead(int address, Size size) {
        return switch (size) {
            default -> throw new IncompatibleClassChangeError();
            case Size.BYTE, Size.WORD -> this.handleMegaCdExpReadInternal(address, size);
            case Size.LONG -> (this.handleMegaCdExpReadInternal(address, Size.WORD) & 0xFFFF) << 16 | this.handleMegaCdExpReadInternal(address + 2, Size.WORD) & 0xFFFF;
        };
    }

    private int handleMegaCdExpReadInternal(int address, Size size) {
        MegaCdDict.RegSpecMcd regSpec = MegaCdDict.getRegSpec(this.cpuType, address);
        this.logAccess(regSpec, this.cpuType, address, 0, size, true);
        if (regSpec == MegaCdDict.RegSpecMcd.INVALID) {
            LOG.error("M read unknown MEGA_CD_EXP reg: {}", (Object)Util.th(address));
            return 0;
        }
        int res = switch (regSpec.deviceType) {
            case MegaCdDict.McdRegType.CDD -> this.cdd.read(regSpec, address, size);
            case MegaCdDict.McdRegType.CDC -> this.cdc.read(regSpec, address, size);
            case MegaCdDict.McdRegType.ASIC -> this.asic.read(regSpec, address, size);
            default -> BufferUtil.readBuffer(this.memCtx.getRegBuffer(this.cpuType, regSpec), address & 0x1FF, size);
        };
        MegaCdDict.checkRegLongAccess(regSpec, size);
        if (regSpec == MegaCdDict.RegSpecMcd.MCD_COMM_FLAGS) {
            // empty if block
        }
        return res;
    }

    private void handleMegaCdExpWrite(int address, int data, Size size) {
        switch (size) {
            case BYTE: 
            case WORD: {
                this.handleMegaCdExpWriteInternal(address, data, size);
                break;
            }
            case LONG: {
                this.handleMegaCdExpWrite(address, data >> 16, Size.WORD);
                this.handleMegaCdExpWrite(address + 2, data, Size.WORD);
            }
        }
    }

    private void handleMegaCdExpWriteInternal(int address, int data, Size size) {
        MegaCdDict.RegSpecMcd regSpec = MegaCdDict.getRegSpec(this.cpuType, address);
        MegaCdDict.logAccess(regSpec, this.cpuType, address, data, size, false);
        if (regSpec == MegaCdDict.RegSpecMcd.INVALID) {
            LOG.error("M read unknown MEGA_CD_EXP reg: {}", (Object)Util.th(address));
            return;
        }
        if (regSpec.deviceType == MegaCdDict.McdRegType.CDD || regSpec.deviceType == MegaCdDict.McdRegType.CDC) {
            // empty if block
        }
        MegaCdDict.checkRegLongAccess(regSpec, size);
        switch (regSpec.deviceType) {
            case SYS: {
                this.handleSysRegWrite(regSpec, address & 0x1FF, data, size);
                break;
            }
            case COMM: {
                this.handleCommRegWrite(regSpec, address, data, size);
                break;
            }
            case CDD: {
                this.cdd.write(regSpec, address, data, size);
                break;
            }
            case CDC: {
                this.cdc.write(regSpec, address, data, size);
                break;
            }
            case ASIC: {
                this.asic.write(regSpec, address, data, size);
                break;
            }
            default: {
                LOG.error("M read unknown MEGA_CD_EXP reg: {}", (Object)Util.th(address));
            }
        }
    }

    private static void forceLog(MegaCdDict.RegSpecMcd regSpec, BufferUtil.CpuDeviceAccess cpu, int address, int value, Size size, boolean read) {
        LogHelper.doLog = true;
        LOG.info("{} MCD reg {} {} ({}) {} {}", new Object[]{cpu, read ? "read" : "write", size, regSpec.getName(), Util.th(address), ": " + Util.th(value)});
        LogHelper.doLog = false;
    }

    private void handleSysRegWrite(MegaCdDict.RegSpecMcd regSpec, int address, int data, Size size) {
        assert (size != Size.LONG);
        ByteBuffer regs = this.memCtx.getRegBuffer(this.cpuType, regSpec);
        switch (regSpec) {
            case MCD_RESET: {
                this.handleReg0Write(address, data, size);
                break;
            }
            case MCD_MEM_MODE: {
                this.handleReg2Write(address, data, size);
                break;
            }
            case MCD_COMM_FLAGS: {
                LogHelper.logInfo(LOG, "S write COMM_FLAG {}: {} {}", new Object[]{Util.th(address |= 1), Util.th(data), size});
                MegaCdDict.writeReg(this.memCtx, this.cpuType, regSpec, address, data, Size.BYTE);
                MegaCdDict.writeReg(this.memCtx, BufferUtil.CpuDeviceAccess.M68K, regSpec, address, data, Size.BYTE);
                break;
            }
            case MCD_INT_MASK: {
                LogHelper.logInfo(LOG, "S Write Interrupt mask control: {}, {}, {}", new Object[]{Util.th(address), Util.th(data), size});
                boolean changed = BufferUtil.writeBufferRaw(regs, address, data, size);
                if (!changed) break;
                int reg = Util.readBufferByte(this.commonGateRegs, MegaCdDict.RegSpecMcd.MCD_INT_MASK.addr + 1);
                McdSubInterruptHandler.printEnabledInterrupts(reg);
                int val = MegaCdDict.BitRegDef.IEN2.getBitMask() * (reg >> 2 & 1);
                McdRegBitUtil.setBitDefInternal(this.memCtx, BufferUtil.CpuDeviceAccess.M68K, MegaCdDict.BitRegDef.IEN2, val);
                if (val != 0) break;
                McdRegBitUtil.setBitDefInternal(this.memCtx, BufferUtil.CpuDeviceAccess.M68K, MegaCdDict.BitRegDef.IFL2, 0);
                break;
            }
            case MCD_TIMER_INT3: {
                int addr = size == Size.BYTE ? address | 1 : address;
                this.timerContext.counter = this.timerContext.rate = data & 0xFF;
                MegaCdDict.writeReg(this.memCtx, this.cpuType, regSpec, addr, data, size);
                break;
            }
            case MCD_FONT_COLOR: {
                address = size == Size.BYTE ? address | 1 : address;
                MegaCdDict.writeReg(this.memCtx, this.cpuType, regSpec, address, data & 0xFF, size);
                this.recalcFontData(regs);
                break;
            }
            case MCD_FONT_BIT: {
                MegaCdDict.writeReg(this.memCtx, this.cpuType, regSpec, address, data, size);
                this.recalcFontData(regs);
                break;
            }
            default: {
                LogHelper.logWarnOnce(LOG, "S write unhandled MEGA_CD_EXP reg: {} ({}), {} {}", new Object[]{Util.th(address), regSpec, Util.th(data), size});
                MegaCdDict.writeReg(this.memCtx, this.cpuType, regSpec, address, data, size);
            }
        }
    }

    private void recalcFontData(ByteBuffer regs) {
        int colorVal = BufferUtil.readBuffer(regs, MegaCdDict.RegSpecMcd.MCD_FONT_COLOR.addr, Size.WORD);
        short fontData = (short)BufferUtil.readBuffer(regs, MegaCdDict.RegSpecMcd.MCD_FONT_BIT.addr, Size.WORD);
        int background = colorVal & 0xF;
        int foreground = colorVal >> 4 & 0xF;
        int limit = 8;
        for (int i = 0; i < limit; i += 2) {
            int offset = 12 - (i << 1);
            int n1 = Util.getBitFromWord(fontData, offset | 0) > 0 ? foreground : background;
            int n2 = Util.getBitFromWord(fontData, offset | 1) > 0 ? foreground : background;
            int n3 = Util.getBitFromWord(fontData, offset | 2) > 0 ? foreground : background;
            int n4 = Util.getBitFromWord(fontData, offset | 3) > 0 ? foreground : background;
            BufferUtil.writeBufferRaw(regs, MegaCdDict.RegSpecMcd.MCD_FONT_DATA0.addr + i, n4 << 12 | n3 << 8 | n2 << 4 | n1, Size.WORD);
        }
    }

    private void handleReg0Write(int address, int data, Size size) {
        int res = this.memCtx.handleRegWrite(this.cpuType, MegaCdDict.RegSpecMcd.MCD_RESET, address, data, size);
        int sreset = res & 1;
        if ((address & 1) == 0 && size == Size.BYTE) {
            return;
        }
        LOG.info("S SubCpu reset: {}", (Object)(sreset == 0 ? "Reset" : "Ignore"));
        if (sreset == 0) {
            LOG.info("S subCpu peripheral reset started");
            BufferUtil.setBit(this.sysGateRegs, MegaCdDict.RegSpecMcd.MCD_RESET.addr + 1, 0, 1, Size.BYTE);
            this.softReset();
        }
    }

    private void handleReg2Write(int address, int data, Size size) {
        int resWord = this.memCtx.handleRegWrite(this.cpuType, MegaCdDict.RegSpecMcd.MCD_MEM_MODE, address, data, size);
        MegaCdMemoryContext.WramSetup prev = this.memCtx.wramSetup;
        MegaCdMemoryContext.WramSetup ws = this.memCtx.wramHelper.update(this.cpuType, resWord);
        this.handleWramSetupChange(prev, ws);
        if (ws == MegaCdMemoryContext.WramSetup.W_2M_MAIN) {
            McdRegBitUtil.setSharedBitBothCpu(this.memCtx, MegaCdDict.SharedBitDef.DMNA, 0);
        }
        this.asic.setStampPriorityMode(resWord >> 3 & 3);
    }

    @Override
    public void handleWramSetupChange(MegaCdMemoryContext.WramSetup prev, MegaCdMemoryContext.WramSetup ws) {
        Runnable r;
        if (prev != ws && ws.cpu == BufferUtil.CpuDeviceAccess.SUB_M68K && (r = (Runnable)this.wramRunLater.getAndSet(null)) != null) {
            r.run();
            MC68000Wrapper.subCpuBusHalt = false;
            LOG.info("{} released as WRAM set to {}, cpu running: {}, busWrite: {}", new Object[]{this.cpuType, this.memCtx.wramSetup, !this.subCpu.isStopped(), r});
        }
    }

    private void handleCommRegWrite(MegaCdDict.RegSpecMcd regSpec, int address, int data, Size size) {
        if (address >= 1015840 && address < 1015856) {
            LogHelper.logInfo(LOG, "S Write MEGA_CD_COMM: {}, {}, {}", new Object[]{Util.th(address), Util.th(data), size});
            MegaCdDict.writeReg(this.memCtx, this.cpuType, regSpec, address & 0x1FF, data, size);
            return;
        }
        if (address >= 1015824 && address < 1015840) {
            LOG.error("S illegal write read-only MEGA_CD_COMM reg: {}", (Object)Util.th(address));
            return;
        }
    }

    @Override
    public void handleVdpInterrupts68k() {
        throw new RuntimeException("handleVdpInterrupts68k");
    }

    @Override
    public void ackInterrupt68k(int level) {
    }

    @Override
    public void resetFrom68k() {
    }

    @Override
    public boolean is68kRunning() {
        throw new RuntimeException("is68kRunning");
    }

    @Override
    public SystemProvider getSystem() {
        return this.systemProvider;
    }

    public void resetDone() {
        BufferUtil.setBit(this.sysGateRegs, MegaCdDict.RegSpecMcd.MCD_RESET.addr + 1, 0, 1, Size.BYTE);
        BufferUtil.setBit(this.memCtx.getRegBuffer(BufferUtil.CpuDeviceAccess.M68K, MegaCdDict.RegSpecMcd.MCD_RESET), MegaCdDict.RegSpecMcd.MCD_RESET.addr + 1, 0, 1, Size.BYTE);
        LOG.info("S subCpu reset done");
    }

    @Override
    public void onVdpEvent(BaseVdpAdapterEventSupport.VdpEvent event, Object value) {
        if (event == BaseVdpAdapterEventSupport.VdpEvent.V_BLANK_CHANGE && ((Boolean)value).booleanValue()) {
            this.interruptHandler.raiseInterrupt(McdSubInterruptHandler.SubCpuInterrupt.INT_LEVEL2);
        }
    }

    private void timerStep() {
        if (this.timerContext.rate > 0 && --this.timerContext.counter == 0) {
            this.timerContext.counter = this.timerContext.rate;
            this.interruptHandler.raiseInterrupt(McdSubInterruptHandler.SubCpuInterrupt.INT_TIMER);
        }
    }

    @Override
    public McdSubInterruptHandler getInterruptHandler() {
        return this.interruptHandler;
    }

    @Override
    public void step(int cpuCycles) {
        this.counter32p5Khz.cycleAccumulator -= cpuCycles;
        if (this.counter32p5Khz.cycleAccumulator <= 0) {
            --this.counter32p5Khz.cycleAcc75;
            ++this.counter32p5Khz.ticks32p5;
            this.pcm.step(0);
            this.cdc.step(0);
            this.timerStep();
            this.asic.step(0);
            this.counter32p5Khz.cycleAccumulator += 384;
            if (this.counter32p5Khz.cycleAcc75 <= 0) {
                this.cdd.step(0);
                ++this.counter32p5Khz.ticks75;
                this.counter32p5Khz.cycleAcc75 += 434;
            }
        }
        this.counterCddaAcc -= (double)cpuCycles;
        if (this.counterCddaAcc <= 0.0) {
            this.counterCddaAcc += 283.4467120181406;
            this.cdd.stepCdda();
        }
        this.counterCdcDma -= (double)cpuCycles;
        while (this.counterCdcDma <= 0.0) {
            this.counterCdcDma += 6.0;
            this.cdc.dma();
        }
    }

    @Override
    public void onNewFrame() {
        this.logSlowFrames();
        if (this.subCpuResetFrameCount > 0 && --this.subCpuResetFrameCount == 0) {
            this.releaseSubCpuReset();
        }
        if (MegaCdMainCpuBus.subCpuReset && this.subCpuResetFrameCount == 0) {
            this.subCpuResetFrameCount = 6;
        }
    }

    private void releaseSubCpuReset() {
        MegaCdMainCpuBus.subCpuReset = false;
        this.subCpu.reset();
        this.resetDone();
        int bval = Util.readBufferByte(this.memCtx.getGateSysRegs(BufferUtil.CpuDeviceAccess.M68K), MegaCdDict.RegSpecMcd.MCD_RESET.addr + 1);
        int sbusreq = bval >> 1 & 1;
        this.subCpu.setStop(sbusreq > 0);
    }

    @Override
    public int getLedState() {
        return Util.readBufferByte(this.memCtx.getGateSysRegs(BufferUtil.CpuDeviceAccess.SUB_M68K), MegaCdDict.RegSpecMcd.MCD_RESET.addr) & 3;
    }

    public void softReset() {
        MegaCdDict.writeReg(this.memCtx, this.cpuType, MegaCdDict.RegSpecMcd.MCD_RESET, MegaCdDict.RegSpecMcd.MCD_RESET.addr + 1, 1, Size.BYTE);
        MegaCdDict.writeSysRegWord(this.memCtx, this.cpuType, MegaCdDict.RegSpecMcd.MCD_CDC_MODE, 0);
        MegaCdDict.writeSysRegWord(this.memCtx, this.cpuType, MegaCdDict.RegSpecMcd.MCD_STOPWATCH, 0);
        Arrays.fill(this.commonGateRegs.array(), MegaCdDict.RegSpecMcd.MCD_TIMER_INT3.addr, this.commonGateRegs.capacity(), (byte)0);
        MegaCdDict.writeSysRegWord(this.memCtx, this.cpuType, MegaCdDict.RegSpecMcd.MCD_CDC_HOST, 65535);
        MegaCdDict.writeSysRegWord(this.memCtx, this.cpuType, MegaCdDict.RegSpecMcd.MCD_CDC_DMA_ADDRESS, 65535);
        MegaCdDict.writeCommonRegWord(this.memCtx, this.cpuType, MegaCdDict.RegSpecMcd.MCD_CDD_CONTROL, 256);
        MegaCdDict.writeCommonRegWord(this.memCtx, this.cpuType, MegaCdDict.RegSpecMcd.MCD_CDD_COMM4, 15);
        MegaCdDict.writeCommonRegWord(this.memCtx, this.cpuType, MegaCdDict.RegSpecMcd.MCD_CDD_COMM5, 65535);
        MegaCdDict.writeCommonRegWord(this.memCtx, this.cpuType, MegaCdDict.RegSpecMcd.MCD_CDD_COMM6, 65535);
        MegaCdDict.writeCommonRegWord(this.memCtx, this.cpuType, MegaCdDict.RegSpecMcd.MCD_CDD_COMM7, 65535);
        MegaCdDict.writeCommonRegWord(this.memCtx, this.cpuType, MegaCdDict.RegSpecMcd.MCD_CDD_COMM8, 65535);
        MegaCdDict.writeCommonRegWord(this.memCtx, this.cpuType, MegaCdDict.RegSpecMcd.MCD_CDD_COMM9, 65535);
        this.interruptHandler.reset();
        this.cdd.reset();
        this.cdc.reset();
        this.asic.reset();
        this.pcm.reset();
    }

    private void logSlowFrames() {
        ++this.counter32p5Khz.frames;
        if ((this.counter32p5Khz.frames + 1) % this.getSystem().getRegion().getFps() == 0) {
            boolean rangeOk;
            boolean bl = rangeOk = Math.abs(75 - this.counter32p5Khz.ticks75) < 2 && (double)Math.abs(32552 - this.counter32p5Khz.ticks32p5) < 300.0;
            if (this.counter32p5Khz.frames > 100 && !rangeOk) {
                String str = "SubCpu timing off!!!, 32.5Khz: {}, 75hz:{}";
                LOG.warn(str, (Object)this.counter32p5Khz.ticks32p5, (Object)this.counter32p5Khz.ticks75);
            }
            this.counter32p5Khz.ticks75 = 0;
            this.counter32p5Khz.ticks32p5 = 0;
        }
    }

    public void logAccess(MegaCdDict.RegSpecMcd regSpec, BufferUtil.CpuDeviceAccess cpu, int address, int value, Size size, boolean read) {
        this.logHelper.logWarningOnceWhenEnRepeat(LOG, "{} MCD reg {} {} ({}) {} {}", new Object[]{cpu, read ? "read" : "write", size, regSpec.getName(), Util.th(address), !read ? ": " + Util.th(value) : ""});
    }

    public static void logAccessReg(MegaCdDict.RegSpecMcd regSpec, BufferUtil.CpuDeviceAccess cpu, int address, int value, Size size, boolean read) {
        LogHelper.logWarnOnceWhenEn(LOG, "{} MCD reg {} {} ({}) {} {}", new Object[]{cpu, read ? "read" : "write", size, regSpec.getName(), Util.th(address), !read ? ": " + Util.th(value) : ""});
    }

    public static void logAccessReg(MegaCdDict.RegSpecMcd regSpec, BufferUtil.CpuDeviceAccess cpu, int address, Size size, boolean read) {
        LogHelper.logWarnOnceWhenEn(LOG, "{} MCD reg {} {} ({}) {} {}", new Object[]{cpu, read ? "read" : "write", size, regSpec.getName(), Util.th(address)});
    }

    private static class TimerContext {
        public int counter;
        public int rate;

        private TimerContext() {
        }
    }

    private static class Counter32p5Khz {
        public static final int limit = 384;
        public int cycleAccumulator = 384;
        public int cycleAcc75 = 434;
        private int ticks32p5;
        private int ticks75;
        private int frames;

        private Counter32p5Khz() {
        }
    }
}

