/*
 * Decompiled with CFR 0.152.
 */
package mcd.cart;

import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Optional;
import mcd.cdd.CdModel;
import mcd.cdd.ExtendedCueSheet;
import omegadrive.cart.MdCartInfoProvider;
import omegadrive.system.MediaSpecHolder;
import omegadrive.system.SysUtil;
import omegadrive.util.LogHelper;
import omegadrive.util.RegionDetector;
import omegadrive.util.Util;
import omegadrive.vdp.util.MemView;
import org.slf4j.Logger;

public class MegaCdCartInfoProvider
extends MdCartInfoProvider {
    private static final Logger LOG = LogHelper.getLogger(MegaCdCartInfoProvider.class.getSimpleName());
    private static final int headerLen = 16;
    private static final int TRACK01_SECURITY_CODE_START = 512;
    private static final byte[] SCD_SYS_BYTES = "SEGADISCSYSTEM".getBytes();
    private static final byte ff = -1;
    private static final byte[] CD_SYNC_BYTES = new byte[]{0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0};
    private MediaSpecHolder.MediaSpec mediaSpec;
    public SysUtil.RomFileType detectedRomFileType;
    public RegionDetector.Region securityCodeRegion;

    public static MegaCdCartInfoProvider createMcdInstance(MediaSpecHolder.MediaSpec rom) {
        MegaCdCartInfoProvider m = new MegaCdCartInfoProvider(rom);
        m.init();
        return m;
    }

    private MegaCdCartInfoProvider(MediaSpecHolder.MediaSpec rom) {
        super(MegaCdCartInfoProvider.getTrack01(rom));
        this.mediaSpec = rom;
    }

    @Override
    protected void init() {
        super.init();
        this.detectedRomFileType = this.mediaSpec.type;
        this.securityCodeRegion = this.mediaSpec.region;
        if (this.mediaSpec.type.isDiscImage()) {
            Optional<ExtendedCueSheet> sheetOpt = this.mediaSpec.sheetOpt;
            assert (sheetOpt.isPresent());
            CdModel.ExtendedTrackData t1 = sheetOpt.get().extTracks.get(0);
            this.checkTrack01Header(t1);
            this.securityCodeRegion = this.mediaSpec.region;
            if (this.mediaSpec.bootable) {
                this.securityCodeRegion = MegaCdCartInfoProvider.verifySecurityCodeRegion(t1);
            }
            this.romSize = t1.lenBytes;
        }
    }

    private static RandomAccessFile getTrack01(MediaSpecHolder.MediaSpec mediaSpec) {
        Optional<ExtendedCueSheet> sheetOpt = mediaSpec.sheetOpt;
        assert (sheetOpt.isPresent());
        CdModel.ExtendedTrackData t1 = sheetOpt.get().extTracks.get(0);
        return t1.file;
    }

    private void checkTrack01Header(CdModel.ExtendedTrackData track01) {
        SysUtil.RomFileType romFileType = this.mediaSpec.type;
        this.mediaSpec.bootable = true;
        try {
            byte[] header = new byte[16];
            RandomAccessFile raf = track01.file;
            raf.seek(0L);
            CdModel.TrackDataType trackDataType = track01.trackDataType;
            raf.read(header, 0, header.length);
            this.detectedRomFileType = SysUtil.RomFileType.UNKNOWN;
            if (Arrays.equals(SCD_SYS_BYTES, 0, SCD_SYS_BYTES.length, header, 0, SCD_SYS_BYTES.length)) {
                System.out.println("valid Sega CD image");
                this.detectedRomFileType = SysUtil.RomFileType.ISO;
            } else if (Arrays.equals(CD_SYNC_BYTES, 0, CD_SYNC_BYTES.length, header, 0, CD_SYNC_BYTES.length)) {
                System.out.println("CD-ROM synchro pattern");
                this.detectedRomFileType = SysUtil.RomFileType.BIN_CUE;
            } else if (trackDataType == CdModel.TrackDataType.AUDIO) {
                System.out.println("CD-AUDIO");
                this.detectedRomFileType = SysUtil.RomFileType.BIN_CUE;
            } else {
                System.out.println("non bootable Sega CD ISO");
                this.detectedRomFileType = SysUtil.RomFileType.ISO;
                this.mediaSpec.bootable = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error(e.getMessage());
        }
    }

    private static RegionDetector.Region verifySecurityCodeRegion(CdModel.ExtendedTrackData track01) {
        try {
            byte[] secCode = new byte[1792];
            int secCodeStart = track01.trackDataType.size == CdModel.SectorSize.S_2048 ? 512 : 528;
            RandomAccessFile raf = track01.file;
            raf.seek(secCodeStart);
            raf.read(secCode);
            ByteBuffer bb = ByteBuffer.wrap(secCode);
            for (SecurityCodeInfo sci : SecurityCodeInfo.values()) {
                byte[] b = new byte[sci.length];
                bb.position(0);
                bb.get(b);
                String sha1 = Util.computeSha1Sum(b);
                if (!sci.sha1.equalsIgnoreCase(sha1)) continue;
                System.out.println((Object)sci.region);
                return sci.region;
            }
            LOG.error("Unknown security code!");
            StringBuilder sb = new StringBuilder(String.valueOf(track01) + "\n");
            MemView.fillFormattedString(sb, secCode, 0, secCode.length);
            System.out.println(sb);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error(e.getMessage());
        }
        return null;
    }

    @Override
    protected void initChecksum() {
        LOG.info("Skipping checksum for MCD");
    }

    static enum SecurityCodeInfo {
        USA(RegionDetector.Region.USA, "d7b7e8e00cee68e15828197ee5090f5a14acd436", 1412),
        EU(RegionDetector.Region.EUROPE, "4a1946f9aaf7261d9d4ccb0556b7342eaf1cf2f8", 1390),
        JP(RegionDetector.Region.JAPAN, "ffe78f1ffdb8b76b358eb8a29b1d5f9dbeabacca", 342);

        public final RegionDetector.Region region;
        public final String sha1;
        public final int length;

        private SecurityCodeInfo(RegionDetector.Region region, String sha1, int length) {
            this.region = region;
            this.sha1 = sha1;
            this.length = length;
        }
    }
}

