/*
 * Decompiled with CFR 0.152.
 */
package mcd.cdd;

import com.google.common.base.MoreObjects;
import java.io.Closeable;
import java.io.IOException;
import java.io.RandomAccessFile;
import omegadrive.util.LogHelper;
import omegadrive.util.ZipUtil;
import org.digitalmediaserver.cuelib.TrackData;
import org.slf4j.Logger;

public class CdModel {
    private static final Logger LOG = LogHelper.getLogger(CdModel.class.getSimpleName());
    public static final int SECTOR_2352 = SectorSize.S_2352.s_size;

    public static enum SectorSize {
        S_2048(2048),
        S_2352(2352);

        public final int s_size;

        private SectorSize(int s) {
            this.s_size = s;
        }
    }

    public static class ExtendedTrackData
    implements Closeable {
        public static final ExtendedTrackData NO_TRACK = new ExtendedTrackData(null, null);
        public final TrackData trackData;
        public final RandomAccessFile file;
        public TrackDataType trackDataType;
        public int absoluteSectorStart;
        public int absoluteSectorEnd;
        public int lenBytes;
        public int trackLenSectors;

        public ExtendedTrackData(TrackData trackData, RandomAccessFile file) {
            this.trackData = trackData;
            this.file = file;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("trackData", (Object)this.trackData).add("file", (Object)this.file).add("trackDataType", (Object)this.trackDataType).add("absoluteSectorStart", this.absoluteSectorStart).add("absoluteSectorEnd", this.absoluteSectorEnd).add("lenSector", this.trackLenSectors).add("lenBytes", this.lenBytes).toString();
        }

        @Override
        public void close() throws IOException {
            this.closeQuietly();
        }

        public void closeQuietly() {
            ZipUtil.closeQuietly(this.file);
        }
    }

    public static enum TrackDataType {
        MODE1_2352(TrackMode.MODE1, SectorSize.S_2352, TrackContent.T_DATA),
        MODE1_2048(TrackMode.MODE1, SectorSize.S_2048, TrackContent.T_DATA),
        AUDIO(TrackMode.MODE1, SectorSize.S_2352, TrackContent.T_AUDIO);

        public final TrackMode mode;
        public final SectorSize size;
        public final TrackContent content;

        private TrackDataType(TrackMode mode, SectorSize sectorSize, TrackContent content) {
            this.mode = mode;
            this.size = sectorSize;
            this.content = content;
        }

        public static TrackDataType parse(String spec) {
            String s = spec.toUpperCase();
            if (s.contains(TrackMode.MODE1.name()) && s.contains("" + SectorSize.S_2352.s_size)) {
                return MODE1_2352;
            }
            if (s.contains(TrackMode.MODE1.name()) && s.contains("" + SectorSize.S_2048.s_size)) {
                return MODE1_2048;
            }
            if (s.equals(AUDIO.name())) {
                return AUDIO;
            }
            LOG.error("Unable to parse: {}", (Object)spec);
            return null;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.name()).add("mode", (Object)this.mode).add("size", (Object)this.size).add("content", (Object)this.content).toString();
        }
    }

    public static enum TrackMode {
        MODE1,
        MODE2;

    }

    public static enum TrackContent {
        T_AUDIO,
        T_DATA;

    }
}

