/*
 * Decompiled with CFR 0.152.
 */
package mcd.cdd;

import java.util.concurrent.atomic.AtomicBoolean;
import mcd.bus.McdSubInterruptHandler;
import mcd.cdc.Cdc;
import mcd.cdd.CdModel;
import mcd.cdd.Cdd;
import mcd.cdd.ExtendedCueSheet;
import mcd.dict.MegaCdDict;
import mcd.dict.MegaCdMemoryContext;
import mcd.pcm.BlipPcmProvider;
import omegadrive.sound.PcmProvider;
import omegadrive.sound.SoundProvider;
import omegadrive.sound.msumd.CueFileParser;
import omegadrive.util.BufferUtil;
import omegadrive.util.FileUtil;
import omegadrive.util.LogHelper;
import omegadrive.util.RegionDetector;
import omegadrive.util.Size;
import omegadrive.util.Util;
import omegadrive.util.VideoMode;
import org.slf4j.Logger;

class CddImpl
implements Cdd {
    private static final Logger LOG = LogHelper.getLogger(CddImpl.class.getSimpleName());
    private final boolean verbose = false;
    private final boolean verboseReg = false;
    private static final int CD_LATENCY = 1;
    public final Cdd.CddContext cddContext = Cdd.CddContext.create(Cdd.CddIo.create());
    private final MegaCdMemoryContext memoryContext;
    private final McdSubInterruptHandler interruptHandler;
    private final Cdc cdc;
    private final PcmProvider playSupport;
    private ExtendedCueSheet extCueSheet;
    private final CueFileParser.MsfHolder msfHolder = new CueFileParser.MsfHolder();
    private boolean hasMedia;
    String prev = "";
    private boolean once = false;
    private int prevStatus1 = 0;
    AtomicBoolean processReceived = new AtomicBoolean();

    public CddImpl(MegaCdMemoryContext mc, McdSubInterruptHandler ih, Cdc c) {
        this.memoryContext = mc;
        this.interruptHandler = ih;
        this.cdc = c;
        this.playSupport = SoundProvider.ENABLE_SOUND ? new BlipPcmProvider("CDDA", RegionDetector.Region.USA, 44100.0) : BlipPcmProvider.NO_SOUND;
        this.setDataOrMusicBit(Cdd.CddControl_DM_bit.DATA_1);
        this.setIoStatus(Cdd.CddStatus.NoDisc);
        this.statusChecksum();
        this.commandChecksum();
    }

    @Override
    public void tryInsert(ExtendedCueSheet cueSheet) {
        cueSheet.assertReady();
        this.extCueSheet = cueSheet;
        boolean bl = this.hasMedia = this.extCueSheet.cueSheet != null;
        if (!this.hasMedia) {
            this.setIoStatus(Cdd.CddStatus.NoDisc);
            return;
        }
        this.setIoStatus(Cdd.CddStatus.ReadingTOC);
        this.setSector(-1);
        this.cddContext.io.tocRead = 0;
        this.cddContext.io.sample = 0;
        this.cddContext.io.track = 0;
        this.cdc.setMedia(this.extCueSheet);
        LOG.info("Using disc: {}", (Object)this.extCueSheet);
    }

    @Override
    public void write(MegaCdDict.RegSpecMcd regSpec, int address, int value, Size size) {
        switch (regSpec) {
            case MCD_CDD_CONTROL: {
                assert ((value & 3) == 0);
                value &= 7;
                assert (this.memoryContext.getRegBuffer(BufferUtil.CpuDeviceAccess.SUB_M68K, regSpec) == this.memoryContext.commonGateRegsBuf);
                BufferUtil.writeBufferRaw(this.memoryContext.commonGateRegsBuf, address & 0x1FF, value, size);
                if (this.cddContext.hostClockEnable == 0 && (value & 4) > 0) {
                    this.interruptHandler.raiseInterrupt(McdSubInterruptHandler.SubCpuInterrupt.INT_CDD);
                }
                this.cddContext.hostClockEnable = value & 4;
                assert ((value & 0xFEFB) == 0) : Util.th(value);
                break;
            }
            case MCD_CDD_COMM5: 
            case MCD_CDD_COMM6: 
            case MCD_CDD_COMM7: 
            case MCD_CDD_COMM8: 
            case MCD_CDD_COMM9: {
                switch (size) {
                    case BYTE: {
                        this.writeCommByte(regSpec, address, value);
                        break;
                    }
                    case WORD: {
                        this.writeCommByte(regSpec, address, value >>> 8);
                        this.writeCommByte(regSpec, address + 1, value);
                        break;
                    }
                    case LONG: {
                        this.writeCommByte(regSpec, address, value >>> 24);
                        this.writeCommByte(regSpec, address + 1, value >>> 16);
                        this.writeCommByte(regSpec, address + 2, value >>> 8);
                        this.writeCommByte(regSpec, address + 3, value);
                    }
                }
                break;
            }
            case MCD_CD_FADER: {
                assert (size == Size.WORD);
                break;
            }
            default: {
                LOG.error("S CDD Write {}: {} {} {}", new Object[]{regSpec, Util.th(address), Util.th(value), size});
                assert (false);
                break;
            }
        }
    }

    @Override
    public int read(MegaCdDict.RegSpecMcd regSpec, int address, Size size) {
        assert (this.memoryContext.getRegBuffer(BufferUtil.CpuDeviceAccess.SUB_M68K, regSpec) == this.memoryContext.commonGateRegsBuf);
        int res = BufferUtil.readBuffer(this.memoryContext.commonGateRegsBuf, address & 0x1FF, size);
        return res;
    }

    private void writeCommByte(MegaCdDict.RegSpecMcd regSpec, int addr, int value) {
        int index = (addr & 0x1FF) - MegaCdDict.RegSpecMcd.MCD_CDD_COMM5.addr;
        this.updateCommand(index, value & 0xF);
        switch (regSpec) {
            case MCD_CDD_COMM9: {
                if ((addr & 1) != 1) break;
                this.logStatus(true);
                this.cdd_process();
                this.logStatus(true);
            }
        }
    }

    private void statusChecksum() {
        this.updateStatus(9, Cdd.getCddChecksum(this.cddContext.statusRegs));
    }

    private boolean commandChecksum() {
        int checksum = Cdd.getCddChecksum(this.cddContext.commandRegs);
        this.updateCommand(9, checksum);
        return checksum == this.cddContext.commandRegs[9];
    }

    private String statusString(int[] status, int[] command) {
        Object head = "";
        Object tail = "";
        for (int i = 0; i < status.length; ++i) {
            head = (String)head + Integer.toHexString(status[i]);
            tail = (String)tail + Integer.toHexString(command[i]);
            if (i != 1 && i != 7) continue;
            head = (String)head + ".";
            tail = (String)tail + ".";
        }
        return ((String)head).toUpperCase() + " - " + ((String)tail).toUpperCase();
    }

    private void logStatus(boolean process) {
        this.logStatus(process, false);
    }

    private void logStatus(boolean process, boolean force) {
        String stat = "_CDD," + this.statusString(this.cddContext.statusRegs, this.cddContext.commandRegs);
        if (force || !stat.equals(this.prev)) {
            this.prev = stat;
        }
    }

    @Override
    public void logStatus() {
        this.logStatus(false);
    }

    @Override
    public void step(int cycles) {
        this.logStatus(false, true);
        if (!this.hasMedia || this.cddContext.hostClockEnable == 0) {
            return;
        }
        this.interruptHandler.raiseInterrupt(McdSubInterruptHandler.SubCpuInterrupt.INT_CDD);
        if (this.cddContext.io.latency > 0) {
            --this.cddContext.io.latency;
            if (this.cddContext.io.latency == 0) {
                this.updateStatus(0, this.cddContext.io.status.ordinal());
                this.once = false;
            }
            return;
        }
        if (this.cddContext.io.status == Cdd.CddStatus.ReadingTOC) {
            return;
        }
        if (this.cddContext.io.status == Cdd.CddStatus.Playing) {
            boolean isDataTrack;
            if (this.cddContext.io.sector >= this.extCueSheet.sectorEnd) {
                this.setIoStatus(Cdd.CddStatus.LeadOut);
                LOG.warn("LeadOut");
                return;
            }
            CdModel.ExtendedTrackData etd = ExtendedCueSheet.getExtTrack(this.extCueSheet, this.cddContext.io.track);
            boolean bl = isDataTrack = etd.trackDataType != CdModel.TrackDataType.AUDIO;
            if (isDataTrack) {
                this.cdc.cdc_decoder_update(this.cddContext.io.sector, this.cddContext.io.track, this.cddContext.io.status);
                this.setSector(this.cddContext.io.sector + 1);
            } else {
                if (this.cddContext.io.sector >= etd.absoluteSectorStart) {
                    this.setDataOrMusicBit(Cdd.CddControl_DM_bit.MUSIC_0);
                }
                this.cdc.cdc_decoder_update(this.cddContext.io.sector, this.cddContext.io.track, this.cddContext.io.status);
            }
        } else {
            this.cdc.cdc_decoder_update(this.cddContext.io.sector, this.cddContext.io.track, this.cddContext.io.status);
        }
        int nt = this.inTrack(this.cddContext.io.sector);
        if (this.cddContext.io.sector >= 0 && nt != this.cddContext.io.track) {
            LOG.warn("Track changed: {}->{}, EOD track sector: {}", new Object[]{this.cddContext.io.track, nt, this.cddContext.io.sector});
            this.setTrack(nt);
        }
        if (this.cddContext.io.status == Cdd.CddStatus.Scanning) assert (false);
    }

    void cdd_process() {
        Cdd.CddCommand cddCommand = Cdd.commandVals[this.cddContext.commandRegs[0]];
        boolean isAudio = this.cddContext.io.track > 0 ? ExtendedCueSheet.isAudioTrack(this.extCueSheet, this.cddContext.io.track) : false;
        StringBuilder extraInfo = new StringBuilder();
        switch (cddCommand) {
            case DriveStatus: {
                if (this.cddContext.io.latency > 3) break;
                this.updateStatus(0, this.cddContext.io.status.ordinal());
                if (this.cddContext.statusRegs[1] == 15) {
                    int lba = this.cddContext.io.sector + 150;
                    CueFileParser.toMSF(lba, this.msfHolder);
                    this.updateStatusesMsf(0, this.getFlags(isAudio), this.msfHolder);
                    break;
                }
                if (this.cddContext.statusRegs[1] == 0) {
                    int lba = this.hasMedia ? this.cddContext.io.sector + 150 : 0;
                    CueFileParser.toMSF(lba, this.msfHolder);
                    this.updateStatusesMsf(this.cddContext.statusRegs[1], this.getFlags(isAudio), this.msfHolder);
                    break;
                }
                if (this.cddContext.statusRegs[1] == 1) {
                    CdModel.ExtendedTrackData etd = ExtendedCueSheet.getExtTrack(this.extCueSheet, this.cddContext.io.track);
                    int lba = this.cddContext.io.sector - etd.absoluteSectorStart + 150;
                    CueFileParser.toMSF(lba, this.msfHolder);
                    this.updateStatusesMsf(this.cddContext.statusRegs[1], this.getFlags(isAudio), this.msfHolder);
                    break;
                }
                if (this.cddContext.statusRegs[1] != 2) break;
                this.updateStatus(2, this.cddContext.io.track / 10);
                this.updateStatus(3, this.cddContext.io.track % 10);
                break;
            }
            case Stop: {
                this.setIoStatus(this.hasMedia ? Cdd.CddStatus.ReadingTOC : Cdd.CddStatus.NoDisc);
                this.setDataOrMusicBit(Cdd.CddControl_DM_bit.DATA_1);
                this.updateStatus(0, Cdd.CddStatus.Stopped.ordinal());
                this.updateStatuses(0, 0, 0, 0, 0, 0, 0, 0);
                break;
            }
            case Request: {
                this.handleRequestCommand(isAudio, extraInfo);
                break;
            }
            case SeekPlay: {
                int index = 0;
                int lba = CueFileParser.toSector(this.cddContext.commandRegs[2], this.cddContext.commandRegs[3], this.cddContext.commandRegs[4], this.cddContext.commandRegs[5], this.cddContext.commandRegs[6], this.cddContext.commandRegs[7]) - 150;
                CueFileParser.toMSF((lba -= 3) + 3 + 150, this.msfHolder);
                extraInfo.append("lba " + (lba + 3 + 150) + ", msf " + String.valueOf(this.msfHolder));
                if (this.cddContext.io.latency == 0) {
                    this.cddContext.io.latency = 11;
                }
                this.cddContext.io.latency = lba > this.cddContext.io.sector ? (this.cddContext.io.latency += (lba - this.cddContext.io.sector) * 120 * 1 / 270000) : (this.cddContext.io.latency += (this.cddContext.io.sector - lba) * 120 * 1 / 270000);
                int minLatency = 11;
                this.cddContext.io.latency = Math.max(this.cddContext.io.latency, minLatency);
                this.setSector(lba);
                index = this.inTrack(this.cddContext.io.sector);
                if (index == 0) {
                    index = 1;
                }
                CdModel.ExtendedTrackData etd = ExtendedCueSheet.getExtTrack(this.extCueSheet, index);
                if (ExtendedCueSheet.isAudioTrack(this.extCueSheet, index) && lba < etd.absoluteSectorStart) {
                    this.setSector(etd.absoluteSectorStart);
                }
                this.setTrack(index);
                this.setDataOrMusicBit(Cdd.CddControl_DM_bit.DATA_1);
                this.setIoStatus(Cdd.CddStatus.Playing);
                this.updateStatus(0, Cdd.CddStatus.Seeking.ordinal());
                this.updateStatuses(15, 0, 0, 0, 0, 0, 0, 0);
                break;
            }
            case SeekPause: {
                int index = 0;
                int lba = CueFileParser.toSector(this.cddContext.commandRegs[2], this.cddContext.commandRegs[3], this.cddContext.commandRegs[4], this.cddContext.commandRegs[5], this.cddContext.commandRegs[6], this.cddContext.commandRegs[7]) - 150;
                CueFileParser.toMSF((lba -= 3) + 150 + 3, this.msfHolder);
                extraInfo.append("lba " + (lba + 150 + 3) + ", msf " + String.valueOf(this.msfHolder));
                if (this.cddContext.io.latency == 0) {
                    this.cddContext.io.latency = 11;
                }
                this.cddContext.io.latency = lba > this.cddContext.io.sector ? (this.cddContext.io.latency += (lba - this.cddContext.io.sector) * 120 * 1 / 270000) : (this.cddContext.io.latency += (this.cddContext.io.sector - lba) * 120 * 1 / 270000);
                int minLatency = 11;
                this.cddContext.io.latency = Math.max(this.cddContext.io.latency, minLatency);
                this.setSector(lba);
                index = this.inTrack(this.cddContext.io.sector);
                if (index == 0) {
                    index = 1;
                }
                CdModel.ExtendedTrackData etd = ExtendedCueSheet.getExtTrack(this.extCueSheet, index);
                if (ExtendedCueSheet.isAudioTrack(this.extCueSheet, index) && lba < etd.absoluteSectorStart) {
                    this.setSector(etd.absoluteSectorStart);
                }
                this.setTrack(index);
                this.setDataOrMusicBit(Cdd.CddControl_DM_bit.DATA_1);
                this.setIoStatus(Cdd.CddStatus.Paused);
                this.updateStatus(0, Cdd.CddStatus.Seeking.ordinal());
                this.updateStatuses(15, 0, 0, 0, 0, 0, 0, 0);
                break;
            }
            case Pause: {
                this.setDataOrMusicBit(Cdd.CddControl_DM_bit.DATA_1);
                this.setIoStatus(Cdd.CddStatus.Paused);
                this.updateStatus(0, Cdd.CddStatus.Paused.ordinal());
                break;
            }
            case Play: {
                this.setIoStatus(Cdd.CddStatus.Playing);
                this.updateStatus(0, Cdd.CddStatus.Playing.ordinal());
                break;
            }
            case Forward: {
                assert (false);
                this.setIoStatus(Cdd.CddStatus.Scanning);
                this.updateStatus(0, Cdd.CddStatus.Scanning.ordinal());
                break;
            }
            case Reverse: {
                assert (false);
                this.setIoStatus(Cdd.CddStatus.Scanning);
                this.updateStatus(0, Cdd.CddStatus.Scanning.ordinal());
                break;
            }
            case TrackSkip: {
                this.setDataOrMusicBit(Cdd.CddControl_DM_bit.DATA_1);
                this.setIoStatus(Cdd.CddStatus.Paused);
                this.updateStatus(0, Cdd.CddStatus.Paused.ordinal());
                break;
            }
            case DoorClose: {
                this.setDataOrMusicBit(Cdd.CddControl_DM_bit.DATA_1);
                this.setIoStatus(this.hasMedia ? Cdd.CddStatus.ReadingTOC : Cdd.CddStatus.NoDisc);
                this.updateStatus(0, Cdd.CddStatus.Stopped.ordinal());
                this.updateStatuses(0, 0, 0, 0, 0, 0, 0, 0);
                break;
            }
            case DoorOpen: {
                this.setDataOrMusicBit(Cdd.CddControl_DM_bit.DATA_1);
                this.setIoStatus(Cdd.CddStatus.DoorOpened);
                this.updateStatus(0, Cdd.CddStatus.DoorOpened.ordinal());
                this.updateStatuses(0, 0, 0, 0, 0, 0, 0, 0);
                break;
            }
            default: {
                this.updateStatus(0, this.cddContext.io.status.ordinal());
                LOG.error("Unsupported Cdd command: {}({}), parameter: {}", new Object[]{cddCommand, cddCommand.ordinal(), this.cddContext.commandRegs[3]});
                assert (false);
                break;
            }
        }
        this.statusChecksum();
        this.processReceived.set(true);
    }

    private void handleRequestCommand(boolean isAudio, StringBuilder extraInfo) {
        Cdd.CddRequest request = Cdd.requestVals[this.cddContext.commandRegs[3]];
        extraInfo.append(" " + String.valueOf((Object)request) + "(" + request.ordinal() + ") ");
        switch (request) {
            case AbsoluteTime: {
                int lba = this.cddContext.io.sector + 150;
                if (this.cddContext.io.track == 0) {
                    this.updateStatus(1, Cdd.CddRequest.NotReady.ordinal());
                    break;
                }
                CueFileParser.toMSF(lba, this.msfHolder);
                this.updateStatus(0, this.cddContext.io.status.ordinal());
                this.updateStatusesMsf(request.ordinal(), this.getFlags(isAudio), this.msfHolder);
                break;
            }
            case RelativeTime: {
                if (this.cddContext.io.track == 0) {
                    this.updateStatus(1, Cdd.CddRequest.NotReady.ordinal());
                    break;
                }
                CdModel.ExtendedTrackData etd = ExtendedCueSheet.getExtTrack(this.extCueSheet, this.cddContext.io.track);
                int lba = Math.max(0, this.cddContext.io.sector - etd.absoluteSectorStart);
                CueFileParser.toMSF(lba, this.msfHolder);
                this.updateStatus(0, this.cddContext.io.status.ordinal());
                this.updateStatusesMsf(request.ordinal(), this.getFlags(isAudio), this.msfHolder);
                break;
            }
            case TrackInformation: {
                if (this.cddContext.io.track == 0) {
                    this.updateStatus(1, Cdd.CddRequest.NotReady.ordinal());
                    break;
                }
                int rs6 = 0;
                int tno = this.cddContext.io.track <= this.extCueSheet.numTracks ? this.cddContext.io.track : 170;
                int rs2 = tno / 10;
                int rs3 = tno % 10;
                this.updateStatus(0, this.cddContext.io.status.ordinal());
                this.updateStatuses(request.ordinal(), rs2, rs3, 0, 0, rs6, 0, this.getFlags(isAudio));
                break;
            }
            case DiscCompletionTime: {
                int lba = this.hasMedia ? this.extCueSheet.sectorEnd + 150 : 0;
                CueFileParser.toMSF(lba, this.msfHolder);
                this.updateStatus(0, this.cddContext.io.status.ordinal());
                this.updateStatusesMsf(request.ordinal(), this.getFlags(isAudio), this.msfHolder);
                break;
            }
            case DiscTracks: {
                int firstTrack = this.hasMedia ? 1 : 0;
                int lastTrack = this.hasMedia ? this.extCueSheet.numTracks : 0;
                this.updateStatus(0, this.cddContext.io.status.ordinal());
                int rs6 = 0;
                int rs7 = 0;
                this.updateStatuses(request.ordinal(), firstTrack / 10, firstTrack % 10, lastTrack / 10, lastTrack % 10, rs6, rs7, this.getFlags(isAudio));
                break;
            }
            case TrackStartTime: {
                int track = this.cddContext.commandRegs[4] * 10 + this.cddContext.commandRegs[5];
                extraInfo.append("\n\tTrack: 0x" + Util.th(track));
                CdModel.ExtendedTrackData extTrackData = ExtendedCueSheet.getExtTrack(this.extCueSheet, track);
                if (extTrackData == CdModel.ExtendedTrackData.NO_TRACK) {
                    this.updateStatus(1, Cdd.CddRequest.NotReady.ordinal());
                    this.updateStatus(8, this.getFlags(isAudio));
                    break;
                }
                CueFileParser.toMSF(extTrackData.absoluteSectorStart + 150, this.msfHolder);
                int status6 = (isAudio ? 0 : 8) | this.msfHolder.frame / 10;
                this.updateStatus(0, this.cddContext.io.status.ordinal());
                this.updateStatuses(request.ordinal(), this.msfHolder.minute / 10, this.msfHolder.minute % 10, this.msfHolder.second / 10, this.msfHolder.second % 10, status6, this.msfHolder.frame % 10, track % 10);
                break;
            }
            case ErrorInformation: {
                this.updateStatus(0, this.cddContext.io.status.ordinal());
                this.updateStatuses(request.ordinal(), 0, 0, 0, 0, 0, 0, 0);
                assert (false);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    private int getFlags(boolean isAudio) {
        int rs8;
        int n = rs8 = isAudio ? 0 : 4;
        rs8 = this.cddContext.io.status != Cdd.CddStatus.Playing ? (rs8 |= 1) : (rs8 |= 0);
        return rs8;
    }

    @Override
    public void stepCdda() {
        int left = 0;
        int right = 0;
        if (this.cddContext.io.status == Cdd.CddStatus.Playing && ExtendedCueSheet.isAudioTrack(this.extCueSheet, this.cddContext.io.track)) {
            CdModel.ExtendedTrackData etd = ExtendedCueSheet.getExtTrack(this.extCueSheet, this.cddContext.io.track);
            int sectorSize = etd.trackDataType.size.s_size;
            int trackRelSector = this.cddContext.io.sector - etd.absoluteSectorStart;
            assert (trackRelSector >= 0);
            try {
                etd.file.seek(sectorSize * trackRelSector + this.cddContext.io.sample);
                left = FileUtil.readShortLE(etd.file);
                right = FileUtil.readShortLE(etd.file);
                this.cddContext.io.sample += 4;
                if (this.cddContext.io.sample >= sectorSize) {
                    this.advance();
                }
            }
            catch (Exception e) {
                LOG.error("Unable to seek to sector: {}", (Object)this.cddContext.io.sector, (Object)e);
            }
        }
        this.playSupport.playSample(left, right);
    }

    private void advance() {
        int track = this.inTrack(this.cddContext.io.sector + 1);
        BufferUtil.setBit(this.memoryContext.getRegBuffer(BufferUtil.CpuDeviceAccess.SUB_M68K, MegaCdDict.RegSpecMcd.MCD_CDD_CONTROL), MegaCdDict.RegSpecMcd.MCD_CDD_CONTROL.addr + 1, 1, 0, Size.BYTE);
        if (track > 0) {
            this.setTrack(track);
            this.setSector(this.cddContext.io.sector + 1);
            this.cddContext.io.sample = 0;
            return;
        }
        this.setIoStatus(Cdd.CddStatus.LeadOut);
        this.setTrack(170);
    }

    private void setDataOrMusicBit(Cdd.CddControl_DM_bit val) {
        BufferUtil.writeBufferRaw(this.memoryContext.commonGateRegsBuf, MegaCdDict.RegSpecMcd.MCD_CDD_CONTROL.addr, val.ordinal(), Size.BYTE);
    }

    private int inTrack(int lba) {
        for (CdModel.ExtendedTrackData ext : this.extCueSheet.extTracks) {
            if (lba < ext.absoluteSectorStart || lba >= ext.absoluteSectorEnd) continue;
            return ext.trackData.getNumber();
        }
        assert (lba < 0);
        return 0;
    }

    private void setTrack(int track) {
        assert (track > 0);
        if (track != this.cddContext.io.track) {
            this.cddContext.io.track = track;
            Cdd.CddControl_DM_bit bit = ExtendedCueSheet.isAudioTrack(this.extCueSheet, track) ? Cdd.CddControl_DM_bit.MUSIC_0 : Cdd.CddControl_DM_bit.DATA_1;
            this.setDataOrMusicBit(bit);
        }
    }

    private void setIoStatus(Cdd.CddStatus status) {
        if (status != this.cddContext.io.status) {
            this.cddContext.io.status = status;
        }
    }

    private void setSector(int s) {
        if (s != this.cddContext.io.sector) {
            this.cddContext.io.sector = s;
        }
    }

    private void updateStatuses(int ... vals) {
        assert (vals.length == 8);
        for (int i = 1; i < 9; ++i) {
            this.updateStatus(i, vals[i - 1]);
        }
    }

    private void updateStatusesMsf(int status1, int status8, CueFileParser.MsfHolder msfHolder) {
        this.updateStatuses(status1, msfHolder.minute / 10, msfHolder.minute % 10, msfHolder.second / 10, msfHolder.second % 10, msfHolder.frame / 10, msfHolder.frame % 10, status8);
    }

    private void updateStatus(int pos, int val) {
        this.cddContext.statusRegs[pos] = val;
        BufferUtil.writeBufferRaw(this.memoryContext.commonGateRegsBuf, MegaCdDict.RegSpecMcd.MCD_CDD_COMM0.addr + pos, val, Size.BYTE);
        if (pos != 9) {
            this.statusChecksum();
        }
    }

    private void updateCommand(int pos, int val) {
        this.cddContext.commandRegs[pos] = val;
        BufferUtil.writeBufferRaw(this.memoryContext.commonGateRegsBuf, MegaCdDict.RegSpecMcd.MCD_CDD_COMM5.addr + pos, val, Size.BYTE);
    }

    private void clearCommandRegs() {
        for (int i = 0; i < 8; ++i) {
            this.updateCommand(i, 0);
        }
        this.commandChecksum();
    }

    @Override
    public Cdd.CddContext getCddContext() {
        return this.cddContext;
    }

    @Override
    public void updateVideoMode(VideoMode videoMode) {
        this.playSupport.updateRegion(videoMode.getRegion());
    }

    @Override
    public void newFrame() {
        this.playSupport.newFrame();
    }

    @Override
    public void close() {
        this.playSupport.close();
    }

    @Override
    public void reset() {
        this.playSupport.reset();
    }
}

