/*
 * Decompiled with CFR 0.152.
 */
package mcd.dict;

import java.util.HashSet;
import java.util.Set;
import mcd.dict.MegaCdMemoryContext;
import omegadrive.util.BufferUtil;
import omegadrive.util.LogHelper;
import omegadrive.util.RegSpec;
import omegadrive.util.Size;
import omegadrive.util.Util;
import org.slf4j.Logger;

public class MegaCdDict {
    private static final Logger LOG = LogHelper.getLogger(MegaCdDict.class.getSimpleName());
    private static final boolean verbose = false;
    public static final int MDC_SUB_GATE_REGS_SIZE = 512;
    public static final int MDC_SUB_GATE_REGS_MASK = 511;
    public static RegSpecMcd[][] mcdRegMapping = new RegSpecMcd[McdRegCpuType.values().length][511];
    public static Set<Integer> z80RegAccess = new HashSet<Integer>();
    public static final int MCD_MAIN_MODE1_MASK = 0x400000;
    public static final int M68K_START_HINT_VECTOR_WRITEABLE = 112;
    public static final int M68K_END_HINT_VECTOR_WRITEABLE = 116;
    public static final int M68K_START_HINT_VECTOR_WRITEABLE_M1 = 0x400070;
    public static final int M68K_END_HINT_VECTOR_WRITEABLE_M1 = 0x400074;
    public static final int MCD_MAIN_PRG_RAM_WINDOW_SIZE = 131072;
    public static final int MCD_MAIN_PRG_RAM_WINDOW_MASK = 131071;
    public static final int START_MCD_MAIN_PRG_RAM = 131072;
    public static final int END_MCD_MAIN_PRG_RAM = 262144;
    public static final int START_MCD_MAIN_PRG_RAM_MODE1 = 0x420000;
    public static final int END_MCD_MAIN_PRG_RAM_MODE1 = 0x440000;
    public static final int END_MCD_MAIN_PRG_RAM_MIRROR_MODE1 = 0x600000;
    public static final int START_MCD_MAIN_WORD_RAM = 0x200000;
    public static final int END_MCD_MAIN_WORD_RAM_MIRROR = 0x400000;
    public static final int START_MCD_MAIN_WORD_RAM_MODE1 = 0x600000;
    public static final int END_MCD_MAIN_WORD_RAM_MIRROR_MODE1 = 0x800000;
    public static final int MCD_BOOT_ROM_WINDOW_SIZE = 131072;
    public static final int MCD_BOOT_ROM_MASK = 131071;
    public static final int START_MCD_BOOT_ROM = 0;
    public static final int MCD_BOOT_ROM_PRGRAM_WINDOW_MASK = 262143;
    public static final int END_MCD_BOOT_ROM = 131072;
    public static final int START_MCD_BOOT_ROM_MODE1 = 0x400000;
    public static final int END_MCD_BOOT_ROM_MIRROR_MODE1 = 0x600000;
    public static final int START_MCD_MAIN_GA_COMM_R = 10559504;
    public static final int END_MCD_MAIN_GA_COMM_R = 10559536;
    public static final int START_MCD_MAIN_GA_COMM_W = 10559504;
    public static final int END_MCD_MAIN_GA_COMM_W = 10559520;
    public static final int MCD_SUB_ADDRESS_MASK = 1048575;
    public static final int START_MCD_SUB_PRG_RAM = 0;
    public static final int END_MCD_SUB_PRG_RAM = 524288;
    public static final int MCD_SUB_BRAM_SIZE = 8192;
    public static final int MCD_SUB_BRAM_MEMORY_WINDOW = 16384;
    public static final int MCD_SUB_BRAM_MEM_WINDOW_MASK = 16383;
    public static final int START_MCD_SUB_BRAM_AREA = 917504;
    public static final int END_MCD_SUB_BRAM_AREA = 983040;
    public static final int START_MCD_SUB_PCM_AREA = 983040;
    public static final int END_MCD_SUB_PCM_AREA = 1015808;
    public static final int START_MCD_SUB_GATE_ARRAY_REGS = 1015808;
    public static final int END_MCD_SUB_GATE_ARRAY_REGS = 1016320;
    public static final int START_MCD_SUB_GA_COMM_W = 1015840;
    public static final int END_MCD_SUB_GA_COMM_W = 1015856;
    public static final int START_MCD_SUB_GA_COMM_R = 1015824;
    public static final int END_MCD_SUB_GA_COMM_R = 1015856;
    public static final int START_MCD_SUB_WORD_RAM_2M = 524288;
    public static final int END_MCD_SUB_WORD_RAM_2M = 786432;
    public static final int START_MCD_SUB_WORD_RAM_1M = 786432;
    public static final int END_MCD_SUB_WORD_RAM_1M = 917504;

    private static McdRegCpuType getCpuTypeFromDevice(McdRegType deviceType, McdRegCpuType baseType) {
        return deviceType == McdRegType.ASIC ? McdRegCpuType.REG_SUB : baseType;
    }

    public static void logAccess(RegSpecMcd regSpec, BufferUtil.CpuDeviceAccess cpu, int address, int value, Size size, boolean read) {
    }

    public static RegSpecMcd getRegSpec(BufferUtil.CpuDeviceAccess cpu, int address) {
        int idx;
        assert (cpu != BufferUtil.CpuDeviceAccess.Z80);
        RegSpecMcd r = mcdRegMapping[McdRegCpuType.REG_BOTH.ordinal()][address & 0x1FF];
        if (r == null && (r = mcdRegMapping[idx = cpu == BufferUtil.CpuDeviceAccess.M68K ? McdRegCpuType.REG_MAIN.ordinal() : McdRegCpuType.REG_SUB.ordinal()][address & 0x1FF]) == null) {
            LogHelper.logWarnOnce(LOG, "{} unknown register at address: {}", new Object[]{cpu, Util.th(address)});
            r = RegSpecMcd.INVALID;
        }
        return r;
    }

    public static void checkRegLongAccess(RegSpecMcd regSpec, Size size) {
        boolean checkLong;
        boolean bl = checkLong = regSpec.deviceType != McdRegType.COMM && (regSpec.deviceType == McdRegType.SYS || regSpec.addr < RegSpecMcd.MCD_CDD_COMM0.addr || regSpec.addr >= RegSpecMcd.MCD_FONT_COLOR.addr);
        if (checkLong) assert (size != Size.LONG);
    }

    public static void logZ80Access(BufferUtil.CpuDeviceAccess cpu, RegSpecMcd r, int address, Size size, boolean read) {
        if (cpu == BufferUtil.CpuDeviceAccess.Z80 && z80RegAccess.add(address)) {
            LOG.warn("{} {} access register {} at address: {} {}", new Object[]{cpu, read ? "read" : "write", r, Util.th(address), size});
        }
    }

    public static String decodeComm(int valueMem) {
        Object s1 = "";
        if (valueMem > 0x10000000) {
            s1 = "'" + (char)((valueMem & 0xFF000000) >> 24) + (char)((valueMem & 0xFF0000) >> 16) + (char)((valueMem & 0xFF00) >> 8) + (char)((valueMem & 0xFF) >> 0) + "'";
        } else if ((valueMem & 0xFFFF) > 4096) {
            s1 = "'" + (char)((valueMem & 0xFF00) >> 8) + (char)((valueMem & 0xFF) >> 0) + "'";
        }
        return s1;
    }

    public static void writeCommonRegWord(MegaCdMemoryContext mc, BufferUtil.CpuDeviceAccess cpu, RegSpecMcd reg, int value) {
        assert (reg.deviceType != McdRegType.SYS);
        assert (reg.addr > MegaCdMemoryContext.NUM_SYS_REG_NON_SHARED);
        MegaCdDict.writeReg(mc, cpu, reg, reg.addr, value, Size.WORD);
    }

    public static void writeSysRegWord(MegaCdMemoryContext mc, BufferUtil.CpuDeviceAccess cpu, RegSpecMcd reg, int value) {
        assert (reg.addr < MegaCdMemoryContext.NUM_SYS_REG_NON_SHARED);
        MegaCdDict.writeReg(mc, cpu, reg, reg.addr, value, Size.WORD);
    }

    public static void writeReg(MegaCdMemoryContext mc, BufferUtil.CpuDeviceAccess cpu, RegSpecMcd reg, int value, Size size) {
        MegaCdDict.writeReg(mc, cpu, reg, reg.addr, value, size);
    }

    public static boolean writeReg(MegaCdMemoryContext mc, BufferUtil.CpuDeviceAccess cpu, RegSpecMcd reg, int addr, int value, Size size) {
        assert ((reg.regCpuType.bitSet & cpu.ordinal()) > 0);
        return BufferUtil.writeBufferRaw(mc.getRegBuffer(cpu, reg), addr, value, size);
    }

    public static enum McdRegType {
        NONE,
        SYS,
        COMM,
        CDC,
        CDD,
        ASIC,
        PCM;

    }

    public static enum McdRegCpuType {
        REG_MAIN(BufferUtil.CpuDeviceAccess.M68K),
        REG_SUB(BufferUtil.CpuDeviceAccess.SUB_M68K),
        REG_BOTH(BufferUtil.CpuDeviceAccess.M68K, BufferUtil.CpuDeviceAccess.SUB_M68K);

        public final int bitSet;

        private McdRegCpuType(BufferUtil.CpuDeviceAccess ... cpus) {
            int bs = 0;
            for (BufferUtil.CpuDeviceAccess cpu : cpus) {
                bs |= cpu.ordinal();
            }
            this.bitSet = bs;
        }
    }

    public static enum RegSpecMcd {
        MCD_RESET(McdRegType.SYS, 0),
        MCD_MEM_MODE(McdRegType.SYS, 2),
        MCD_CDC_MODE(McdRegType.CDC, 4),
        MCD_HINT_VECTOR(McdRegType.SYS, McdRegCpuType.REG_MAIN, 6),
        MCD_CDC_REG_DATA(McdRegType.CDC, McdRegCpuType.REG_SUB, 6),
        MCD_CDC_HOST(McdRegType.CDC, 8),
        MCD_CDC_DMA_ADDRESS(McdRegType.CDC, 10),
        MCD_STOPWATCH(McdRegType.CDC, 12),
        MCD_COMM_FLAGS(McdRegType.SYS, 14),
        MCD_COMM0(McdRegType.COMM, 16),
        MCD_COMM1(McdRegType.COMM, 18),
        MCD_COMM2(McdRegType.COMM, 20),
        MCD_COMM3(McdRegType.COMM, 22),
        MCD_COMM4(McdRegType.COMM, 24),
        MCD_COMM5(McdRegType.COMM, 26),
        MCD_COMM6(McdRegType.COMM, 28),
        MCD_COMM7(McdRegType.COMM, 30),
        MCD_COMM8(McdRegType.COMM, 32),
        MCD_COMM9(McdRegType.COMM, 34),
        MCD_COMMA(McdRegType.COMM, 36),
        MCD_COMMB(McdRegType.COMM, 38),
        MCD_COMMC(McdRegType.COMM, 40),
        MCD_COMMD(McdRegType.COMM, 42),
        MCD_COMME(McdRegType.COMM, 44),
        MCD_COMMF(McdRegType.COMM, 46),
        MCD_TIMER_INT3(McdRegType.SYS, 48),
        MCD_INT_MASK(McdRegType.SYS, 50),
        MCD_CD_FADER(McdRegType.CDD, 52),
        MCD_CDD_CONTROL(McdRegType.CDD, 54),
        MCD_CDD_COMM0(McdRegType.CDD, 56),
        MCD_CDD_COMM1(McdRegType.CDD, 58),
        MCD_CDD_COMM2(McdRegType.CDD, 60),
        MCD_CDD_COMM3(McdRegType.CDD, 62),
        MCD_CDD_COMM4(McdRegType.CDD, 64),
        MCD_CDD_COMM5(McdRegType.CDD, 66),
        MCD_CDD_COMM6(McdRegType.CDD, 68),
        MCD_CDD_COMM7(McdRegType.CDD, 70),
        MCD_CDD_COMM8(McdRegType.CDD, 72),
        MCD_CDD_COMM9(McdRegType.CDD, 74),
        MCD_FONT_COLOR(McdRegType.SYS, 76),
        MCD_FONT_BIT(McdRegType.SYS, 78),
        MCD_FONT_DATA0(McdRegType.SYS, 80),
        MCD_FONT_DATA1(McdRegType.SYS, 82),
        MCD_FONT_DATA2(McdRegType.SYS, 84),
        MCD_FONT_DATA3(McdRegType.SYS, 86),
        MCD_IMG_STAMP_SIZE(McdRegType.ASIC, 88),
        MCD_IMG_STAMP_MAP_ADDR(McdRegType.ASIC, 90),
        MCD_IMG_VCELL(McdRegType.ASIC, 92),
        MCD_IMG_START_ADDR(McdRegType.ASIC, 94),
        MCD_IMG_OFFSET(McdRegType.ASIC, 96),
        MCD_IMG_HDOT(McdRegType.ASIC, 98),
        MCD_IMG_VDOT(McdRegType.ASIC, 100),
        MCD_IMG_TRACE_VECTOR_ADDR(McdRegType.ASIC, 102),
        MCD_PCM_ENV(McdRegType.PCM, 257),
        MCD_PCM_PAN(McdRegType.PCM, 259),
        MCD_PCM_FDL(McdRegType.PCM, 261),
        MCD_PCM_FDH(McdRegType.PCM, 263),
        MCD_PCM_LSL(McdRegType.PCM, 265),
        MCD_PCM_LSH(McdRegType.PCM, 267),
        MCD_PCM_START(McdRegType.PCM, 269),
        MCD_PCM_CTRL(McdRegType.PCM, 271),
        MCD_PCM_ON_OFF(McdRegType.PCM, 273),
        INVALID(McdRegType.NONE, -1);

        public final RegSpec regSpec;
        public final McdRegCpuType regCpuType;
        public final McdRegType deviceType;
        public final int addr;
        public final int deviceAccessTypeDelay;

        private RegSpecMcd(McdRegType deviceType, int addr) {
            this(deviceType, McdRegCpuType.REG_BOTH, addr);
        }

        private RegSpecMcd(McdRegType deviceType, McdRegCpuType cpuType, int addr) {
            this.deviceType = deviceType;
            this.deviceAccessTypeDelay = 1;
            this.regCpuType = MegaCdDict.getCpuTypeFromDevice(deviceType, cpuType);
            this.regSpec = this.createRegSpec(addr);
            this.addr = this.regSpec.bufferAddr;
            this.init();
        }

        private RegSpec createRegSpec(int addr) {
            return this.deviceType == McdRegType.NONE ? RegSpec.INVALID_REG : new RegSpec(this.name(), addr, 511, Size.WORD);
        }

        private void init() {
            if (this.deviceType == McdRegType.NONE) {
                return;
            }
            int addrLen = this.regSpec.regSize.getByteSize();
            for (int i = this.regSpec.fullAddr; i < this.regSpec.fullAddr + addrLen; ++i) {
                if (this.regCpuType == McdRegCpuType.REG_BOTH) {
                    MegaCdDict.mcdRegMapping[McdRegCpuType.REG_BOTH.ordinal()][i] = this;
                    continue;
                }
                MegaCdDict.mcdRegMapping[this.regCpuType.ordinal()][i] = this;
            }
        }

        public String getName() {
            return this.regSpec.name;
        }
    }

    public static enum BitRegDef implements BitRegisterDef
    {
        RES0(BufferUtil.CpuDeviceAccess.SUB_M68K, 0, RegSpecMcd.MCD_RESET.addr + 1),
        LEDR(BufferUtil.CpuDeviceAccess.SUB_M68K, 0, RegSpecMcd.MCD_RESET.addr),
        LEDG(BufferUtil.CpuDeviceAccess.SUB_M68K, 1, RegSpecMcd.MCD_RESET.addr),
        PM0(BufferUtil.CpuDeviceAccess.SUB_M68K, 3, RegSpecMcd.MCD_MEM_MODE.addr + 1),
        PM1(BufferUtil.CpuDeviceAccess.SUB_M68K, 4, RegSpecMcd.MCD_MEM_MODE.addr + 1),
        IFL2(BufferUtil.CpuDeviceAccess.M68K, 0, RegSpecMcd.MCD_RESET.addr),
        IEN2(BufferUtil.CpuDeviceAccess.M68K, 7, RegSpecMcd.MCD_RESET.addr),
        SRES(BufferUtil.CpuDeviceAccess.M68K, 0, RegSpecMcd.MCD_RESET.addr + 1),
        SBRQ(BufferUtil.CpuDeviceAccess.M68K, 1, RegSpecMcd.MCD_RESET.addr + 1),
        BK0(BufferUtil.CpuDeviceAccess.M68K, 6, RegSpecMcd.MCD_MEM_MODE.addr + 1),
        BK1(BufferUtil.CpuDeviceAccess.M68K, 7, RegSpecMcd.MCD_MEM_MODE.addr + 1);

        private final int pos;
        private final int regBytePos;
        private final int bitMask;
        public final BufferUtil.CpuDeviceAccess cpu;

        private BitRegDef(BufferUtil.CpuDeviceAccess cpu, int p, int rbp) {
            this.pos = p;
            this.regBytePos = rbp;
            this.bitMask = 1 << this.pos;
            this.cpu = cpu;
        }

        @Override
        public int getBitPos() {
            return this.pos;
        }

        @Override
        public int getRegBytePos() {
            return this.regBytePos;
        }

        @Override
        public int getBitMask() {
            return this.bitMask;
        }

        @Override
        public BufferUtil.CpuDeviceAccess getCpu() {
            return this.cpu;
        }
    }

    public static enum SharedBitDef implements BitRegisterDef
    {
        RET(0, RegSpecMcd.MCD_MEM_MODE.addr + 1),
        DMNA(1, RegSpecMcd.MCD_MEM_MODE.addr + 1),
        MODE(2, RegSpecMcd.MCD_MEM_MODE.addr + 1),
        DD0(0, RegSpecMcd.MCD_CDC_MODE.addr),
        DD1(1, RegSpecMcd.MCD_CDC_MODE.addr),
        DD2(2, RegSpecMcd.MCD_CDC_MODE.addr),
        EDT(7, RegSpecMcd.MCD_CDC_MODE.addr),
        DSR(6, RegSpecMcd.MCD_CDC_MODE.addr);

        private final int pos;
        private final int regBytePos;
        private final int bitMask;

        private SharedBitDef(int p, int rbp) {
            this.pos = p;
            this.regBytePos = rbp;
            this.bitMask = 1 << this.pos;
        }

        @Override
        public int getBitPos() {
            return this.pos;
        }

        @Override
        public int getRegBytePos() {
            return this.regBytePos;
        }

        @Override
        public int getBitMask() {
            return this.bitMask;
        }
    }

    public static interface BitRegisterDef {
        public int getBitPos();

        public int getRegBytePos();

        public int getBitMask();

        default public BufferUtil.CpuDeviceAccess getCpu() {
            return null;
        }
    }
}

