/*
 * Decompiled with CFR 0.152.
 */
package mcd.dict;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.function.BiConsumer;
import mcd.bus.McdWordRamHelper;
import mcd.cdd.CdBiosHelper;
import mcd.dict.MegaCdDict;
import mcd.dict.MegaCdRegWriteHandlers;
import mcd.util.BuramHelper;
import omegadrive.util.BufferUtil;
import omegadrive.util.LogHelper;
import omegadrive.util.Size;
import omegadrive.util.Util;
import org.slf4j.Logger;

public class MegaCdMemoryContext
implements Serializable {
    private static final long serialVersionUID = 9209612516906245680L;
    private static final Logger LOG = LogHelper.getLogger(MegaCdMemoryContext.class.getSimpleName());
    public static final int MCD_WORD_RAM_2M_SIZE = 262144;
    public static final int MCD_WORD_RAM_1M_SIZE = 131072;
    public static final int MCD_PRG_RAM_SIZE = 524288;
    public static final int MCD_WORD_RAM_1M_MASK = 131071;
    public static final int MCD_WORD_RAM_2M_MASK = 262143;
    public static final int MCD_PRG_RAM_MASK = 524287;
    public static final int NUM_SYS_REG_NON_SHARED = MegaCdDict.RegSpecMcd.MCD_COMM0.addr;
    public static final int MCD_PRAM_WRITE_PROTECT_AREA_END = 130560;
    public static final int MCD_PRAM_WRITE_PROTECT_BLOCK_SIZE = 512;
    public static final int MCD_PRAM_WRITE_PROTECT_BLOCK_MASK = 511;
    public final byte[] prgRam;
    public final byte[] commonGateRegs;
    public final byte[] backupRamArr;
    public final byte[][] sysGateRegs;
    public final byte[][] wordRam01 = new byte[2][1];
    public final McdWordRamHelper wramHelper;
    public static final int WRITABLE_HINT_UNUSED = -1;
    public final byte[] writeableHint = new byte[]{-1, -1, -1, -1};
    public final transient ByteBuffer[] sysGateRegsBuf;
    public final transient ByteBuffer commonGateRegsBuf;
    public final transient ByteBuffer backupRam;
    public int writeProtectRam = 0;
    public WramSetup wramSetup = WramSetup.W_2M_MAIN;

    public MegaCdMemoryContext() {
        this.prgRam = new byte[524288];
        this.wordRam01[0] = new byte[131072];
        this.wordRam01[1] = new byte[131072];
        this.sysGateRegs = new byte[2][NUM_SYS_REG_NON_SHARED];
        this.commonGateRegs = new byte[512];
        this.backupRamArr = new byte[8192];
        this.commonGateRegsBuf = ByteBuffer.wrap(this.commonGateRegs);
        this.backupRam = ByteBuffer.wrap(this.backupRamArr);
        BuramHelper.check_format_bram(this.backupRam);
        this.sysGateRegsBuf = new ByteBuffer[2];
        this.sysGateRegsBuf[0] = ByteBuffer.wrap(this.sysGateRegs[0]);
        this.sysGateRegsBuf[1] = ByteBuffer.wrap(this.sysGateRegs[1]);
        this.wramHelper = new McdWordRamHelper(this, this.wordRam01);
    }

    public void writeProgRam(int address, int val, Size size) {
        if (address < 130560) {
            if ((address >> 8 & 0x1FF) >= this.writeProtectRam << 1) {
                Util.writeData(this.prgRam, address, val, size);
                CdBiosHelper.checkSubMemRegion(this.prgRam, address);
            } else {
                LogHelper.logWarnOnce(LOG, "Ignoring PRG-RAM write: {} {}, wp {}", new Object[]{Util.th(address), size, Util.th(this.writeProtectRam)});
            }
            return;
        }
        Util.writeData(this.prgRam, address, val, size);
    }

    public ByteBuffer getGateSysRegs(BufferUtil.CpuDeviceAccess cpu) {
        assert (cpu == BufferUtil.CpuDeviceAccess.M68K || cpu == BufferUtil.CpuDeviceAccess.SUB_M68K);
        return this.sysGateRegsBuf[cpu == BufferUtil.CpuDeviceAccess.M68K ? 0 : 1];
    }

    public ByteBuffer getRegBuffer(BufferUtil.CpuDeviceAccess cpu, MegaCdDict.RegSpecMcd regSpec) {
        if (regSpec.addr >= NUM_SYS_REG_NON_SHARED) {
            return this.commonGateRegsBuf;
        }
        return this.getGateSysRegs(cpu);
    }

    public int handleRegWrite(BufferUtil.CpuDeviceAccess cpu, MegaCdDict.RegSpecMcd regSpec, int address, int data, Size size) {
        BiConsumer<MegaCdMemoryContext, Integer>[][] bh = cpu == BufferUtil.CpuDeviceAccess.M68K ? MegaCdRegWriteHandlers.setByteHandlersMain : MegaCdRegWriteHandlers.setByteHandlersSub;
        BiConsumer<MegaCdMemoryContext, Integer>[] setByteRegHandler = bh[regSpec.addr];
        ByteBuffer b = this.getRegBuffer(cpu, regSpec);
        assert (setByteRegHandler != null);
        switch (size) {
            case WORD: {
                setByteRegHandler[1].accept(this, data & 0xFF);
                setByteRegHandler[0].accept(this, data >> 8 & 0xFF);
                break;
            }
            case BYTE: {
                setByteRegHandler[address & 1].accept(this, data);
            }
        }
        return BufferUtil.readBuffer(b, regSpec.addr, Size.WORD);
    }

    public static enum WramSetup {
        W_2M_MAIN(WordRamMode._2M, BufferUtil.CpuDeviceAccess.M68K),
        W_2M_SUB(WordRamMode._2M, BufferUtil.CpuDeviceAccess.SUB_M68K),
        W_1M_WR0_MAIN(WordRamMode._1M, BufferUtil.CpuDeviceAccess.M68K),
        W_1M_WR0_SUB(WordRamMode._1M, BufferUtil.CpuDeviceAccess.SUB_M68K);

        public final BufferUtil.CpuDeviceAccess cpu;
        public final WordRamMode mode;

        private WramSetup(WordRamMode mode, BufferUtil.CpuDeviceAccess c) {
            this.cpu = c;
            this.mode = mode;
        }
    }

    public static enum WordRamMode {
        _1M,
        _2M;

    }
}

