/*
 * Decompiled with CFR 0.152.
 */
package mcd.dict;

import java.nio.ByteBuffer;
import java.util.function.BiConsumer;
import mcd.dict.MegaCdDict;
import mcd.dict.MegaCdMemoryContext;
import mcd.util.McdRegBitUtil;
import omegadrive.util.BufferUtil;
import omegadrive.util.LogHelper;
import omegadrive.util.Size;
import org.slf4j.Logger;

public class MegaCdRegWriteHandlers {
    private static final Logger LOG = LogHelper.getLogger(MegaCdRegWriteHandlers.class.getSimpleName());
    public static final BiConsumer<MegaCdMemoryContext, Integer>[][] setByteHandlersMain = new BiConsumer[8][2];
    public static final BiConsumer<MegaCdMemoryContext, Integer>[][] setByteHandlersSub = new BiConsumer[8][2];
    private static final BiConsumer<MegaCdMemoryContext, Integer> setByteLSBReg0_S = (ctx, d) -> {
        assert (d < 2);
        McdRegBitUtil.setBitDefInternal(ctx, BufferUtil.CpuDeviceAccess.SUB_M68K, MegaCdDict.BitRegDef.RES0, d);
    };
    private static final BiConsumer<MegaCdMemoryContext, Integer> setByteMSBReg0_S = (ctx, d) -> {
        McdRegBitUtil.setBitDefInternal(ctx, BufferUtil.CpuDeviceAccess.SUB_M68K, MegaCdDict.BitRegDef.LEDR, d);
        McdRegBitUtil.setBitDefInternal(ctx, BufferUtil.CpuDeviceAccess.SUB_M68K, MegaCdDict.BitRegDef.LEDG, d);
    };
    private static final BiConsumer<MegaCdMemoryContext, Integer> setByteLSBReg2_S = (ctx, d) -> {
        ByteBuffer buff = ctx.getGateSysRegs(BufferUtil.CpuDeviceAccess.SUB_M68K);
        int now = BufferUtil.readBuffer(buff, MegaCdDict.RegSpecMcd.MCD_MEM_MODE.addr + 1, Size.BYTE);
        int prevRet = now & MegaCdDict.SharedBitDef.RET.getBitMask();
        int prevMode = now & MegaCdDict.SharedBitDef.MODE.getBitMask();
        int prevDmna = now & MegaCdDict.SharedBitDef.DMNA.getBitMask();
        if (BufferUtil.assertionsEnabled) {
            boolean dmnaWriteOk;
            int newDmna = d & MegaCdDict.SharedBitDef.DMNA.getBitMask();
            boolean bl = dmnaWriteOk = newDmna == 0 || newDmna > 0 && prevDmna > 0;
            if (!dmnaWriteOk) {
                LogHelper.logWarnOnce(LOG, "{} illegal DMNA write: {}->{}", new Object[]{BufferUtil.CpuDeviceAccess.SUB_M68K, prevDmna, newDmna});
            }
        }
        if (prevMode == 0 && prevRet == 1 && prevDmna == 0) {
            d = d | MegaCdDict.SharedBitDef.RET.getBitMask();
        } else {
            McdRegBitUtil.setSharedBitInternal(ctx, BufferUtil.CpuDeviceAccess.SUB_M68K, MegaCdDict.SharedBitDef.RET, d);
        }
        McdRegBitUtil.setSharedBitInternal(ctx, BufferUtil.CpuDeviceAccess.SUB_M68K, MegaCdDict.SharedBitDef.MODE, d);
        McdRegBitUtil.setBitDefInternal(ctx, BufferUtil.CpuDeviceAccess.SUB_M68K, MegaCdDict.BitRegDef.PM0, d);
        McdRegBitUtil.setBitDefInternal(ctx, BufferUtil.CpuDeviceAccess.SUB_M68K, MegaCdDict.BitRegDef.PM1, d);
    };
    private static final BiConsumer<MegaCdMemoryContext, Integer> setByteMSBReg2_S = (ctx, d) -> {
        MegaCdDict.writeReg(ctx, BufferUtil.CpuDeviceAccess.SUB_M68K, MegaCdDict.RegSpecMcd.MCD_MEM_MODE, MegaCdDict.RegSpecMcd.MCD_MEM_MODE.addr, d, Size.BYTE);
        MegaCdDict.writeReg(ctx, BufferUtil.CpuDeviceAccess.M68K, MegaCdDict.RegSpecMcd.MCD_MEM_MODE, MegaCdDict.RegSpecMcd.MCD_MEM_MODE.addr, d, Size.BYTE);
    };
    private static final BiConsumer<MegaCdMemoryContext, Integer> setByteMSBReg4_S = (ctx, d) -> {
        ByteBuffer buff = ctx.getGateSysRegs(BufferUtil.CpuDeviceAccess.SUB_M68K);
        BufferUtil.writeBufferRaw(buff, MegaCdDict.RegSpecMcd.MCD_CDC_MODE.addr, d & 7, Size.BYTE);
        McdRegBitUtil.setSharedBitsOtherCpu(ctx, BufferUtil.CpuDeviceAccess.SUB_M68K, d & 7, MegaCdDict.SharedBitDef.DD0, MegaCdDict.SharedBitDef.DD1, MegaCdDict.SharedBitDef.DD2, MegaCdDict.SharedBitDef.DSR, MegaCdDict.SharedBitDef.EDT);
    };
    private static final BiConsumer<MegaCdMemoryContext, Integer> setByteLSBReg4_S = (ctx, d) -> {
        ByteBuffer buff = ctx.getGateSysRegs(BufferUtil.CpuDeviceAccess.SUB_M68K);
        BufferUtil.writeBufferRaw(buff, MegaCdDict.RegSpecMcd.MCD_CDC_MODE.addr + 1, d & 0x1F, Size.BYTE);
        BufferUtil.writeBufferRaw(ctx.getGateSysRegs(BufferUtil.CpuDeviceAccess.M68K), MegaCdDict.RegSpecMcd.MCD_CDC_MODE.addr + 1, 0, Size.BYTE);
    };
    private static final BiConsumer<MegaCdMemoryContext, Integer> setByteLSBReg0_M = (ctx, d) -> {
        McdRegBitUtil.setBitDefInternal(ctx, BufferUtil.CpuDeviceAccess.M68K, MegaCdDict.BitRegDef.SRES, d);
        McdRegBitUtil.setBitDefInternal(ctx, BufferUtil.CpuDeviceAccess.M68K, MegaCdDict.BitRegDef.SBRQ, d);
    };
    private static final BiConsumer<MegaCdMemoryContext, Integer> setByteMSBReg0_M = (ctx, d) -> {
        boolean ien2ok;
        ByteBuffer buff = ctx.getGateSysRegs(BufferUtil.CpuDeviceAccess.M68K);
        int now = BufferUtil.readBuffer(buff, MegaCdDict.RegSpecMcd.MCD_RESET.addr, Size.BYTE);
        boolean bl = (d & MegaCdDict.BitRegDef.IEN2.getBitMask()) > 0 ? (now & MegaCdDict.BitRegDef.IEN2.getBitMask()) > 0 : (ien2ok = true);
        if (!ien2ok) {
            LogHelper.logWarnOnce(LOG, "{} illegal IEN2 write: {}->{}", new Object[]{BufferUtil.CpuDeviceAccess.M68K, now & MegaCdDict.BitRegDef.IEN2.getBitMask(), d & MegaCdDict.BitRegDef.IEN2.getBitMask()});
            d = d & ~MegaCdDict.BitRegDef.IEN2.getBitMask();
        }
        McdRegBitUtil.setBitDefInternal(ctx, BufferUtil.CpuDeviceAccess.M68K, MegaCdDict.BitRegDef.IFL2, d);
    };
    private static final BiConsumer<MegaCdMemoryContext, Integer> setByteLSBReg2_M = (ctx, d) -> {
        boolean modeWriteOk;
        ByteBuffer buff = ctx.getGateSysRegs(BufferUtil.CpuDeviceAccess.M68K);
        int now = BufferUtil.readBuffer(buff, MegaCdDict.RegSpecMcd.MCD_MEM_MODE.addr + 1, Size.BYTE);
        int prevRet = now & MegaCdDict.SharedBitDef.RET.getBitMask();
        int prevMode = now & MegaCdDict.SharedBitDef.MODE.getBitMask();
        int prevDmna = now & MegaCdDict.SharedBitDef.DMNA.getBitMask();
        int newRet = d & MegaCdDict.SharedBitDef.RET.getBitMask();
        int newMode = d & MegaCdDict.SharedBitDef.MODE.getBitMask();
        boolean retWriteOk = newRet == 0 || newRet > 0 && prevRet > 0;
        boolean bl = modeWriteOk = newMode == 0 || newMode > 0 && prevMode > 0;
        if (!retWriteOk) {
            LogHelper.logWarnOnce(LOG, "{} illegal RET write: {}->{}", new Object[]{BufferUtil.CpuDeviceAccess.M68K, prevRet, newRet});
            d = d & ~MegaCdDict.SharedBitDef.RET.getBitMask();
        }
        if (!modeWriteOk) {
            LogHelper.logWarnOnce(LOG, "{} illegal MODE write: {}->{}", new Object[]{BufferUtil.CpuDeviceAccess.M68K, prevMode, newMode});
            d = d & ~MegaCdDict.SharedBitDef.MODE.getBitMask();
        }
        if (prevMode != 0 || prevRet != 0 || prevDmna <= 0) {
            McdRegBitUtil.setSharedBitInternal(ctx, BufferUtil.CpuDeviceAccess.M68K, MegaCdDict.SharedBitDef.DMNA, d);
        }
        McdRegBitUtil.setSharedBitInternal(ctx, BufferUtil.CpuDeviceAccess.M68K, MegaCdDict.SharedBitDef.RET, d);
        McdRegBitUtil.setSharedBitInternal(ctx, BufferUtil.CpuDeviceAccess.M68K, MegaCdDict.SharedBitDef.MODE, d);
        McdRegBitUtil.setBitDefInternal(ctx, BufferUtil.CpuDeviceAccess.M68K, MegaCdDict.BitRegDef.BK0, d);
        McdRegBitUtil.setBitDefInternal(ctx, BufferUtil.CpuDeviceAccess.M68K, MegaCdDict.BitRegDef.BK1, d);
    };
    private static final BiConsumer<MegaCdMemoryContext, Integer> setByteMSBReg2_M = (ctx, d) -> {
        BufferUtil.writeBufferRaw(ctx.getGateSysRegs(BufferUtil.CpuDeviceAccess.M68K), MegaCdDict.RegSpecMcd.MCD_MEM_MODE.addr, d, Size.BYTE);
        BufferUtil.writeBufferRaw(ctx.getGateSysRegs(BufferUtil.CpuDeviceAccess.SUB_M68K), MegaCdDict.RegSpecMcd.MCD_MEM_MODE.addr, d, Size.BYTE);
    };

    static {
        MegaCdRegWriteHandlers.setByteHandlersMain[MegaCdDict.RegSpecMcd.MCD_RESET.addr] = new BiConsumer[]{setByteMSBReg0_M, setByteLSBReg0_M};
        MegaCdRegWriteHandlers.setByteHandlersMain[MegaCdDict.RegSpecMcd.MCD_MEM_MODE.addr] = new BiConsumer[]{setByteMSBReg2_M, setByteLSBReg2_M};
        MegaCdRegWriteHandlers.setByteHandlersSub[MegaCdDict.RegSpecMcd.MCD_RESET.addr] = new BiConsumer[]{setByteMSBReg0_S, setByteLSBReg0_S};
        MegaCdRegWriteHandlers.setByteHandlersSub[MegaCdDict.RegSpecMcd.MCD_MEM_MODE.addr] = new BiConsumer[]{setByteMSBReg2_S, setByteLSBReg2_S};
        MegaCdRegWriteHandlers.setByteHandlersSub[MegaCdDict.RegSpecMcd.MCD_CDC_MODE.addr] = new BiConsumer[]{setByteMSBReg4_S, setByteLSBReg4_S};
    }
}

