/*
 * Decompiled with CFR 0.152.
 */
package mcd.pcm;

import java.nio.ByteBuffer;
import mcd.bus.MegaCdSubCpuBus;
import mcd.dict.MegaCdDict;
import mcd.pcm.BlipPcmProvider;
import omegadrive.sound.PcmProvider;
import omegadrive.sound.SoundProvider;
import omegadrive.util.BufferUtil;
import omegadrive.util.LogHelper;
import omegadrive.util.RegionDetector;
import omegadrive.util.Size;
import omegadrive.util.Util;
import omegadrive.util.VideoMode;
import org.slf4j.Logger;
import s32x.util.blipbuffer.BlipBufferHelper;

public class McdPcm
implements BufferUtil.StepDevice {
    private static final Logger LOG = LogHelper.getLogger(McdPcm.class.getSimpleName());
    public static final int PCM_NUM_CHANNELS = 8;
    public static final int PCM_REG_SIZE = 32;
    public static final int PCM_REG_MASK = 31;
    public static final int PCM_START_RAMPTR_REGS = 32;
    public static final int PCM_END_RAMPTR_REGS = 64;
    public static final int PCM_LOOP_MARKER = 255;
    public static final int PCM_START_WAVE_DATA_WINDOW = 4096;
    public static final int PCM_END_WAVE_DATA_WINDOW = 8192;
    public static final int PCM_WAVE_DATA_WINDOW_MASK = 4095;
    public static final int PCM_WAVE_DATA_WINDOW_MASK_EXT = 8191;
    public static final int PCM_WAVE_DATA_SIZE = 65536;
    public static final int PCM_ADDRESS_MASK = 65535;
    public static final int PCM_FIX_POINT_DECIMAL = 11;
    public static final int PCM_WAVE_BANK_SHIFT = 12;
    public static final int MCD_PCM_DIVIDER = 384;
    public static final double pcmSampleRateHz = 32552.083333333332;
    public static final int PCM_SAMPLE_RATE_HZ = 32552;
    private ByteBuffer waveData;
    private ByteBuffer pcmRegs;
    private PcmChannelContext[] chan;
    private PcmProvider playSupport = PcmProvider.NO_SOUND;
    private int channelBank;
    private int waveBank;
    private int active;
    private int chanControl;
    private int ls;
    private int rs;
    int sampleNum = 0;
    public static McdPcm pcm;
    final boolean verbose = false;

    public McdPcm() {
        this.waveData = ByteBuffer.allocate(65536);
        this.pcmRegs = ByteBuffer.allocate(32);
        this.chan = new PcmChannelContext[8];
        this.playSupport = SoundProvider.ENABLE_SOUND ? new BlipPcmProvider("PCM", RegionDetector.Region.USA, 32552.083333333332) : PcmProvider.NO_SOUND;
        for (int i = 0; i < 8; ++i) {
            this.chan[i] = new PcmChannelContext();
            this.chan[i].num = i;
        }
        pcm = this;
    }

    private int readRamPointerRegs(int address, Size size) {
        return switch (size) {
            default -> throw new IncompatibleClassChangeError();
            case Size.BYTE -> this.readRamPointerRegsByte(address);
            case Size.WORD -> this.readRamPointerRegsWord(address);
            case Size.LONG -> this.readRamPointerRegsWord(address) << 16 | this.readRamPointerRegsWord(address + 2);
        };
    }

    private int readRamPointerRegsWord(int address) {
        int val = this.readRamPointerRegsByte(address | 1);
        return val << 8 | val;
    }

    private int readRamPointerRegsByte(int address) {
        int chanIndex = address >> 2 & 7;
        int msbShift = (address >> 1 & 1) << 3;
        return this.chan[chanIndex].addrCounter >> 11 + msbShift & 0xFF;
    }

    public int read(int address, Size size) {
        if ((address &= 0xFFFF) >= 32 && address < 64) {
            return this.readRamPointerRegs(address, size);
        }
        if (address < 31) {
            MegaCdDict.RegSpecMcd regSpec = this.getPcmReg(address);
            MegaCdSubCpuBus.logAccessReg(regSpec, BufferUtil.CpuDeviceAccess.SUB_M68K, address, size, true);
            return BufferUtil.readBuffer(this.pcmRegs, address, size);
        }
        assert (size == Size.BYTE) : Util.th(address) + "," + String.valueOf((Object)size);
        if (address >= 4096) {
            int addr = address;
            assert (address >= 8192 && address < 16384) : Util.th(address);
            address = this.waveBank | (address & 0x1FFF) >> 1;
            int res = BufferUtil.readBuffer(this.waveData, address, size);
            return res;
        }
        LogHelper.logWarnOnce(LOG, "Unhandled PCM read: {} {}", new Object[]{Util.th(address), size});
        return size.getMask();
    }

    public void write(int address, int value, Size size) {
        assert (size != Size.LONG);
        if (size == Size.WORD) {
            address |= 1;
            size = Size.BYTE;
        }
        value &= size.getMask();
        if ((address &= 0xFFFF) >= 4096) {
            assert (address >= 8192 && address < 16384) : Util.th(address);
            this.pcmDataWriteByte(address, value);
        } else if (address < 31) {
            MegaCdDict.RegSpecMcd regSpec = this.getPcmReg(address);
            MegaCdSubCpuBus.logAccessReg(regSpec, BufferUtil.CpuDeviceAccess.SUB_M68K, address, size, false);
            this.writeRegByte(regSpec, address, value);
        } else {
            LOG.error("Unhandled write: {}, {} {}", new Object[]{Util.th(address), Util.th(value), size});
            assert (false);
        }
    }

    public void pcmDataWriteByte(int addr, int value) {
        int address = this.waveBank | (addr & 0x1FFF) >> 1;
        BufferUtil.writeBufferRaw(this.waveData, address, value, Size.BYTE);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void writeRegByte(MegaCdDict.RegSpecMcd regSpec, int address, int value) {
        PcmChannelContext channel = this.chan[this.channelBank];
        switch (regSpec) {
            case MCD_PCM_ENV: {
                channel.env = value & 0xFF;
                channel.updateChannelFactors();
                break;
            }
            case MCD_PCM_PAN: {
                channel.panl = value >>> 4 & 0xF;
                channel.panr = value & 0xF;
                channel.updateChannelFactors();
                break;
            }
            case MCD_PCM_FDL: {
                channel.freqDelta = channel.freqDelta & 0xFF00 | value;
                break;
            }
            case MCD_PCM_FDH: {
                channel.freqDelta = value << 8 | channel.freqDelta & 0xFF;
                break;
            }
            case MCD_PCM_LSL: {
                channel.loopAddr = channel.loopAddr & 0xFF00 | value;
                break;
            }
            case MCD_PCM_LSH: {
                channel.loopAddr = value << 8 | channel.loopAddr & 0xFF;
                break;
            }
            case MCD_PCM_START: {
                channel.startAddr = value << 8;
                break;
            }
            case MCD_PCM_CTRL: {
                this.active = value >> 7;
                if ((value & 0x40) > 0) {
                    this.channelBank = value & 7;
                    break;
                }
                int wb = this.waveBank;
                this.waveBank = (value & 0xF) << 12;
                if (wb != this.waveBank) break;
                break;
            }
            case MCD_PCM_ON_OFF: {
                this.chanControl = ~value & 0xFF;
                for (int i = 0; i < 8; ++i) {
                    PcmChannelContext ct = this.chan[i];
                    int chanOn = this.chanControl >> i & 1;
                    if (ct.on == 0 && chanOn > 0) {
                        ct.addrCounter = channel.startAddr << 11;
                    }
                    ct.on = chanOn;
                }
                break;
            }
            default: {
                LogHelper.logWarnOnce(LOG, "PCM reserved reg write {}", Util.th(address));
            }
        }
        BufferUtil.writeBufferRaw(this.pcmRegs, address, value, Size.BYTE);
    }

    private MegaCdDict.RegSpecMcd getPcmReg(int address) {
        return MegaCdDict.getRegSpec(BufferUtil.CpuDeviceAccess.SUB_M68K, 256 + (address & 0xFF));
    }

    @Override
    public void step(int cycles) {
        if (this.chanControl == 0 && this.active == 0) {
            return;
        }
        this.generateOneSample();
    }

    public ByteBuffer getWaveData() {
        return this.waveData;
    }

    private void generateOneSample() {
        this.ls = 0;
        this.rs = 0;
        ++this.sampleNum;
        for (PcmChannelContext channel : this.chan) {
            if (channel.on <= 0) continue;
            int pcm = this.waveData.get(channel.addrCounter >>> 11) & 0xFF;
            if (pcm == 255) {
                channel.addrCounter = channel.loopAddr << 11;
                pcm = this.waveData.get(channel.loopAddr) & 0xFF;
                if (pcm == 255) continue;
            }
            channel.addrCounter = channel.addrCounter + channel.freqDelta & 0x7FFFFFF;
            if ((pcm & 0x80) > 0) {
                this.ls += (pcm &= 0x7F) * channel.factorl >>> 5;
                this.rs += pcm * channel.factorr >>> 5;
                continue;
            }
            this.ls -= pcm * channel.factorl >>> 5;
            this.rs -= pcm * channel.factorr >>> 5;
        }
        if (this.ls != (short)this.ls) {
            this.ls = BlipBufferHelper.clampToShort(this.ls);
        }
        if (this.rs != (short)this.rs) {
            this.rs = BlipBufferHelper.clampToShort(this.rs);
        }
        this.playSupport.playSample(this.ls, this.rs);
    }

    public void updateVideoMode(VideoMode videoMode) {
        this.playSupport.updateRegion(videoMode.getRegion());
    }

    public void newFrame() {
        this.playSupport.newFrame();
        this.sampleNum = 0;
    }

    @Override
    public void close() {
        this.playSupport.close();
    }

    @Override
    public void reset() {
        this.playSupport.reset();
    }

    static class PcmChannelContext {
        public int num;
        public int on;
        public int env;
        public int panl;
        public int panr;
        public int freqDelta;
        public int loopAddr;
        public int startAddr;
        public int addrCounter;
        public int factorl;
        public int factorr;

        PcmChannelContext() {
        }

        protected void updateChannelFactors() {
            this.factorl = this.env * this.panl;
            this.factorr = this.env * this.panr;
        }
    }
}

