/*
 * Decompiled with CFR 0.152.
 */
package mcd.util;

public class FixedPointUtil {
    public static double convertFixedPoint(int intPartDigits, int fractPartDigits, boolean signed, int val) {
        assert (intPartDigits + fractPartDigits == 16);
        int fractMax = 1 << fractPartDigits;
        int fractMask = fractMax - 1;
        int intMask = (1 << intPartDigits - (signed ? 1 : 0)) - 1;
        int intPart = val >>> fractPartDigits & intMask;
        double fpart = 1.0 * (double)(val & fractMask) / (double)fractMax;
        double res = (double)intPart + fpart;
        if (signed && val != (short)val) {
            res *= -1.0;
        }
        return res;
    }

    public static double convert5p11FixedPointSigned(int val) {
        return FixedPointUtil.convertFixedPoint(5, 11, true, val);
    }

    public static double convert13p3FixedPointUnsigned(int val) {
        return FixedPointUtil.convertFixedPoint(13, 3, false, val);
    }
}

