/*
 * Decompiled with CFR 0.152.
 */
package mcd.util;

import java.nio.ByteBuffer;
import java.util.Arrays;
import mcd.dict.MegaCdDict;
import mcd.dict.MegaCdMemoryContext;
import omegadrive.util.BufferUtil;
import omegadrive.util.Size;
import omegadrive.util.Util;

public class McdRegBitUtil {
    public static void setSharedBitsOtherCpu(MegaCdMemoryContext ctx, BufferUtil.CpuDeviceAccess cpu, int byteVal, MegaCdDict.SharedBitDef ... bitDef) {
        Arrays.stream(bitDef).forEach(bd -> McdRegBitUtil.setSharedBitOtherCpu(ctx, cpu, byteVal, bd));
    }

    public static void setSharedBitOtherCpu(MegaCdMemoryContext ctx, BufferUtil.CpuDeviceAccess cpu, int byteVal, MegaCdDict.SharedBitDef bitDef) {
        assert (cpu == BufferUtil.CpuDeviceAccess.M68K || cpu == BufferUtil.CpuDeviceAccess.SUB_M68K);
        BufferUtil.CpuDeviceAccess other = cpu == BufferUtil.CpuDeviceAccess.M68K ? BufferUtil.CpuDeviceAccess.SUB_M68K : BufferUtil.CpuDeviceAccess.M68K;
        ByteBuffer regs = ctx.getGateSysRegs(other);
        BufferUtil.setBit(regs, bitDef.getRegBytePos(), bitDef.getBitPos(), byteVal >> bitDef.getBitPos() & 1, Size.BYTE);
    }

    public static void setSharedBitBothCpu(MegaCdMemoryContext ctx, MegaCdDict.SharedBitDef bitDef, int byteVal) {
        McdRegBitUtil.setBitInternal(ctx.getGateSysRegs(BufferUtil.CpuDeviceAccess.M68K), bitDef.getRegBytePos(), bitDef.getBitPos(), byteVal);
        McdRegBitUtil.setBitInternal(ctx.getGateSysRegs(BufferUtil.CpuDeviceAccess.SUB_M68K), bitDef.getRegBytePos(), bitDef.getBitPos(), byteVal);
    }

    public static void setBitInternal(ByteBuffer buff, int regAddr, int bitPos, int data) {
        assert (bitPos < 8);
        BufferUtil.setBitVal(buff, regAddr, bitPos, data >> bitPos & 1, Size.BYTE);
    }

    public static void setSharedBitInternal(MegaCdMemoryContext ctx, BufferUtil.CpuDeviceAccess cpu, MegaCdDict.SharedBitDef bitDef, int data) {
        McdRegBitUtil.setBitInternal(ctx.getGateSysRegs(cpu), bitDef.getRegBytePos(), bitDef.getBitPos(), data);
        McdRegBitUtil.setSharedBitOtherCpu(ctx, cpu, data, bitDef);
    }

    public static void setBitDefInternal(MegaCdMemoryContext ctx, BufferUtil.CpuDeviceAccess cpu, MegaCdDict.BitRegisterDef def, int data) {
        assert (!(def instanceof MegaCdDict.SharedBitDef));
        assert (def.getCpu() == cpu);
        McdRegBitUtil.setBitInternal(ctx.getGateSysRegs(cpu), def.getRegBytePos(), def.getBitPos(), data);
    }

    public static int getInvertedBitFromByte(byte b, int bitPos) {
        return ~Util.getBitFromByte(b, bitPos) & 1;
    }
}

