/*
 * Decompiled with CFR 0.152.
 */
package omegadrive;

import java.awt.GraphicsEnvironment;
import java.io.FileReader;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import javax.swing.SwingUtilities;
import omegadrive.UserConfigHolder;
import omegadrive.input.InputProvider;
import omegadrive.input.KeyboardInputHelper;
import omegadrive.system.MediaSpecHolder;
import omegadrive.system.SysUtil;
import omegadrive.system.SystemProvider;
import omegadrive.ui.DisplayWindow;
import omegadrive.ui.PrefStore;
import omegadrive.ui.SwingWindow;
import omegadrive.util.LogHelper;
import omegadrive.util.Util;
import omegadrive.util.ZipUtil;
import org.slf4j.Logger;

public class SystemLoader {
    protected DisplayWindow emuFrame;
    private static final Logger LOG = LogHelper.getLogger(SystemLoader.class.getSimpleName());
    public static final SystemLoader INSTANCE = new SystemLoader();
    private static final String PROPERTIES_FILENAME = "./helios.properties";
    public static boolean showFps;
    public static boolean headless;
    public static boolean smdFileAsInterleaved;
    public static boolean testMode;
    public static String biosFolder;
    public static String biosNameMsx1;
    public static String biosNameColeco;
    private SystemProvider systemProvider;
    private static final AtomicBoolean init;

    protected static void loadProperties() {
        try (FileReader reader = new FileReader(PROPERTIES_FILENAME);){
            System.getProperties().load(reader);
        }
        catch (Exception e) {
            LOG.error("Unable to load properties file: ./helios.properties");
        }
        System.getProperties().list(System.out);
        System.out.println("-- done listing properties --");
        showFps = Boolean.parseBoolean(System.getProperty("helios.fps", "false"));
        headless = Boolean.parseBoolean(System.getProperty("helios.headless", "false"));
        biosFolder = String.valueOf(System.getProperty("bios.folder", biosFolder));
        biosNameMsx1 = String.valueOf(System.getProperty("bios.name.msx1", biosNameMsx1));
        biosNameColeco = String.valueOf(System.getProperty("bios.name.coleco", biosNameColeco));
        smdFileAsInterleaved = Boolean.parseBoolean(System.getProperty("md.enable.smd.handling", "false"));
        testMode = Boolean.parseBoolean(System.getProperty("helios.test.mode", "false"));
        PrefStore.initPrefs();
    }

    protected static boolean isHeadless() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        return ge.isHeadlessInstance() || headless;
    }

    public static void main(String[] args) {
        SystemLoader.init();
        if (args.length > 0) {
            Util.sleep(250L);
            String filePath = args[0];
            LOG.info("Launching file at: {}", (Object)filePath);
            MediaSpecHolder romSpec = MediaSpecHolder.of(filePath);
            INSTANCE.handleNewRomFile(romSpec);
            Util.sleep(1000L);
        }
        if (headless) {
            Util.waitForever();
        }
    }

    private SystemLoader() {
        Util.registerJmx(this);
    }

    public static SystemLoader getInstance() {
        if (init.compareAndSet(false, true)) {
            SystemLoader.init();
        }
        return INSTANCE;
    }

    private static void init() {
        SystemLoader.loadProperties();
        InputProvider.bootstrap();
        boolean isHeadless = SystemLoader.isHeadless();
        LOG.info("Headless mode: {}", (Object)isHeadless);
        SystemLoader.setHeadless(isHeadless);
        KeyboardInputHelper.init();
        INSTANCE.createFrame(isHeadless);
        init.set(true);
    }

    protected void createFrame(boolean isHeadless) {
        Runnable frameRunnable = () -> {
            this.emuFrame = isHeadless ? DisplayWindow.HEADLESS_INSTANCE : new SwingWindow(this.getSystemAdapter());
            this.emuFrame.init();
        };
        if (SwingUtilities.isEventDispatchThread()) {
            frameRunnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(frameRunnable);
            }
            catch (Exception e) {
                LOG.error("Unable to create SwingUI", (Throwable)e);
            }
        }
    }

    private static void setHeadless(boolean headless) {
        SystemLoader.headless = headless;
    }

    public SystemProvider handleNewRomFile(MediaSpecHolder file) {
        this.systemProvider = this.createSystemProvider(file);
        if (this.systemProvider != null) {
            this.emuFrame.reloadSystem(this.systemProvider);
            this.systemProvider.handleSystemEvent(SystemProvider.SystemEvent.NEW_ROM, file);
        }
        return this.systemProvider;
    }

    SystemProvider getSystemAdapter() {
        return new SystemProvider(){

            @Override
            public void handleSystemEvent(SystemProvider.SystemEvent event, Object parameter) {
                LOG.info("Event: {}, with parameter: {}", (Object)event, parameter);
                switch (event) {
                    case NEW_ROM: {
                        SystemLoader.this.handleNewRomFile((MediaSpecHolder)parameter);
                        break;
                    }
                    case CLOSE_ROM: {
                        break;
                    }
                    case CLOSE_APP: {
                        PrefStore.close();
                        break;
                    }
                    case PAD_SETUP_CHANGE: 
                    case FORCE_PAD_TYPE: {
                        UserConfigHolder.addUserConfig(event, parameter);
                        break;
                    }
                    default: {
                        LOG.warn("Unable to handle event: {}, with parameter: {}", (Object)event, parameter);
                    }
                }
            }

            @Override
            public boolean isRomRunning() {
                return false;
            }

            @Override
            public MediaSpecHolder getMediaSpec() {
                return MediaSpecHolder.NO_ROM;
            }

            @Override
            public SystemType getSystemType() {
                return SystemType.NONE;
            }
        };
    }

    public static String handleCompressedFiles(Path file, String lowerCaseName) {
        if (ZipUtil.isZipArchiveByteStream(file)) {
            Optional<? extends ZipEntry> optEntry = ZipUtil.getSupportedZipEntryIfAny(file, new String[0]);
            if (optEntry.isEmpty()) {
                LOG.error("Unable to find a system to load: {}", (Object)file.toAbsolutePath());
                return null;
            }
            LOG.info("Valid zipEntry detected: {}", (Object)optEntry.get().getName());
            lowerCaseName = optEntry.get().getName().toLowerCase();
        } else if (ZipUtil.isGZipByteStream(file)) {
            lowerCaseName = ZipUtil.getGZipFileName(file);
            LOG.info("GZip file detected, assuming name: {}", (Object)lowerCaseName);
        }
        return lowerCaseName;
    }

    public SystemProvider createSystemProvider(MediaSpecHolder file) {
        this.systemProvider = SysUtil.createSystemProvider(file, this.emuFrame);
        return this.systemProvider;
    }

    public SystemProvider getSystemProvider() {
        return this.systemProvider;
    }

    static {
        biosFolder = "./res/bios";
        biosNameMsx1 = "cbios_main_msx1.rom";
        biosNameColeco = "bios_coleco.col";
        init = new AtomicBoolean();
    }

    public static enum SystemType {
        NONE(""),
        MD("MD"),
        MEGACD("MCD"),
        S32X("32X"),
        MEGACD_S32X("MCD_32X"),
        SG_1000("SG"),
        COLECO("CV"),
        MSX("MSX"),
        SMS("SMS"),
        GG("GG"),
        NES("NES"),
        GB("GB");

        private final String shortName;

        private SystemType(String s) {
            this.shortName = s;
        }

        public String getShortName() {
            return this.shortName;
        }

        public boolean isMegaCdAttached() {
            return this == MEGACD || this == MEGACD_S32X;
        }

        public boolean isMdBased() {
            return this == MD || this == S32X || this == MEGACD_S32X || this == MEGACD;
        }
    }
}

