/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.bus;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import omegadrive.Device;
import omegadrive.bus.model.BaseBusProvider;
import omegadrive.cpu.m68k.M68kProvider;
import omegadrive.cpu.z80.Z80Provider;
import omegadrive.joypad.JoypadProvider;
import omegadrive.memory.IMemoryProvider;
import omegadrive.sound.SoundProvider;
import omegadrive.system.SystemProvider;
import omegadrive.util.Util;
import omegadrive.vdp.model.BaseVdpAdapterEventSupport;
import omegadrive.vdp.model.BaseVdpProvider;

public abstract class DeviceAwareBus<V extends BaseVdpProvider, J extends JoypadProvider>
implements BaseBusProvider,
BaseVdpAdapterEventSupport.VdpEventListener {
    private final Set<Device> deviceSet = new HashSet<Device>();
    protected IMemoryProvider memoryProvider;
    protected J joypadProvider;
    protected SoundProvider soundProvider;
    protected SystemProvider systemProvider;
    protected V vdpProvider;
    protected Z80Provider z80Provider;
    protected M68kProvider m68kProvider;

    @Override
    public BaseBusProvider attachDevice(Device device) {
        assert (device != null);
        this.deviceSet.add(device);
        this.loadMappings();
        return this;
    }

    @Override
    public <T extends Device> Optional<T> getBusDeviceIfAny(Class<T> clazz) {
        return Util.getDeviceIfAny(this.deviceSet, clazz);
    }

    @Override
    public <T extends Device> Set<T> getAllDevices(Class<T> clazz) {
        return Util.getAllDevices(this.deviceSet, clazz);
    }

    private void loadMappings() {
        this.deviceSet.add(this);
        if (this.memoryProvider == null) {
            this.memoryProvider = Util.getDeviceIfAny(this.deviceSet, IMemoryProvider.class).orElse(null);
        }
        if (this.joypadProvider == null) {
            this.joypadProvider = Util.getDeviceIfAny(this.deviceSet, JoypadProvider.class).orElse(null);
        }
        if (this.soundProvider == null) {
            this.soundProvider = Util.getDeviceIfAny(this.deviceSet, SoundProvider.class).orElse(null);
        }
        if (this.systemProvider == null) {
            this.systemProvider = Util.getDeviceIfAny(this.deviceSet, SystemProvider.class).orElse(null);
        }
        if (this.vdpProvider == null) {
            this.vdpProvider = Util.getDeviceIfAny(this.deviceSet, BaseVdpProvider.class).orElse(null);
            Optional.ofNullable(this.vdpProvider).ifPresent(v -> v.addVdpEventListener(this));
        }
        if (this.z80Provider == null) {
            this.z80Provider = Util.getDeviceIfAny(this.deviceSet, Z80Provider.class).orElse(null);
        }
        if (this.m68kProvider == null) {
            this.m68kProvider = Util.getDeviceIfAny(this.deviceSet, M68kProvider.class).orElse(null);
        }
    }

    @Override
    public void reset() {
        this.deviceSet.clear();
        this.memoryProvider = null;
        this.joypadProvider = null;
        this.soundProvider = null;
        this.systemProvider = null;
        this.vdpProvider = null;
        this.z80Provider = null;
        this.m68kProvider = null;
    }
}

