/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.bus.md;

import omegadrive.bus.model.SvpBus;
import omegadrive.cart.mapper.RomMapper;
import omegadrive.cpu.ssp16.Ssp16;
import omegadrive.cpu.ssp16.Ssp16Types;
import omegadrive.memory.IMemoryProvider;
import omegadrive.util.LogHelper;
import omegadrive.util.Size;
import omegadrive.util.Util;
import org.slf4j.Logger;

public class SvpMapper
implements RomMapper,
SvpBus {
    private static final Logger LOG = LogHelper.getLogger(SvpMapper.class.getSimpleName());
    private static final boolean verbose = false;
    private static final boolean VR_TEST_MODE = false;
    public static Ssp16 ssp16 = Ssp16.NO_SVP;
    private static SvpMapper instance = null;
    protected Ssp16Types.Svp_t svpCtx;
    protected Ssp16Types.Ssp1601_t sspCtx;
    protected final RomMapper baseMapper;

    protected SvpMapper(RomMapper baseMapper, Ssp16 ssp16p) {
        this.baseMapper = baseMapper;
        ssp16 = ssp16p;
        this.svpCtx = ssp16p.getSvpContext();
        this.sspCtx = this.svpCtx.ssp1601;
        instance = this;
    }

    public static SvpMapper createInstance(RomMapper baseMapper, Ssp16 ssp16) {
        return new SvpMapper(baseMapper, ssp16);
    }

    public static SvpMapper createInstance(RomMapper baseMapper, IMemoryProvider memoryProvider) {
        return SvpMapper.createInstance(baseMapper, Ssp16.createSvp(memoryProvider));
    }

    @Override
    public int readData(int addressL, Size size) {
        return this.m68kSvpReadData(addressL, size);
    }

    @Override
    public void writeData(int addressL, int data, Size size) {
        this.m68kSvpWriteData(addressL, data, size);
    }

    @Override
    public int m68kSvpRegRead(int address, Size size) {
        return this.m68kSvpRegRead(this.sspCtx, address, size);
    }

    @Override
    public void m68kSvpRegWrite(int address, int data, Size size) {
        this.m68kSvpRegWrite(this.sspCtx, address, data, size);
    }

    @Override
    public void m68kSvpWriteData(int addressL, int data, Size size) {
        this.m68kSvpWriteData(this.svpCtx, addressL, data, size);
    }

    @Override
    public int m68kSvpReadData(int addressL, Size size) {
        return this.m68kSvpReadData(this.svpCtx, addressL, size);
    }

    protected final int m68kSvpRegRead(Ssp16Types.Ssp1601_t sspCtx, int address, Size size) {
        switch (size) {
            case BYTE: {
                int val = this.svpRegReadWord(sspCtx, address & 0xFFFFFFFE);
                return (address & 1) > 0 ? val & 0xFF : val >> 8;
            }
            case WORD: {
                return this.svpRegReadWord(sspCtx, address);
            }
            case LONG: {
                return this.svpRegReadWord(sspCtx, address) << 16 | this.svpRegReadWord(sspCtx, address + 2);
            }
        }
        return -1;
    }

    protected final void m68kSvpRegWrite(Ssp16Types.Ssp1601_t sspCtx, int address, long data, Size size) {
        switch (size) {
            case BYTE: {
                LOG.error("Unexpected write {}, {}, {}", new Object[]{address, data, size});
                break;
            }
            case WORD: {
                this.svpRegWriteWord(sspCtx, address, data);
                break;
            }
            case LONG: {
                this.svpRegWriteWord(sspCtx, address, data >>> 16);
                this.svpRegWriteWord(sspCtx, address + 2, data & 0xFFFFL);
            }
        }
    }

    protected final int m68kSvpReadData(Ssp16Types.Svp_t svpCtx, int addressL, Size size) {
        int address = addressL & 0xFFFFFF;
        if (address >= 0x300000 && address < 0x320000) {
            switch (size) {
                case WORD: {
                    return svpCtx.readRamWord(address >> 1);
                }
                case LONG: {
                    return svpCtx.readRamWord(address >> 1) << 16 | svpCtx.readRamWord((address >> 1) + 1);
                }
                case BYTE: {
                    LOG.error("Unexpected byte-wide read: {}", (Object)Util.th(address));
                    return 255;
                }
            }
        } else {
            if (address >= 0x390000 && address < 0x3A0000) {
                long a1 = addressL >> 1;
                a1 = a1 & 0x7001L | (a1 & 0x3EL) << 6 | (a1 & 0xFC0L) >> 5;
                return svpCtx.readRamWord((int)a1);
            }
            if (address >= 0x3A0000 && address < 0x3B0000) {
                long a1 = addressL >> 1;
                a1 = a1 & 0x7801L | (a1 & 0x1EL) << 6 | (a1 & 0x7E0L) >> 4;
                return svpCtx.readRamWord((int)a1);
            }
        }
        return this.baseMapper.readData(addressL, size);
    }

    protected final void svpRegWriteWord(Ssp16Types.Ssp1601_t sspCtx, int address, long data) {
        switch (address & 0xF) {
            case 0: 
            case 2: {
                int pm0 = sspCtx.getRegisterValue(Ssp16Types.Ssp16Reg.SSP_PM0);
                sspCtx.setRegisterValue(Ssp16Types.Ssp16Reg.SSP_PM0, pm0 | 2);
                sspCtx.setRegisterValue(Ssp16Types.Ssp16Reg.SSP_XST, (int)(data & 0xFFFFL));
                int es = sspCtx.getEmu_status();
                sspCtx.setEmu_status(es & 0xFFFFDFFF);
                break;
            }
        }
    }

    private int svpRegReadWord(Ssp16Types.Ssp1601_t sspCtx, int address) {
        switch (address & 0xF) {
            case 0: 
            case 2: {
                int res = sspCtx.getRegisterValue(Ssp16Types.Ssp16Reg.SSP_XST);
                return res;
            }
            case 4: {
                int pm0 = sspCtx.getRegisterValue(Ssp16Types.Ssp16Reg.SSP_PM0);
                sspCtx.setRegisterValue(Ssp16Types.Ssp16Reg.SSP_PM0, pm0 & 0xFFFFFFFE);
                return pm0;
            }
        }
        LOG.warn("Svp unexpected register read {}", (Object)Util.th(address));
        return 65535;
    }

    protected final void svpMemoryWriteWord(Ssp16Types.Svp_t svpCtx, int addressByte, int data) {
        if (data > 0) {
            if (addressByte == 3210758) {
                this.sspCtx.setEmu_status(this.sspCtx.getEmu_status() & 0xFFFFBFFF);
            } else if (addressByte == 3210760) {
                this.sspCtx.setEmu_status(this.sspCtx.getEmu_status() & 0xFFFF7FFF);
            }
        }
        svpCtx.writeRamWord(addressByte >> 1, data);
    }

    protected final void m68kSvpWriteData(Ssp16Types.Svp_t svpCtx, int addressL, int data, Size size) {
        int address = addressL & 0xFFFFFF;
        data &= size.getMask();
        if (address >= 0x300000 && address < 0x320000) {
            switch (size) {
                case WORD: {
                    this.svpMemoryWriteWord(svpCtx, address, data);
                    break;
                }
                case LONG: {
                    this.svpMemoryWriteWord(svpCtx, address, data >>> 16);
                    this.svpMemoryWriteWord(svpCtx, address + 2, data & 0xFFFF);
                    break;
                }
                case BYTE: {
                    LOG.error("Unexpected byte-wide write: {}, {}", (Object)Util.th(address), (Object)Util.th(data));
                }
            }
            return;
        }
        this.baseMapper.writeData(addressL, data, size);
    }

    public static void setSvpContext(Ssp16Types.Svp_t svpCtx) {
        if (svpCtx == null) {
            return;
        }
        SvpMapper.instance.svpCtx = svpCtx;
        SvpMapper.instance.sspCtx = svpCtx.ssp1601;
        ssp16.loadSvpContext(svpCtx);
    }
}

