/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.bus.model;

import omegadrive.bus.md.MdZ80BusProviderImpl;
import omegadrive.bus.model.Z80BusProvider;
import omegadrive.cpu.z80.Z80Memory;
import omegadrive.cpu.z80.Z80Provider;
import omegadrive.util.LogHelper;
import org.slf4j.Logger;

public interface MdZ80BusProvider
extends Z80BusProvider {
    public static final Logger LOG = LogHelper.getLogger(MdZ80BusProvider.class.getSimpleName());
    public static final int END_RAM = 16383;
    public static final int START_YM2612 = 16384;
    public static final int END_YM2612 = 24575;
    public static final int START_ROM_BANK_ADDRESS = 24576;
    public static final int END_ROM_BANK_ADDRESS = 24831;
    public static final int START_UNUSED = 24832;
    public static final int END_UNUSED = 32511;
    public static final int START_VDP = 32512;
    public static final int END_VDP_VALID = 32543;
    public static final int END_VDP = Short.MAX_VALUE;
    public static final int START_68K_BANK = 32768;
    public static final int END_68K_BANK = 65535;
    public static final int VDP_BASE_ADDRESS = 0xC00000;
    public static final int M68K_BANK_MASK = Short.MAX_VALUE;
    public static final int ROM_BANK_POINTER_SIZE = 9;
    public static final int Z80_CYCLE_PENALTY = 4;
    public static final int M68K_CYCLE_PENALTY = 11;
    public static final int Z80_RAM_MEMORY_SIZE = 8192;

    public static MdZ80BusProvider createInstance(Z80BusProvider busProvider) {
        Z80Memory ram = new Z80Memory(8192);
        MdZ80BusProviderImpl b = new MdZ80BusProviderImpl();
        b.attachDevices(busProvider, ram);
        return b;
    }

    public void setRomBank68kSerial(int var1);

    public int getRomBank68kSerial();

    @Override
    default public int readIoPort(int port) {
        return 255;
    }

    @Override
    default public void writeIoPort(int port, int value) {
        LOG.warn("outPort: {}, data: {}", (Object)port, (Object)value);
    }

    public static int getRomBank68kSerial(Z80Provider z80) {
        Z80BusProvider z80BusProvider = z80.getZ80BusProvider();
        if (z80BusProvider instanceof MdZ80BusProvider) {
            MdZ80BusProvider g = (MdZ80BusProvider)z80BusProvider;
            return g.getRomBank68kSerial();
        }
        return -1;
    }

    public static void setRomBank68kSerial(Z80Provider z80, int romBank68kSerial) {
        Z80BusProvider bus = z80.getZ80BusProvider();
        if (bus instanceof MdZ80BusProvider) {
            MdZ80BusProvider genBus = (MdZ80BusProvider)bus;
            genBus.setRomBank68kSerial(romBank68kSerial);
        }
    }
}

