/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.bus.z80;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import omegadrive.Device;
import omegadrive.SystemLoader;
import omegadrive.bus.DeviceAwareBus;
import omegadrive.bus.model.Z80BusProvider;
import omegadrive.cart.MediaInfoProvider;
import omegadrive.cart.mapper.MapperSelector;
import omegadrive.cart.mapper.RomMapper;
import omegadrive.cart.mapper.msx.MsxMapper;
import omegadrive.cpu.z80.Z80Provider;
import omegadrive.input.InputProvider;
import omegadrive.input.MsxKeyboardInput;
import omegadrive.joypad.MsxPad;
import omegadrive.memory.IMemoryProvider;
import omegadrive.savestate.StateUtil;
import omegadrive.util.ArrayEndianUtil;
import omegadrive.util.FileUtil;
import omegadrive.util.LogHelper;
import omegadrive.util.Size;
import omegadrive.util.Util;
import omegadrive.vdp.Tms9918aVdp;
import org.slf4j.Logger;

public class MsxBus
extends DeviceAwareBus<Tms9918aVdp, MsxPad>
implements Z80BusProvider,
Device {
    private static final Logger LOG = LogHelper.getLogger(MsxBus.class);
    static final boolean verbose = false;
    private static final int PAGE_SIZE = 16384;
    private static final int PAGE_MASK = 16383;
    private static final int SLOT_SIZE = 65536;
    private static final int SLOTS = 4;
    private static final int[] emptySlot = new int[65536];
    private final int[][] secondarySlot = new int[4][];
    private final boolean[] secondarySlotWritable = new boolean[4];
    private final MsxBusContext ctx;
    private InputProvider.PlayerNumber joypadSelect = InputProvider.PlayerNumber.P1;
    private RomMapper mapper;

    public MsxBusContext getCtx() {
        return this.ctx;
    }

    public MsxBus() {
        Path p = Paths.get(SystemLoader.biosFolder, SystemLoader.biosNameMsx1);
        byte[] bios = FileUtil.loadBiosFile(p);
        LOG.info("Loading Msx bios from: {}", (Object)p.toAbsolutePath());
        Arrays.fill(emptySlot, 255);
        this.ctx = new MsxBusContext();
        this.secondarySlot[0] = ArrayEndianUtil.toUnsignedIntArray(bios);
        this.secondarySlot[1] = emptySlot;
        this.secondarySlot[2] = emptySlot;
        this.secondarySlot[3] = emptySlot;
        this.mapper = RomMapper.NO_OP_MAPPER;
    }

    @Override
    public int read(int addressL, Size size) {
        int addressI = addressL & 0xFFFF;
        int page = addressI >> 14;
        int secSlotNumber = this.ctx.pageSlotMapper[page];
        int res = 255;
        int address = (addressI & 0x3FFF) + this.ctx.pageStartAddress[page];
        if (this.mapper != RomMapper.NO_OP_MAPPER && secSlotNumber > 0 && secSlotNumber < 3) {
            res = this.mapper.readData(addressL, Size.BYTE);
        } else if (address < this.secondarySlot[secSlotNumber].length) {
            res = this.secondarySlot[secSlotNumber][address];
        } else {
            LOG.error("Unexpected read: {}, slot: {}", (Object)Util.th(addressL), (Object)secSlotNumber);
        }
        return res;
    }

    @Override
    public Z80BusProvider attachDevice(Device device) {
        super.attachDevice(device);
        if (device instanceof IMemoryProvider) {
            this.secondarySlot[3] = ArrayEndianUtil.toUnsignedIntArray(this.memoryProvider.getRamData());
            this.secondarySlotWritable[3] = true;
        }
        return this;
    }

    @Override
    public void write(int addressL, int data, Size size) {
        int addressI = addressL & 0xFFFF;
        int page = addressI >> 14;
        int secSlotNumber = this.ctx.pageSlotMapper[page];
        if (this.secondarySlotWritable[secSlotNumber]) {
            int address = (addressI & 0x3FFF) + this.ctx.pageStartAddress[page];
            this.writeSlot(this.secondarySlot[secSlotNumber], address, data);
        } else if (this.mapper != RomMapper.NO_OP_MAPPER && secSlotNumber > 0 && secSlotNumber < 3) {
            this.mapper.writeData(addressL, data, size);
        } else {
            LOG.error("Unexpected write: {}, data: {}, slot: {}", new Object[]{Util.th(addressL), Util.th(data), secSlotNumber});
        }
    }

    private void writeSlot(int[] data, int address, int value) {
        if (address < data.length) {
            data[address] = value;
        }
    }

    @Override
    public void writeIoPort(int port, int value) {
        byte byteVal = (byte)(value & 0xFF);
        switch (port &= 0xFF) {
            case 128: 
            case 192: {
                break;
            }
            case 152: {
                ((Tms9918aVdp)this.vdpProvider).writeVRAMData(byteVal);
                break;
            }
            case 153: {
                ((Tms9918aVdp)this.vdpProvider).writeRegister(byteVal);
                break;
            }
            case 160: {
                LOG.debug("Write PSG register select: {}", (Object)value);
                this.ctx.psgAddressLatch = value;
                break;
            }
            case 161: {
                LOG.debug("Write PSG: {}", (Object)value);
                this.soundProvider.getPsg().write(this.ctx.psgAddressLatch, value);
                if (this.ctx.psgAddressLatch != 15) break;
                this.joypadSelect = (value & 0x40) == 64 ? InputProvider.PlayerNumber.P2 : InputProvider.PlayerNumber.P1;
                LOG.debug("Write PSG register {}, data {}", (Object)this.ctx.psgAddressLatch, (Object)value);
                break;
            }
            case 168: {
                this.setSlotSelect(value);
                break;
            }
            case 170: {
                this.ctx.ppiC_Keyboard = value;
                break;
            }
            case 171: {
                break;
            }
            case 252: 
            case 253: 
            case 254: 
            case 255: {
                LOG.warn("Ignoring MSX2 memMapper write: {}, data {}", (Object)Util.th(port), (Object)Util.th(value));
                break;
            }
            default: {
                LOG.warn("outPort: {}, data {}", (Object)Util.th(port), (Object)Util.th(value));
            }
        }
    }

    @Override
    public int readIoPort(int port) {
        int res = 255;
        switch (port &= 0xFF) {
            case 152: {
                res = ((Tms9918aVdp)this.vdpProvider).readVRAMData();
                break;
            }
            case 153: {
                res = ((Tms9918aVdp)this.vdpProvider).readStatus();
                break;
            }
            case 160: {
                LOG.debug("Read PSG register select");
                res = this.ctx.psgAddressLatch;
                break;
            }
            case 162: {
                res = this.soundProvider.getPsg().read(this.ctx.psgAddressLatch);
                if (this.ctx.psgAddressLatch != 14) break;
                res = this.readJoyData();
                LOG.debug("Read PSG register {}, data {}", (Object)this.ctx.psgAddressLatch, (Object)res);
                break;
            }
            case 168: {
                res = this.ctx.slotSelect;
                break;
            }
            case 169: {
                res = MsxKeyboardInput.getMsxKeyAdapter().getRowValue(this.ctx.ppiC_Keyboard & 0xF);
                res = ~((byte)res);
                break;
            }
            case 170: {
                res = this.ctx.ppiC_Keyboard;
                break;
            }
            default: {
                LOG.warn("inPort: {}", (Object)Util.th(port & 0xFF));
            }
        }
        return res &= 0xFF;
    }

    private void setSlotSelect(int value) {
        this.ctx.slotSelect = value;
        this.reloadPageSlotMapper();
    }

    private void reloadPageSlotMapper() {
        this.ctx.pageSlotMapper[0] = this.ctx.slotSelect & 3;
        this.ctx.pageSlotMapper[1] = (this.ctx.slotSelect & 0xC) >> 2;
        this.ctx.pageSlotMapper[2] = (this.ctx.slotSelect & 0x30) >> 4;
        this.ctx.pageSlotMapper[3] = (this.ctx.slotSelect & 0xC0) >> 6;
    }

    @Override
    public void init() {
        this.setupCartHw();
        int len = this.memoryProvider.getRomSize();
        int[] rom = ArrayEndianUtil.toUnsignedIntArray(this.memoryProvider.getRomData());
        this.secondarySlot[1] = rom;
        if (len > 16384) {
            this.secondarySlot[2] = rom;
            this.ctx.pageStartAddress[2] = 16384;
        }
    }

    private int readJoyData() {
        int res = 255;
        switch (this.joypadSelect) {
            case P1: {
                res = ((MsxPad)this.joypadProvider).readDataRegister1();
                break;
            }
            case P2: {
                res = ((MsxPad)this.joypadProvider).readDataRegister2();
            }
        }
        LOG.debug("Read joy {}, data: {}", (Object)this.joypadSelect, (Object)res);
        return res;
    }

    private void setupCartHw() {
        int len = this.memoryProvider.getRomSize();
        MediaInfoProvider cartridgeInfoProvider = MediaInfoProvider.createInstance(this.memoryProvider, this.systemProvider.getRomPath());
        MapperSelector.Entry e = MapperSelector.getMapperData(this.systemProvider.getSystemType(), cartridgeInfoProvider.getSha1());
        if (e != MapperSelector.MISSING_DATA) {
            LOG.info("Cart Hw match:\n{}", (Object)e);
            this.mapper = MsxMapper.getMapper(e.mapperName, this.memoryProvider);
            LOG.info("ROM size: {}, using mapper: {}", (Object)len, (Object)this.mapper.getClass().getSimpleName());
        } else {
            LOG.info("Unknown rom sha1: {}", (Object)cartridgeInfoProvider.getSha1());
        }
    }

    @Override
    public void reset() {
    }

    @Override
    public void saveContext(ByteBuffer buffer) {
        buffer.put((byte)this.ctx.psgAddressLatch);
        buffer.put((byte)this.ctx.slotSelect);
        buffer.put((byte)this.ctx.ppiC_Keyboard);
        StateUtil.setData(buffer, this.ctx.pageSlotMapper);
        StateUtil.setData(buffer, this.ctx.pageStartAddress);
    }

    @Override
    public void loadContext(ByteBuffer buffer) {
        int i;
        this.ctx.psgAddressLatch = buffer.get() & 0xFF;
        this.ctx.slotSelect = buffer.get() & 0xFF;
        this.ctx.ppiC_Keyboard = buffer.get() & 0xFF;
        for (i = 0; i < this.ctx.pageSlotMapper.length; ++i) {
            this.ctx.pageSlotMapper[i] = buffer.getInt();
        }
        for (i = 0; i < this.ctx.pageStartAddress.length; ++i) {
            this.ctx.pageStartAddress[i] = buffer.getInt();
        }
        this.setSlotSelect(this.ctx.slotSelect);
    }

    @Override
    public void onNewFrame() {
        ((MsxPad)this.joypadProvider).newFrame();
    }

    @Override
    public void handleInterrupts(Z80Provider.Interrupt type) {
        boolean set = ((Tms9918aVdp)this.vdpProvider).getStatusINT() && ((Tms9918aVdp)this.vdpProvider).getGINT();
        this.z80Provider.interrupt(set);
    }

    public static class MsxBusContext
    implements Serializable {
        public int psgAddressLatch = 0;
        public int slotSelect = 0;
        public int ppiC_Keyboard = 0;
        public final int[] pageStartAddress = new int[]{0, 0, 0, 0};
        public final int[] pageSlotMapper = new int[]{0, 0, 0, 0};
    }
}

