/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.cart;

import java.nio.file.Path;
import java.util.Optional;
import omegadrive.memory.IMemoryProvider;
import omegadrive.util.LogHelper;
import omegadrive.util.RegionDetector;
import omegadrive.util.Util;
import org.slf4j.Logger;

public class MediaInfoProvider {
    private static final Logger LOG = LogHelper.getLogger(MediaInfoProvider.class.getSimpleName());
    public static final boolean AUTOFIX_CHECKSUM = false;
    private long checksum;
    private long computedChecksum;
    private String sha1;
    private String crc32;
    private Optional<IMemoryProvider> memoryProviderOptional = Optional.empty();
    public String romName;
    public int romSize;

    public static MediaInfoProvider createInstance(IMemoryProvider memoryProvider, Path rom) {
        MediaInfoProvider provider = new MediaInfoProvider();
        provider.memoryProviderOptional = Optional.of(memoryProvider);
        provider.romName = rom.getFileName().toString();
        provider.init();
        return provider;
    }

    public String getRomName() {
        return this.romName;
    }

    public String getRegion() {
        return RegionDetector.Region.USA.name();
    }

    public String getSha1() {
        return this.sha1;
    }

    public String getCrc32() {
        return this.crc32;
    }

    public boolean hasCorrectChecksum() {
        return this.checksum == this.computedChecksum;
    }

    public int getChecksumStartAddress() {
        return 0;
    }

    protected void init() {
        this.initChecksum();
        if (this.memoryProviderOptional.isPresent()) {
            this.romSize = this.memoryProviderOptional.get().getRomSize();
        }
    }

    protected void initChecksum() {
        if (this.memoryProviderOptional.isEmpty()) {
            return;
        }
        IMemoryProvider memoryProvider = this.memoryProviderOptional.get();
        this.checksum = memoryProvider.readRomByte(this.getChecksumStartAddress());
        this.computedChecksum = Util.computeChecksum(memoryProvider);
        this.sha1 = Util.computeSha1Sum(memoryProvider);
        this.crc32 = Util.computeCrc32(memoryProvider);
    }

    public String toString() {
        return "ROM sha1: " + this.sha1 + " - ROM CRC32: " + this.crc32;
    }

    public int getRomSize() {
        assert (this.romSize > 0);
        return this.romSize;
    }
}

