/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.cart.cheat;

import java.util.regex.Pattern;
import omegadrive.cart.cheat.BasicMdRawCode;

public class GameGenieHelper {
    public static final char[] MD_ALPHABET = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'L', 'M', 'N', 'P', 'R', 'S', 'T', 'V', 'W', 'X', 'Y', 'Z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    public static final Pattern MD_GG_PATTERN = Pattern.compile("^([A-Za-z0-9]{1,4})-([A-Za-z0-9]{1,4})$");

    public static boolean isValidGGLine(String line) {
        if (line.contains("-") && line.length() >= 9) {
            return MD_GG_PATTERN.matcher(line.substring(0, 9)).matches();
        }
        return false;
    }

    public static boolean isValidCode(String code) {
        int length = ((String)(code = ((String)code).toUpperCase())).length();
        if (length != 9) {
            return false;
        }
        if (((String)code).charAt(4) != '-') {
            return false;
        }
        code = ((String)code).substring(0, 4) + ((String)code).substring(5);
        --length;
        char[] alphabet = MD_ALPHABET;
        for (int i = 0; i < length; ++i) {
            boolean found = false;
            for (int j = 0; j < alphabet.length; ++j) {
                if (((String)code).charAt(i) != alphabet[j]) continue;
                found = true;
                j = alphabet.length;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public static BasicMdRawCode decode(String ggcode) {
        int length = ((String)ggcode).length();
        if (length != 9) {
            throw new IllegalArgumentException((String)ggcode);
        }
        ggcode = ((String)ggcode).substring(0, 4) + ((String)ggcode).substring(5);
        --length;
        long bitstring = 0L;
        for (int i = 0; i < length; ++i) {
            bitstring <<= 5;
            bitstring |= (long)GameGenieHelper.toHex(((String)ggcode).charAt(i));
        }
        int value = (int)(bitstring >> 7 & 0xEL | bitstring >> 15 & 1L);
        int temp = (int)(bitstring >> 11 & 0xEL | bitstring >> 11 & 1L);
        value <<= 4;
        value |= temp;
        temp = (int)(bitstring >> 32);
        value <<= 8;
        value |= temp;
        int address = (int)(bitstring >> 16 & 0xFFL);
        temp = (int)(bitstring >> 24 & 0xFFL);
        address <<= 8;
        address |= temp;
        temp = (int)(bitstring & 0xFFL);
        address <<= 8;
        return new BasicMdRawCode(address |= temp, value);
    }

    public static String encode(BasicMdRawCode code) {
        int value = code.getValue();
        int address = code.getAddress();
        long genie = (value & 0xF0) >> 4;
        int temp = value & 0xF;
        genie <<= 4;
        genie |= (long)temp;
        temp = (address & 0xF000) >> 12;
        genie <<= 4;
        genie |= (long)temp;
        temp = (address & 0xF00) >> 8;
        genie <<= 4;
        genie |= (long)temp;
        temp = (address & 0xF00000) >> 20;
        genie <<= 4;
        genie |= (long)temp;
        temp = (address & 0xF0000) >> 16;
        genie <<= 4;
        genie |= (long)temp;
        temp = (value & 0x1000) >> 9 | (value & 0xE00) >> 9;
        genie <<= 4;
        genie |= (long)temp;
        temp = (value & 0x100) >> 5 | (value & 0xE000) >> 13;
        genie <<= 4;
        genie |= (long)temp;
        temp = (address & 0xF0) >> 4;
        genie <<= 4;
        genie |= (long)temp;
        temp = address & 0xF;
        genie <<= 4;
        genie |= (long)temp;
        StringBuilder ggcode = new StringBuilder();
        char[] alphabet = MD_ALPHABET;
        for (int i = 0; i < 8; ++i) {
            if (i == 4) {
                ggcode.insert(0, "-");
            }
            ggcode.insert(0, alphabet[(int)(genie >> i * 5 & 0x1FL)]);
        }
        return ggcode.toString();
    }

    private static int toHex(char letter) throws IllegalArgumentException {
        letter = Character.toUpperCase(letter);
        char[] alphabet = MD_ALPHABET;
        for (int i = 0; i < alphabet.length; ++i) {
            if (alphabet[i] != letter) continue;
            return i;
        }
        throw new IllegalArgumentException();
    }
}

