/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.cart.loader;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import omegadrive.cart.loader.MdRomDbModel;
import omegadrive.util.FileUtil;
import omegadrive.util.LogHelper;
import org.slf4j.Logger;

public class MdLoader {
    private static final Logger LOG = LogHelper.getLogger(MdLoader.class.getSimpleName());
    static final String fileName = "res/romdb/md_romdb.json";
    private static final Map<String, MdRomDbModel.RomDbEntry> map = new HashMap<String, MdRomDbModel.RomDbEntry>();

    private static Map<String, MdRomDbModel.RomDbEntry> getMap() {
        if (map.isEmpty()) {
            MdLoader.init();
        }
        return map;
    }

    public static MdRomDbModel.RomDbEntry getEntry(String serial) {
        String sn = serial.substring(3, serial.length() - 3).trim();
        return MdLoader.getMap().getOrDefault(sn, MdRomDbModel.NO_ENTRY);
    }

    private static void init() {
        String json = FileUtil.readFileContentAsString(fileName);
        if (Strings.isNullOrEmpty((String)json)) {
            LOG.warn("Missing romDb file: {}", (Object)fileName);
            map.put("NONE", MdRomDbModel.NO_ENTRY);
            return;
        }
        Gson gson = new Gson();
        Type listOfMyClassObject = new TypeToken<ArrayList<MdRomDbModel.RomDbEntry>>(){}.getType();
        List l = (List)gson.fromJson(json, listOfMyClassObject);
        map.clear();
        l.forEach(e -> map.put(e.id, (MdRomDbModel.RomDbEntry)e));
    }
}

