/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.cart.loader;

import java.util.StringJoiner;

public class MdRomDbModel {
    public static final RomDbEntry NO_ENTRY = new RomDbEntry();
    public static final RomDbEntry.EepromEntry NO_EEPROM = new RomDbEntry.EepromEntry();

    public static class RomDbEntry {
        public String id;
        public String name;
        public String forceRegion;
        public String notes;
        public Integer sp;
        public Integer check;
        public Boolean force3Btn;
        public EepromEntry eeprom;

        public boolean hasEeprom() {
            return this.eeprom != null && this.eeprom != NO_EEPROM;
        }

        public boolean hasForce3Btn() {
            return this.force3Btn != null && this.force3Btn != false;
        }

        public String toString() {
            return new StringJoiner(", ", RomDbEntry.class.getSimpleName() + "[", "]").add("id='" + this.id + "'").add("name='" + this.name + "'").add("forceRegion='" + this.forceRegion + "'").add("sp=" + this.sp).add("check=" + this.check).add("force3Btn=" + this.force3Btn).add("eeprom=" + String.valueOf(this.eeprom)).toString();
        }

        public static class EepromEntry {
            public String type;
            public String lineMap;

            public String toString() {
                return new StringJoiner(", ", EepromEntry.class.getSimpleName() + "[", "]").add("type='" + this.type + "'").add("lineMap='" + this.lineMap + "'").toString();
            }

            public EepromLineMap getEepromLineMap() {
                EepromLineMap l = EepromLineMap.valueOf(this.lineMap);
                return l;
            }

            public EepromType getEepromType() {
                EepromType t = EepromType.valueOf(this.type);
                return t;
            }

            public int getEepromSize() {
                return this.getEepromType().sizeMask + 1;
            }
        }
    }

    public static enum EepromLineMap {
        SEGA(1, 0, 0),
        EA(6, 7, 7),
        ACCLAIM_16M(1, 0, 1),
        ACCLAIM_32M(0, 0, 0),
        ACCLAIM_32M_SCL8(8, 0, 0);

        public final int scl_in_bit;
        public final int sda_in_bit;
        public final int sda_out_bit;

        private EepromLineMap(int scl_in_bit, int sda_in_bit, int sda_out_bit) {
            this.scl_in_bit = scl_in_bit;
            this.sda_in_bit = sda_in_bit;
            this.sda_out_bit = sda_out_bit;
        }
    }

    public static enum EepromType {
        EEPROM_X24C01(7, 127, 3),
        EEPROM_X24C02(8, 255, 3),
        EEPROM_24C02(8, 255, 7),
        EEPROM_24C04(8, 511, 15),
        EEPROM_24C08(8, 1023, 15),
        EEPROM_24C16(8, 2047, 15),
        EEPROM_24C32(16, 4095, 31),
        EEPROM_24C64(16, 8191, 31),
        EEPROM_24C65(16, 8191, 63),
        EEPROM_24C128(16, 16383, 63),
        EEPROM_24C256(16, Short.MAX_VALUE, 63),
        EEPROM_24C512(16, 65535, 127),
        STM_95(0, 0, 0);

        public final int addressBits;
        public final int sizeMask;
        public final int pagewriteMask;

        private EepromType(int ab, int sm, int pm) {
            this.addressBits = ab;
            this.sizeMask = sm;
            this.pagewriteMask = pm;
        }
    }
}

