/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.cart.mapper.md;

import omegadrive.SystemLoader;
import omegadrive.cart.mapper.BackupMemoryMapper;
import omegadrive.cart.mapper.RomMapper;
import omegadrive.cart.mapper.md.eeprom.EepromBase;
import omegadrive.cart.mapper.md.eeprom.SpiEeprom;
import omegadrive.util.ArrayEndianUtil;
import omegadrive.util.LogHelper;
import omegadrive.util.Size;
import omegadrive.util.Util;
import org.slf4j.Logger;

public class MdT5740Mapper
extends BackupMemoryMapper
implements RomMapper,
RomMapper.StateAwareMapper {
    private static final Logger LOG = LogHelper.getLogger(MdT5740Mapper.class.getSimpleName());
    private static byte[] prot_15e6 = new byte[]{0, 0, 0, 16};
    private static final int BANKBABLE_ADDR_START = 0x280000;
    private static final String fileType = "srm";
    EepromBase eeprom;
    byte[] m_bank = new byte[3];
    int m_rdcnt;
    RomMapper baseMapper;

    void device_reset() {
        this.m_rdcnt = 0;
        this.m_bank[0] = 0;
        this.m_bank[1] = 0;
        this.m_bank[2] = 0;
    }

    public static MdT5740Mapper createInstance(String romName, RomMapper baseMapper) {
        MdT5740Mapper m = new MdT5740Mapper(romName, baseMapper);
        return m;
    }

    private MdT5740Mapper(String romName, RomMapper baseMapper) {
        super(SystemLoader.SystemType.MD, fileType, romName, SpiEeprom.SIZE_BYTES);
        this.baseMapper = baseMapper;
        LOG.info("MdT5740Mapper created, using folder: {}", (Object)this.sramFolder);
        this.initBackupFileIfNecessary();
        this.eeprom = new SpiEeprom();
        this.eeprom.setSram(this.sram);
    }

    @Override
    public int readData(int address, Size size) {
        if ((address & 0xFFF000) == 10563584) {
            assert (size == Size.BYTE);
            return this.read_a13(address & 0xFFF);
        }
        return this.read(address, size);
    }

    @Override
    public void writeData(int address, int data, Size size) {
        if ((address & 0xFFF000) == 10563584) {
            assert (size == Size.BYTE);
            this.write_a13(address & 0xFFF, data);
            return;
        }
        if ((long)address >= 0x200000L && (long)address <= 0x20FFFFL) {
            LOG.warn("Ignoring write to SRAM address {}, value {} {}", new Object[]{Util.th(address), Util.th(data), size});
            return;
        }
        this.baseMapper.writeData(address, data, size);
    }

    int read(int offset, Size size) {
        if (offset < 0x3FFFFF) {
            if (offset == 5606 || offset == 5608) {
                int res;
                if (this.m_rdcnt < 3) {
                    ++this.m_rdcnt;
                    res = Util.readData(prot_15e6, offset - 5606, size);
                } else {
                    res = this.baseMapper.readData(offset, size);
                }
                return res;
            }
            if (offset >= 0x280000) {
                int bank2 = offset - 0x280000 >> 19;
                offset = this.m_bank[bank2] << 19 | offset & 0x7FFFF;
            }
        }
        return this.baseMapper.readData(offset, size);
    }

    int read_a13(int offset) {
        if (offset == 11) {
            return this.eeprom.readEeprom(offset, Size.BYTE) & 1;
        }
        LOG.warn("A130{} byte read\n", (Object)Util.th(offset));
        return 65535;
    }

    void write_a13(int offset, int data) {
        assert (((offset &= 0xFF) & 1) == 1);
        if (offset != 1) {
            if (offset < 9) {
                this.m_bank[(offset >> 1) - 1] = (byte)(data & 0xF);
            } else if (offset == 9) {
                this.eeprom.writeEeprom(offset, data, Size.BYTE);
            } else {
                LOG.error("A13 write {} byte, data: {}\n", (Object)Util.th(offset), (Object)Util.th(data));
            }
        }
    }

    @Override
    public void closeRom() {
        this.writeFile();
    }

    @Override
    public int[] getState() {
        return ArrayEndianUtil.toUnsignedIntArray(this.m_bank);
    }

    @Override
    public void setState(int[] bankData) {
        assert (bankData.length >= this.m_bank.length);
        for (int i = 0; i < this.m_bank.length; ++i) {
            this.m_bank[i] = (byte)(bankData[i] & 0xFF);
        }
    }
}

