/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.cart.mapper.md.eeprom;

import omegadrive.cart.mapper.md.eeprom.EepromBase;
import omegadrive.util.LogHelper;
import omegadrive.util.Size;
import omegadrive.util.Util;
import org.slf4j.Logger;

public class SpiEeprom
implements EepromBase {
    private static final Logger LOG = LogHelper.getLogger(SpiEeprom.class.getSimpleName());
    private static int M95320_SIZE = 4096;
    public static int SIZE_BYTES = 65536;
    byte[] eeprom_data;
    int latch;
    int reset_line;
    int sck_line;
    int WEL;
    STMSTATE stm_state = STMSTATE.IDLE;
    int stream_pos = 0;
    int stream_data;
    int eeprom_addr;
    public static final LINE_STATE[] lsvals = LINE_STATE.values();

    public SpiEeprom() {
        this.eeprom_data = new byte[0];
    }

    void set_cs_line(LINE_STATE state) {
        this.reset_line = state.ordinal();
        if (state != LINE_STATE.CLEAR_LINE) {
            this.stream_pos = 0;
            this.stm_state = STMSTATE.IDLE;
        }
    }

    void set_si_line(LINE_STATE state) {
        this.latch = state.ordinal();
        assert (this.latch < 2);
    }

    void set_halt_line(LINE_STATE state) {
    }

    @Override
    public int readEeprom(int address, Size size) {
        assert (this.eeprom_data.length > 0 && size == Size.BYTE);
        return this.get_so_line();
    }

    @Override
    public void writeEeprom(int address, int data, Size size) {
        assert (this.eeprom_data.length > 0);
        this.set_si_line(this.getLineStateVal(data, 0));
        this.set_sck_line(this.getLineStateVal(data, 1));
        this.set_halt_line(this.getLineStateVal(data, 2));
        this.set_cs_line(this.getLineStateVal(data, 3));
    }

    @Override
    public void setSram(byte[] sram) {
        this.eeprom_data = sram;
        assert (sram.length > 0);
    }

    private LINE_STATE getLineStateVal(int data, int bit) {
        return lsvals[Util.getBitFromByte((byte)data, bit)];
    }

    int get_so_line() {
        if (this.stm_state == STMSTATE.READING || this.stm_state == STMSTATE.CMD_RDSR) {
            return this.stream_data >> 8 & 1;
        }
        return 0;
    }

    void set_sck_line(LINE_STATE state) {
        if (this.reset_line == LINE_STATE.CLEAR_LINE.ordinal() && state == LINE_STATE.ASSERT_LINE && this.sck_line == LINE_STATE.CLEAR_LINE.ordinal()) {
            block0 : switch (this.stm_state) {
                case IDLE: {
                    this.stream_data = this.shiftLeftOrBit(this.stream_data, this.latch & 1);
                    ++this.stream_pos;
                    if (this.stream_pos != 8) break;
                    this.stream_pos = 0;
                    switch (this.stream_data & 0xFF) {
                        case 1: {
                            if (this.WEL != 0) {
                                this.stm_state = STMSTATE.CMD_WRSR;
                            }
                            this.WEL = 0;
                            break block0;
                        }
                        case 2: {
                            if (this.WEL != 0) {
                                this.stm_state = STMSTATE.CMD_WRITE;
                            }
                            this.stream_data = 0;
                            this.WEL = 0;
                            break block0;
                        }
                        case 3: {
                            this.stm_state = STMSTATE.M95320_CMD_READ;
                            this.stream_data = 0;
                            break block0;
                        }
                        case 4: {
                            this.WEL = 0;
                            break block0;
                        }
                        case 5: {
                            this.stm_state = STMSTATE.CMD_RDSR;
                            this.stream_data = this.WEL << 1;
                            break block0;
                        }
                        case 6: {
                            this.WEL = 1;
                            break block0;
                        }
                    }
                    LOG.error("STM95 EEPROM: unknown cmd {}\n", (Object)Util.th(this.stream_data & 0xFF));
                    break;
                }
                case CMD_WRSR: {
                    ++this.stream_pos;
                    if (this.stream_pos != 8) break;
                    this.stm_state = STMSTATE.IDLE;
                    this.stream_pos = 0;
                    break;
                }
                case CMD_RDSR: {
                    this.stream_data = this.shiftLeftOrBit(this.stream_data, 0);
                    ++this.stream_pos;
                    if (this.stream_pos != 8) break;
                    this.stm_state = STMSTATE.IDLE;
                    this.stream_pos = 0;
                    break;
                }
                case M95320_CMD_READ: {
                    this.stream_data = this.shiftLeftOrBit(this.stream_data, this.latch & 1);
                    ++this.stream_pos;
                    if (this.stream_pos != 16) break;
                    this.eeprom_addr = this.stream_data & M95320_SIZE - 1;
                    this.stream_data = this.eeprom_data[this.eeprom_addr] & 0xFF;
                    this.stm_state = STMSTATE.READING;
                    this.stream_pos = 0;
                    break;
                }
                case READING: {
                    this.stream_data = this.shiftLeftOrBit(this.stream_data, 0);
                    ++this.stream_pos;
                    if (this.stream_pos != 8) break;
                    if (++this.eeprom_addr == M95320_SIZE) {
                        this.eeprom_addr = 0;
                    }
                    this.stream_data |= this.eeprom_data[this.eeprom_addr] & 0xFF;
                    this.stream_pos = 0;
                    break;
                }
                case CMD_WRITE: {
                    this.stream_data = this.shiftLeftOrBit(this.stream_data, this.latch & 1);
                    ++this.stream_pos;
                    if (this.stream_pos != 16) break;
                    this.eeprom_addr = this.stream_data & M95320_SIZE - 1;
                    this.stm_state = STMSTATE.WRITING;
                    this.stream_pos = 0;
                    break;
                }
                case WRITING: {
                    this.stream_data = this.shiftLeftOrBit(this.stream_data, this.latch & 1);
                    ++this.stream_pos;
                    if (this.stream_pos != 8) break;
                    this.eeprom_data[this.eeprom_addr] = (byte)this.stream_data;
                    if (++this.eeprom_addr == M95320_SIZE) {
                        this.eeprom_addr = 0;
                    }
                    this.stream_pos = 0;
                }
            }
        }
        this.sck_line = state.ordinal();
    }

    int shiftLeftOrBit(int val, int bit) {
        assert (bit < 2);
        val = val << 1 | bit;
        return val;
    }

    static enum STMSTATE {
        IDLE,
        CMD_WRSR,
        CMD_RDSR,
        M95320_CMD_READ,
        CMD_WRITE,
        READING,
        WRITING;

    }

    static enum LINE_STATE {
        CLEAR_LINE,
        ASSERT_LINE,
        HOLD_LINE;

    }
}

