/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.cart.mapper.msx;

import omegadrive.cart.mapper.RomMapper;
import omegadrive.cart.mapper.msx.AsciiMapperImpl;
import omegadrive.util.LogHelper;
import org.slf4j.Logger;

public class MsxAsciiMapper
extends AsciiMapperImpl {
    private static final Logger LOG = LogHelper.getLogger(MsxAsciiMapper.class.getSimpleName());
    public static final int BLOCK_NUM = 32;
    public static final int MAPPER_START_ADDRESS = 16384;
    public static final int MAPPER_END_ADDRESS = 49151;
    public static final int PAGES_8KB = 4;
    public static final int PAGES_16KB = 2;
    private static final AsciiType[] list = AsciiType.values();

    private MsxAsciiMapper(byte[] rom, AsciiType type) {
        super(rom, type);
    }

    public static RomMapper createMapper(byte[] rom, String type) {
        AsciiType t = MsxAsciiMapper.getMapperType(type);
        if (t == null) {
            LOG.error("Mapper not supported: {}", (Object)type);
            return NO_OP_MAPPER;
        }
        return MsxAsciiMapper.createMapper(rom, t);
    }

    public static RomMapper createMapper(byte[] rom, AsciiType type) {
        return new AsciiMapperImpl(rom, type);
    }

    public static AsciiType getMapperType(String mapperName) {
        for (AsciiType t : list) {
            if (!mapperName.equalsIgnoreCase(t.toString())) continue;
            return t;
        }
        return null;
    }

    public static enum AsciiType {
        ASCII8,
        ASCII16;

    }
}

