/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.cart.mapper.sms;

import java.util.Arrays;
import omegadrive.SystemLoader;
import omegadrive.cart.mapper.BackupMemoryMapper;
import omegadrive.cart.mapper.RomMapper;
import omegadrive.memory.IMemoryProvider;
import omegadrive.util.LogHelper;
import omegadrive.util.Size;
import omegadrive.util.Util;
import org.slf4j.Logger;

public class SmsMapper {
    private static final Type[] list = Type.values();
    private static final Logger LOG = LogHelper.getLogger(SmsMapper.class);
    private static final boolean verbose = false;
    private static final int DEFAULT_SRAM_SIZE = 16384;
    private static final int[] FRAME_REG_DEFAULT = new int[]{0, 1, 0};
    private static final int[] bankShiftMap = new int[]{0, 24, 16, 8};
    private IMemoryProvider memoryProvider;
    private int mappingControl = 0;
    private int numPages = 2;
    private int[] frameReg = new int[FRAME_REG_DEFAULT.length];
    private RomMapper activeMapper = RomMapper.NO_OP_MAPPER;
    private Type currentType = Type.NONE;
    private static final String sramFileType = "srm";
    private String smsRomName;

    public static SmsMapper createInstance(String romName, IMemoryProvider memoryProvider) {
        SmsMapper s = new SmsMapper();
        s.memoryProvider = memoryProvider;
        s.smsRomName = romName;
        s.init();
        return s;
    }

    public RomMapper setupRomMapper(String name, RomMapper current) {
        Type type = Type.SEGA;
        for (Type t : list) {
            if (!name.equalsIgnoreCase(t.name())) continue;
            type = t;
        }
        return this.setupRomMapper(type, current);
    }

    public RomMapper setupRomMapper(Type type, RomMapper current) {
        if (this.currentType != Type.NONE) {
            if (this.currentType != type) {
                LOG.error("Unable to change mapper from {} to {}", (Object)this.currentType, (Object)type);
            }
            return current;
        }
        this.currentType = type;
        switch (type) {
            case SEGA: {
                this.activeMapper = new SegaMapper();
                break;
            }
            case CODEM: {
                this.activeMapper = new CodeMapper();
                break;
            }
            case KOREA: {
                this.activeMapper = new KoreaMapper();
                break;
            }
            default: {
                LOG.error("Invalid mapper type: {}", (Object)type);
            }
        }
        LOG.info("Mapper set to: {}", (Object)this.currentType);
        return this.activeMapper;
    }

    public int getMapperControl() {
        return this.mappingControl;
    }

    public int[] getFrameReg() {
        return this.frameReg;
    }

    private void init() {
        this.numPages = Math.max(1, this.memoryProvider.getRomSize() >> 14);
        this.frameReg = Arrays.copyOf(FRAME_REG_DEFAULT, FRAME_REG_DEFAULT.length);
    }

    public int readDataMapper(int addressL, Size size) {
        int address = addressL & 0xFFFF;
        if (size != Size.BYTE) {
            LOG.error("Unexpected read, addr : {} , size: {}", (Object)address, (Object)size);
            return 255;
        }
        int page = address >> 14;
        if (page < FRAME_REG_DEFAULT.length) {
            int block16k = this.frameReg[page] << 14;
            int newAddr = block16k + (address & 0x3FFF);
            return this.memoryProvider.readRomByte(newAddr);
        }
        if (address >= 49152 && address <= 65535) {
            return this.memoryProvider.readRamByte(address &= 0x1FFF);
        }
        LOG.error("Unexpected Z80 memory read: {}", (Object)Util.th(address));
        return 255;
    }

    public static enum Type {
        NONE,
        SEGA,
        CODEM,
        KOREA;

    }

    class SegaMapper
    extends BackupMemoryMapper
    implements RomMapper {
        private static final boolean sramWriteEnable = true;
        private boolean sramSlot2Enable;

        private SegaMapper() {
            super(SystemLoader.SystemType.SMS, SmsMapper.sramFileType, SmsMapper.this.smsRomName, 16384);
            this.sramSlot2Enable = false;
        }

        @Override
        public int readData(int address, Size size) {
            if (this.sramSlot2Enable) {
                return this.readSramDataMaybe(address, size);
            }
            return SmsMapper.this.readDataMapper(address, size);
        }

        @Override
        public void writeData(int addressL, int dataL, Size size) {
            if (this.sramSlot2Enable && this.writeSramDataMaybe(addressL, dataL, size)) {
                return;
            }
            assert (size == Size.BYTE);
            int address = addressL & 0x1FFF;
            SmsMapper.this.memoryProvider.writeRamByte(address, (byte)dataL);
            if (addressL >= 65532) {
                this.writeBankData(addressL, dataL);
            }
        }

        private int readSramDataMaybe(int addressL, Size size) {
            int address = addressL & 0xFFFF;
            int page = address >> 14;
            if (this.sramSlot2Enable && page == 2) {
                return this.sram[address & 0x3FFF];
            }
            return SmsMapper.this.readDataMapper(addressL, size);
        }

        private boolean writeSramDataMaybe(int addressL, int dataL, Size size) {
            assert (size == Size.BYTE);
            int address = addressL & 0xFFFF;
            int page = address >> 14;
            if (this.sramSlot2Enable && page == 2) {
                this.sram[address & 0x3FFF] = (byte)dataL;
                return true;
            }
            return false;
        }

        @Override
        public void writeBankData(int addressL, int dataL) {
            int val = addressL & 3;
            int data = dataL & 0xFF;
            switch (val) {
                case 0: {
                    if (SmsMapper.this.mappingControl == data) break;
                    SmsMapper.this.mappingControl = data;
                    this.handleSramState(data);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    int frameRegNum = val - 1;
                    int bankShift = bankShiftMap[SmsMapper.this.mappingControl & 3];
                    SmsMapper.this.frameReg[frameRegNum] = data = (data + bankShift) % SmsMapper.this.numPages;
                }
            }
        }

        private void handleSramState(int data) {
            boolean bl = this.sramSlot2Enable = (data & 8) > 0;
            if (this.sramSlot2Enable) {
                this.initBackupFileIfNecessary();
            }
        }

        @Override
        public void closeRom() {
            this.writeFile();
        }
    }

    class CodeMapper
    implements RomMapper {
        CodeMapper() {
        }

        @Override
        public int readData(int address, Size size) {
            return SmsMapper.this.readDataMapper(address, size);
        }

        @Override
        public void writeData(int addressL, int dataL, Size size) {
            boolean isMappingControl;
            assert (size == Size.BYTE);
            int address = addressL & 0xFFFF;
            int page = address >> 14;
            boolean bl = isMappingControl = page < 3 && address % 16384 == 0;
            if (isMappingControl) {
                this.writeBankData(page, dataL);
            } else {
                SmsMapper.this.memoryProvider.writeRamByte(address & 0x1FFF, (byte)dataL);
            }
        }

        @Override
        public void writeBankData(int page, int data) {
            SmsMapper.this.frameReg[page] = data & 0xFF;
        }
    }

    class KoreaMapper
    implements RomMapper {
        KoreaMapper() {
        }

        @Override
        public int readData(int address, Size size) {
            return SmsMapper.this.readDataMapper(address, size);
        }

        @Override
        public void writeData(int addressL, int dataL, Size size) {
            boolean isMappingControl;
            assert (size == Size.BYTE);
            int address = addressL & 0xFFFF;
            boolean bl = isMappingControl = address == 40960;
            if (isMappingControl) {
                this.writeBankData(addressL, dataL);
            } else {
                SmsMapper.this.memoryProvider.writeRamByte(address & 0x1FFF, (byte)dataL);
            }
        }

        @Override
        public void writeBankData(int addressL, int dataL) {
            SmsMapper.this.frameReg[2] = dataL & 0xFF;
        }
    }
}

