/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.cpu.z80;

import java.nio.ByteBuffer;
import omegadrive.SystemLoader;
import omegadrive.bus.model.MdZ80BusProvider;
import omegadrive.bus.model.Z80BusProvider;
import omegadrive.cpu.z80.Z80Helper;
import omegadrive.cpu.z80.Z80MemIoOps;
import omegadrive.cpu.z80.Z80Provider;
import omegadrive.cpu.z80.debug.Z80CoreWrapperFastDebug;
import omegadrive.savestate.StateUtil;
import omegadrive.util.LogHelper;
import omegadrive.util.Size;
import omegadrive.util.Util;
import org.slf4j.Logger;
import z80core.IMemIoOps;
import z80core.Z80;
import z80core.Z80State;

public class Z80CoreWrapper
implements Z80Provider {
    public static final boolean STOP_ON_EXCEPTION;
    public static final boolean Z80_DEBUG;
    private static final Logger LOG;
    protected Z80 z80Core;
    protected Z80BusProvider z80BusProvider;
    protected Z80MemIoOps memIoOps;
    protected int instCyclesPenalty = 0;
    protected int memPtrInitVal;

    public static Z80CoreWrapper createInstance(SystemLoader.SystemType systemType, Z80BusProvider busProvider) {
        Z80CoreWrapper w = null;
        switch (systemType) {
            case MD: 
            case S32X: 
            case MEGACD: 
            case MEGACD_S32X: {
                w = Z80CoreWrapper.createMdInstanceInternal(busProvider);
                break;
            }
            case GG: 
            case SMS: 
            case COLECO: 
            case SG_1000: 
            case MSX: {
                w = Z80CoreWrapper.createInstanceInternal(busProvider);
                break;
            }
            default: {
                LOG.error("Unexpected system: {}", (Object)systemType);
            }
        }
        if (systemType == SystemLoader.SystemType.SMS) {
            w.z80Core.setRegSP(57328);
        }
        return w;
    }

    protected Z80CoreWrapper() {
    }

    protected Z80CoreWrapper setupInternal(Z80State z80State) {
        this.z80Core = new Z80((IMemIoOps)this.memIoOps, null);
        this.z80BusProvider.attachDevice(this);
        if (z80State != null) {
            this.z80Core.setZ80State(z80State);
        }
        this.z80Core.setRegSP(this.memIoOps.getPcUpperLimit());
        this.memPtrInitVal = this.memIoOps.getPcUpperLimit();
        return this;
    }

    private static Z80CoreWrapper createInstanceInternal(Z80BusProvider busProvider) {
        Z80CoreWrapper w = Z80_DEBUG ? new Z80CoreWrapperFastDebug() : new Z80CoreWrapper();
        w.z80BusProvider = busProvider;
        w.memIoOps = Z80MemIoOps.createInstance(w.z80BusProvider);
        return w.setupInternal(null);
    }

    private static Z80CoreWrapper createMdInstanceInternal(Z80BusProvider busProvider) {
        Z80CoreWrapper w = Z80_DEBUG ? new Z80CoreWrapperFastDebug() : new Z80CoreWrapper();
        w.z80BusProvider = MdZ80BusProvider.createInstance(busProvider);
        w.memIoOps = Z80MemIoOps.createMdInstance(w.z80BusProvider);
        return w.setupInternal(null);
    }

    @Override
    public int executeInstruction() {
        block2: {
            this.memIoOps.reset();
            this.instCyclesPenalty = 0;
            try {
                this.z80Core.execute();
            }
            catch (Error | Exception e) {
                LOG.error("z80 exception", e);
                LOG.error("Z80State: {}", (Object)Z80Helper.toString(this.z80Core.getZ80State()));
                LOG.error("Halting Z80");
                this.z80Core.setHalted(true);
                if (!STOP_ON_EXCEPTION) break block2;
                Util.waitForever();
            }
        }
        return (int)this.memIoOps.getTstates() + this.instCyclesPenalty;
    }

    @Override
    public void reset() {
        this.z80Core.setHalted(false);
        this.z80Core.setINTLine(false);
        this.z80Core.setNMI(false);
        this.z80Core.setPendingEI(false);
        this.z80Core.setMemPtr(this.memPtrInitVal);
        this.z80Core.setRegPC(0);
        this.z80Core.setRegI(0);
        this.z80Core.setRegR(0);
        this.z80Core.setIFF1(false);
        this.z80Core.setIFF2(false);
        this.z80Core.setIM(Z80.IntMode.IM0);
        LogHelper.logWarnOnce(LOG, "Z80 Reset, PC: {}", Util.th(this.z80Core.getRegPC()));
    }

    @Override
    public boolean interrupt(boolean value) {
        return this.memIoOps.setActiveINT(value);
    }

    @Override
    public void triggerNMI() {
        this.z80Core.triggerNMI();
    }

    @Override
    public boolean isHalted() {
        return this.z80Core.isHalted();
    }

    @Override
    public int readMemory(int address) {
        return this.z80BusProvider.read(address, Size.BYTE);
    }

    @Override
    public void writeMemory(int address, int data) {
        this.z80BusProvider.write(address, data, Size.BYTE);
    }

    @Override
    public Z80BusProvider getZ80BusProvider() {
        return this.z80BusProvider;
    }

    @Override
    public void addCyclePenalty(int value) {
        this.instCyclesPenalty += value;
    }

    @Override
    public void loadContext(ByteBuffer buffer) {
        this.z80Core.setZ80State(StateUtil.loadZ80State(buffer));
    }

    @Override
    public void saveContext(ByteBuffer buffer) {
        StateUtil.saveZ80State(buffer, this.z80Core.getZ80State());
    }

    @Override
    public void loadZ80State(Z80State z80State) {
        this.z80Core.setZ80State(z80State);
    }

    @Override
    public Z80State getZ80State() {
        return this.z80Core.getZ80State();
    }

    static {
        LOG = LogHelper.getLogger(Z80CoreWrapper.class.getSimpleName());
        STOP_ON_EXCEPTION = Boolean.parseBoolean(System.getProperty("z80.stop.on.exception", "false"));
        Z80_DEBUG = Boolean.parseBoolean(System.getProperty("z80.debug", "false"));
        if (Z80_DEBUG) {
            LOG.info("z80 debug mode: true");
        }
    }
}

