/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.input.jinput;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import net.java.games.input.Event;
import net.java.games.input.EventQueue;
import omegadrive.input.InputProvider;
import omegadrive.input.jinput.JinputGamepadMapping;
import omegadrive.joypad.JoypadProvider;
import omegadrive.util.LogHelper;
import omegadrive.util.PriorityThreadFactory;
import omegadrive.util.Util;
import org.slf4j.Logger;

public class JinputGamepadInputProvider
implements InputProvider {
    private static final Logger LOG = LogHelper.getLogger(JinputGamepadInputProvider.class.getSimpleName());
    private static final boolean USE_POLLING_THREAD = Boolean.parseBoolean(System.getProperty("jinput.polling.thread", "false"));
    private static final long POLLING_INTERVAL_MS = Long.parseLong(System.getProperty("jinput.polling.interval.ms", "5"));
    private static ExecutorService executorService;
    private volatile JoypadProvider joypadProvider;
    private volatile boolean stop = false;
    public static final String POV;
    private static InputProvider INSTANCE;
    public static final int AXIS_p1 = 1;
    public static final int AXIS_0 = 0;
    public static final int AXIS_m1 = -1;
    private final List<String> controllerNames;
    private final Map<String, Controller> controllers;
    private UpdatedGamepadCtx gamepadCtx;
    private static final BiFunction<List<Controller>, Integer, String> toNameFn;
    private final Map<InputProvider.PlayerNumber, String> playerControllerMap = Maps.newHashMap((Map)ImmutableMap.of((Object)((Object)InputProvider.PlayerNumber.P1), (Object)"Default (Keyboard)", (Object)((Object)InputProvider.PlayerNumber.P2), (Object)"Default (Keyboard)"));
    private boolean resetDirections = false;

    public JinputGamepadInputProvider() {
        this.controllerNames = new ArrayList<String>(DEFAULT_CONTROLLERS);
        this.controllers = new HashMap<String, Controller>();
    }

    public static InputProvider getInstance(JoypadProvider joypadProvider) {
        List<Controller> list = JinputGamepadInputProvider.detectControllers();
        InputProvider provider = NO_OP;
        if (!list.isEmpty()) {
            provider = JinputGamepadInputProvider.createOrGetInstance(list, joypadProvider);
        } else {
            LOG.info("Unable to find a controller");
        }
        return provider;
    }

    private static InputProvider createOrGetInstance(List<Controller> controllers, JoypadProvider joypadProvider) {
        if (INSTANCE == NO_OP) {
            JinputGamepadInputProvider g = new JinputGamepadInputProvider();
            g.joypadProvider = joypadProvider;
            assert (controllers.size() == DEFAULT_CONTROLLERS.size());
            IntStream.range(0, controllers.size()).forEach(i -> {
                String name = toNameFn.apply(controllers, i);
                g.controllers.put(name, (Controller)controllers.get(i));
                g.controllerNames.add(name);
            });
            g.gamepadCtx = new UpdatedGamepadCtx();
            g.initPollingThreadMaybe();
            INSTANCE = g;
        }
        ((JinputGamepadInputProvider)JinputGamepadInputProvider.INSTANCE).joypadProvider = joypadProvider;
        return INSTANCE;
    }

    private void initPollingThreadMaybe() {
        if (USE_POLLING_THREAD) {
            if (executorService == null) {
                executorService = Executors.newSingleThreadExecutor(new PriorityThreadFactory(1, JinputGamepadInputProvider.class.getSimpleName()));
            }
            executorService.submit(Util.wrapRunnableEx(this.inputRunnable()));
        }
    }

    public static List<Controller> detectControllers() {
        Controller[] ca = ControllerEnvironment.getDefaultEnvironment().getControllers();
        List<Controller> l = Arrays.stream(ca).filter(c -> c.getType() == Controller.Type.GAMEPAD).collect(Collectors.toList());
        if (DEBUG_DETECTION || l.isEmpty()) {
            LOG.info("Controller detection: {}", (Object)JinputGamepadInputProvider.detectAllControllerVerbose());
        }
        return l;
    }

    private Runnable inputRunnable() {
        return () -> {
            LOG.info("Starting controller polling, interval (ms): {}", (Object)POLLING_INTERVAL_MS);
            do {
                this.handleEventsInternal();
                Util.sleep(POLLING_INTERVAL_MS);
            } while (!this.stop);
            LOG.info("Controller polling stopped");
        };
    }

    @Override
    public void handleEvents() {
        if (!USE_POLLING_THREAD) {
            this.handleEventsInternal();
        }
    }

    @Override
    public void handleAllEvents(InputProvider.InputEventCallback callback) {
        for (Map.Entry<String, Controller> entry : this.controllers.entrySet()) {
            boolean hasEvents;
            Controller controller = entry.getValue();
            boolean ok = controller.poll();
            if (!ok) {
                return;
            }
            EventQueue eventQueue = controller.getEventQueue();
            do {
                Event event;
                if (!(hasEvents = eventQueue.getNextEvent(event = new Event()))) continue;
                this.gamepadCtx.c = controller;
                this.gamepadCtx.event = event;
                callback.update(this.gamepadCtx);
            } while (hasEvents);
        }
    }

    private void handleEventsInternal() {
        for (Map.Entry<String, Controller> entryC : this.controllers.entrySet()) {
            Controller controller = entryC.getValue();
            String ctrlName = entryC.getKey();
            boolean ok = controller.poll();
            if (!ok) {
                return;
            }
            int count = 0;
            for (Map.Entry<InputProvider.PlayerNumber, String> entry : this.playerControllerMap.entrySet()) {
                boolean hasEvents;
                InputProvider.PlayerNumber player = entry.getKey();
                if (!ctrlName.equalsIgnoreCase(entry.getValue())) continue;
                this.resetDirections = this.joypadProvider.hasDirectionPressed(player);
                EventQueue eventQueue = controller.getEventQueue();
                do {
                    Event event = new Event();
                    hasEvents = eventQueue.getNextEvent(event);
                    if (player == null || !hasEvents) continue;
                    this.handleEvent(player, ctrlName, event);
                    ++count;
                } while (hasEvents);
                if (!InputProvider.DEBUG_DETECTION || count <= 0) continue;
                LOG.info(this.joypadProvider.getState(player));
            }
        }
    }

    @Override
    public void setPlayerController(InputProvider.PlayerNumber player, String controllerName) {
        this.playerControllerMap.put(player, controllerName);
    }

    @Override
    public void reset() {
    }

    @Override
    public List<String> getAvailableControllers() {
        return this.controllerNames;
    }

    private void setDirectionOff(InputProvider.PlayerNumber playerNumber) {
        this.joypadProvider.setButtonAction(playerNumber, JoypadProvider.JoypadButton.D, JoypadProvider.JoypadAction.RELEASED);
        this.joypadProvider.setButtonAction(playerNumber, JoypadProvider.JoypadButton.U, JoypadProvider.JoypadAction.RELEASED);
        this.joypadProvider.setButtonAction(playerNumber, JoypadProvider.JoypadButton.L, JoypadProvider.JoypadAction.RELEASED);
        this.joypadProvider.setButtonAction(playerNumber, JoypadProvider.JoypadButton.R, JoypadProvider.JoypadAction.RELEASED);
    }

    private void handleEvent(InputProvider.PlayerNumber playerNumber, String ctrlName, Event event) {
        Map<Component.Identifier, Object> map;
        Object res;
        JoypadProvider.JoypadAction action;
        Component.Identifier id = event.getComponent().getIdentifier();
        double value = event.getValue();
        JoypadProvider.JoypadAction joypadAction = action = value == 1.0 ? JoypadProvider.JoypadAction.PRESSED : JoypadProvider.JoypadAction.RELEASED;
        if (InputProvider.DEBUG_DETECTION) {
            LOG.info("{}: {}", (Object)id, (Object)value);
            System.out.println(String.valueOf(id) + ": " + value);
        }
        if ((res = (map = this.getDeviceMappings(this.controllers.get(ctrlName).getName())).getOrDefault(id, null)) instanceof JoypadProvider.JoypadButton) {
            this.joypadProvider.setButtonAction(playerNumber, res, action);
        } else if (res instanceof JoypadProvider.JoypadDirection) {
            this.handleDPad(playerNumber, id, value);
        }
    }

    private Map<Component.Identifier, Object> getDeviceMappings(String ctrlName) {
        Map map = JinputGamepadMapping.deviceMappings.row((Object)ctrlName);
        if (map.isEmpty()) {
            map = JinputGamepadMapping.deviceMappings.row((Object)"Default Pad Name");
        }
        return map;
    }

    private void handleDPad(InputProvider.PlayerNumber playerNumber, Component.Identifier id, double value) {
        int ival;
        if (Component.Identifier.Axis.X == id) {
            ival = (int)value;
            switch (ival) {
                case 0: {
                    this.joypadProvider.setButtonAction(playerNumber, JoypadProvider.JoypadButton.R, JoypadProvider.JoypadAction.RELEASED);
                    this.joypadProvider.setButtonAction(playerNumber, JoypadProvider.JoypadButton.L, JoypadProvider.JoypadAction.RELEASED);
                    break;
                }
                case -1: {
                    this.joypadProvider.setButtonAction(playerNumber, JoypadProvider.JoypadButton.L, JoypadProvider.JoypadAction.PRESSED);
                    break;
                }
                case 1: {
                    this.joypadProvider.setButtonAction(playerNumber, JoypadProvider.JoypadButton.R, JoypadProvider.JoypadAction.PRESSED);
                }
            }
        }
        if (Component.Identifier.Axis.Y == id) {
            ival = (int)value;
            switch (ival) {
                case 0: {
                    this.joypadProvider.setButtonAction(playerNumber, JoypadProvider.JoypadButton.U, JoypadProvider.JoypadAction.RELEASED);
                    this.joypadProvider.setButtonAction(playerNumber, JoypadProvider.JoypadButton.D, JoypadProvider.JoypadAction.RELEASED);
                    break;
                }
                case -1: {
                    this.joypadProvider.setButtonAction(playerNumber, JoypadProvider.JoypadButton.U, JoypadProvider.JoypadAction.PRESSED);
                    break;
                }
                case 1: {
                    this.joypadProvider.setButtonAction(playerNumber, JoypadProvider.JoypadButton.D, JoypadProvider.JoypadAction.PRESSED);
                }
            }
        }
        if (POV.equals(id.getName())) {
            boolean off;
            JoypadProvider.JoypadAction action = JoypadProvider.JoypadAction.PRESSED;
            boolean bl = off = this.resetDirections || value == 0.0;
            if (off) {
                this.setDirectionOff(playerNumber);
                if (this.resetDirections) {
                    this.resetDirections = false;
                }
            }
            if (value == 0.75) {
                this.joypadProvider.setButtonAction(playerNumber, JoypadProvider.JoypadButton.D, action);
            }
            if (value == 0.25) {
                this.joypadProvider.setButtonAction(playerNumber, JoypadProvider.JoypadButton.U, action);
            }
            if (value == 1.0) {
                this.joypadProvider.setButtonAction(playerNumber, JoypadProvider.JoypadButton.L, action);
            }
            if (value == 0.5) {
                this.joypadProvider.setButtonAction(playerNumber, JoypadProvider.JoypadButton.R, action);
            }
            if (value == 0.875) {
                this.joypadProvider.setButtonAction(playerNumber, JoypadProvider.JoypadButton.D, action);
                this.joypadProvider.setButtonAction(playerNumber, JoypadProvider.JoypadButton.L, action);
            }
            if (value == 0.625) {
                this.joypadProvider.setButtonAction(playerNumber, JoypadProvider.JoypadButton.D, action);
                this.joypadProvider.setButtonAction(playerNumber, JoypadProvider.JoypadButton.R, action);
            }
            if (value == 0.125) {
                this.joypadProvider.setButtonAction(playerNumber, JoypadProvider.JoypadButton.U, action);
                this.joypadProvider.setButtonAction(playerNumber, JoypadProvider.JoypadButton.L, action);
            }
            if (value == 0.375) {
                this.joypadProvider.setButtonAction(playerNumber, JoypadProvider.JoypadButton.U, action);
                this.joypadProvider.setButtonAction(playerNumber, JoypadProvider.JoypadButton.R, action);
            }
        }
    }

    public static String detectControllerVerbose(Controller[] ca) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ca.length; ++i) {
            sb.append("\n").append(ca[i].getName()).append("\n");
            sb.append("Position: [").append(i).append("]\n");
            sb.append("Type: ").append(ca[i].getType().toString()).append("\n");
            Component[] components = ca[i].getComponents();
            sb.append("Component Count: ").append(components.length).append("\n");
            for (int j = 0; j < components.length; ++j) {
                sb.append("Component ").append(j).append(": ").append(components[j].getName()).append("\n");
                sb.append("    Identifier: ").append(components[j].getIdentifier().getName()).append("\n");
                sb.append("    ComponentType: ");
                if (components[j].isRelative()) {
                    sb.append("Relative");
                } else {
                    sb.append("Absolute");
                }
                if (components[j].isAnalog()) {
                    sb.append(" Analog");
                } else {
                    sb.append(" Digital");
                }
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public static String detectControllerVerbose(Controller controller) {
        return JinputGamepadInputProvider.detectControllerVerbose(new Controller[]{controller});
    }

    public static String detectAllControllerVerbose() {
        return JinputGamepadInputProvider.detectControllerVerbose(ControllerEnvironment.getDefaultEnvironment().getControllers());
    }

    static {
        POV = Component.Identifier.Axis.POV.getName();
        INSTANCE = NO_OP;
        toNameFn = (l, i) -> ((Controller)l.get((int)i)).getName() + " #" + i;
    }

    public static class UpdatedGamepadCtx {
        public Controller c;
        public Event event;
    }
}

