/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.joypad;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import omegadrive.input.InputProvider;
import omegadrive.joypad.JoypadProvider;
import omegadrive.util.LogHelper;
import org.slf4j.Logger;

public abstract class BasePadAdapter
implements JoypadProvider {
    private static final Logger LOG = LogHelper.getLogger(BasePadAdapter.class.getSimpleName());
    JoypadProvider.JoypadType p1Type;
    JoypadProvider.JoypadType p2Type;
    Map<JoypadProvider.JoypadButton, JoypadProvider.JoypadAction> stateMap1 = Collections.emptyMap();
    Map<JoypadProvider.JoypadButton, JoypadProvider.JoypadAction> stateMap2 = Collections.emptyMap();
    int value1 = 255;
    int value2 = 255;
    static final Map<JoypadProvider.JoypadButton, JoypadProvider.JoypadAction> releasedMap = ImmutableMap.builder().put((Object)JoypadProvider.JoypadButton.D, (Object)JoypadProvider.JoypadAction.RELEASED).put((Object)JoypadProvider.JoypadButton.U, (Object)JoypadProvider.JoypadAction.RELEASED).put((Object)JoypadProvider.JoypadButton.L, (Object)JoypadProvider.JoypadAction.RELEASED).put((Object)JoypadProvider.JoypadButton.R, (Object)JoypadProvider.JoypadAction.RELEASED).put((Object)JoypadProvider.JoypadButton.A, (Object)JoypadProvider.JoypadAction.RELEASED).put((Object)JoypadProvider.JoypadButton.B, (Object)JoypadProvider.JoypadAction.RELEASED).put((Object)JoypadProvider.JoypadButton.S, (Object)JoypadProvider.JoypadAction.RELEASED).build();

    protected Map<JoypadProvider.JoypadButton, JoypadProvider.JoypadAction> getMap(InputProvider.PlayerNumber number) {
        switch (number) {
            case P1: {
                return this.stateMap1;
            }
            case P2: {
                return this.stateMap2;
            }
        }
        LOG.error("Unexpected joypad number: {}", (Object)number);
        return Collections.emptyMap();
    }

    protected int getValue(InputProvider.PlayerNumber number, JoypadProvider.JoypadButton button) {
        return this.getMap(number).get((Object)button).ordinal();
    }

    @Override
    public void setButtonAction(InputProvider.PlayerNumber number, JoypadProvider.JoypadButton button, JoypadProvider.JoypadAction action) {
        if (this.getMap(number).containsKey((Object)button)) {
            this.getMap(number).replace(button, action);
        } else {
            LOG.warn("Ignored mapping {}, {} {}", new Object[]{number, button, action});
        }
    }

    @Override
    public boolean hasDirectionPressed(InputProvider.PlayerNumber number) {
        return Arrays.stream(directionButton).anyMatch(b -> this.getMap(number).get(b) == JoypadProvider.JoypadAction.PRESSED);
    }

    @Override
    public String getState(InputProvider.PlayerNumber number) {
        return this.getMap(number).toString();
    }

    @Override
    public void newFrame() {
    }
}

