/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.joypad;

import com.google.common.collect.Maps;
import java.awt.Component;
import java.awt.Label;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Map;
import omegadrive.input.InputProvider;
import omegadrive.input.KeyboardInputHelper;
import omegadrive.joypad.BasePadAdapter;
import omegadrive.joypad.JoypadProvider;
import omegadrive.util.LogHelper;
import org.slf4j.Logger;

public class ExternalPad
extends BasePadAdapter {
    private static final Logger LOG = LogHelper.getLogger(ExternalPad.class.getSimpleName());
    private final KeyListener p1Listener;
    private final KeyListener p2Listener;
    private final Component source = new Label();

    private ExternalPad(KeyListener p1, KeyListener p2, JoypadProvider.JoypadType type) {
        this.p1Listener = p1;
        this.p2Listener = p2;
        if (p2 == null) {
            KeyboardInputHelper.keyboardInverseBindings.rowMap().remove((Object)InputProvider.PlayerNumber.P2);
        }
        this.p1Type = type;
        this.p2Type = type;
        LOG.info("Joypad1: {} - Joypad2: {}", (Object)this.p1Type, (Object)this.p2Type);
    }

    public static BasePadAdapter createTwoButtonsPad(KeyListener p1) {
        return new ExternalPad(p1, null, JoypadProvider.JoypadType.BUTTON_2);
    }

    public static BasePadAdapter createTwoButtonsPad(KeyListener p1, KeyListener p2) {
        return new ExternalPad(p1, p2, JoypadProvider.JoypadType.BUTTON_2);
    }

    public static BasePadAdapter createSixButtonsPad(KeyListener p1, KeyListener p2) {
        return new ExternalPad(p1, p2, JoypadProvider.JoypadType.BUTTON_6);
    }

    @Override
    public void init() {
        this.stateMap1 = Maps.newHashMap((Map)releasedMap);
        this.stateMap2 = Maps.newHashMap((Map)releasedMap);
    }

    @Override
    public void setButtonAction(InputProvider.PlayerNumber number, JoypadProvider.JoypadButton button, JoypadProvider.JoypadAction action) {
        KeyEvent event = new KeyEvent(this.source, action == JoypadProvider.JoypadAction.PRESSED ? 401 : 402, System.currentTimeMillis(), 0, 0, '?');
        this.setButtonAction(number, button, action, event);
    }

    @Override
    public void setButtonAction(InputProvider.PlayerNumber number, JoypadProvider.JoypadButton button, JoypadProvider.JoypadAction action, KeyEvent event) {
        KeyListener keyListener;
        super.setButtonAction(number, button, action);
        Map btnMap = KeyboardInputHelper.keyboardBindings.row((Object)number);
        KeyListener keyListener2 = keyListener = number == InputProvider.PlayerNumber.P1 ? this.p1Listener : this.p2Listener;
        if (btnMap.containsKey((Object)button)) {
            event.setKeyCode((Integer)btnMap.get((Object)button));
            if (action == JoypadProvider.JoypadAction.PRESSED) {
                keyListener.keyPressed(event);
            } else {
                keyListener.keyReleased(event);
            }
        }
    }
}

