/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.joypad;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import omegadrive.UserConfigHolder;
import omegadrive.input.InputProvider;
import omegadrive.joypad.BasePadAdapter;
import omegadrive.joypad.JoypadProvider;
import omegadrive.joypad.MdInputModel;
import omegadrive.system.SystemProvider;
import omegadrive.util.LogHelper;
import org.slf4j.Logger;

public class MdJoypad
extends BasePadAdapter {
    private static final Logger LOG = LogHelper.getLogger(MdJoypad.class.getSimpleName());
    private static final int M68K_CYCLES_PAD_RESET = 12000;
    protected static boolean WWF32X_HACK = Boolean.parseBoolean(System.getProperty("helios.md.pad.wwf32x.hack", "false"));
    protected static final boolean ASTERIX_HACK = Boolean.parseBoolean(System.getProperty("helios.md.pad.asterix.hack", "false"));
    protected static final boolean verbose = false;
    protected final MdInputModel.MdPadContext ctx1 = new MdInputModel.MdPadContext(1);
    protected final MdInputModel.MdPadContext ctx2 = new MdInputModel.MdPadContext(2);
    protected final MdInputModel.MdPadContext ctx3 = new MdInputModel.MdPadContext(3);
    private final SystemProvider.SystemClock clock;

    public static MdJoypad create(SystemProvider.SystemClock clock) {
        return new MdJoypad(clock);
    }

    public MdJoypad(SystemProvider.SystemClock clock) {
        this.clock = clock;
        this.p1Type = JoypadProvider.JoypadType.BUTTON_6;
        this.p2Type = JoypadProvider.JoypadType.BUTTON_6;
    }

    @Override
    public void init() {
        this.stateMap1 = Maps.newHashMap((Map)ImmutableMap.builder().put((Object)JoypadProvider.JoypadButton.D, (Object)JoypadProvider.JoypadAction.RELEASED).put((Object)JoypadProvider.JoypadButton.U, (Object)JoypadProvider.JoypadAction.RELEASED).put((Object)JoypadProvider.JoypadButton.L, (Object)JoypadProvider.JoypadAction.RELEASED).put((Object)JoypadProvider.JoypadButton.R, (Object)JoypadProvider.JoypadAction.RELEASED).put((Object)JoypadProvider.JoypadButton.S, (Object)JoypadProvider.JoypadAction.RELEASED).put((Object)JoypadProvider.JoypadButton.A, (Object)JoypadProvider.JoypadAction.RELEASED).put((Object)JoypadProvider.JoypadButton.B, (Object)JoypadProvider.JoypadAction.RELEASED).put((Object)JoypadProvider.JoypadButton.C, (Object)JoypadProvider.JoypadAction.RELEASED).put((Object)JoypadProvider.JoypadButton.M, (Object)JoypadProvider.JoypadAction.RELEASED).put((Object)JoypadProvider.JoypadButton.X, (Object)JoypadProvider.JoypadAction.RELEASED).put((Object)JoypadProvider.JoypadButton.Y, (Object)JoypadProvider.JoypadAction.RELEASED).put((Object)JoypadProvider.JoypadButton.Z, (Object)JoypadProvider.JoypadAction.RELEASED).build());
        this.stateMap2 = Maps.newHashMap((Map)this.stateMap1);
        for (InputProvider.PlayerNumber pn : InputProvider.PlayerNumber.values()) {
            Object obj = UserConfigHolder.userEventObjectMap.get((Object)pn, (Object)SystemProvider.SystemEvent.PAD_SETUP_CHANGE);
            if (obj == null) continue;
            this.setPadSetupChange(pn, obj.toString());
        }
        this.reset();
        assert (this.p1Type != null && this.p2Type != null);
    }

    @Override
    public void reset() {
        super.reset();
        this.ctx3.data = 64;
        this.ctx2.data = 64;
        this.ctx1.data = 64;
    }

    @Override
    public void setPadSetupChange(InputProvider.PlayerNumber pn, String info) {
        JoypadProvider.JoypadType jt = JoypadProvider.JoypadType.valueOf(info);
        switch (pn) {
            case P1: {
                this.p1Type = jt;
                break;
            }
            case P2: {
                this.p2Type = jt;
            }
        }
        LOG.info("Setting {} joypad type to: {}", (Object)pn, (Object)jt);
    }

    public int readDataRegister1() {
        return this.readPad(InputProvider.PlayerNumber.P1, this.p1Type, this.ctx1);
    }

    public int readDataRegister2() {
        return this.readPad(InputProvider.PlayerNumber.P2, this.p2Type, this.ctx2);
    }

    public int readDataRegister3() {
        return 255;
    }

    public void writeDataRegister1(int data) {
        this.writePad(this.ctx1, this.p1Type, data);
    }

    public void writeDataRegister2(int data) {
        this.writePad(this.ctx2, this.p2Type, data);
    }

    private void writeControlPad(MdInputModel.MdPadContext ctx, JoypadProvider.JoypadType type, int control) {
        ctx.control = control;
        if (WWF32X_HACK && MdInputModel.isCtrlThInput.test(control)) {
            ctx.data |= 0x40;
        }
        this.writeControlCheck(ctx, control);
    }

    private void writePad(MdInputModel.MdPadContext ctx, JoypadProvider.JoypadType type, int data) {
        this.checkResetState(ctx, type);
        boolean thPinHigh = MdInputModel.isDataThHigh.test(data);
        boolean wasThPinHigh = MdInputModel.isDataThHigh.test(ctx.data);
        if (thPinHigh != wasThPinHigh) {
            ctx.readStep = ctx.readStep + 1 & 7;
            if (type != JoypadProvider.JoypadType.BUTTON_6) {
                ctx.readStep &= 1;
            }
        }
        ctx.data = data;
        ctx.readMask = 0x80 | ctx.control & data;
    }

    private void resetPad(MdInputModel.MdPadContext ctx) {
        ctx.data = ASTERIX_HACK ? 0 : 64;
        ctx.readMask = 0x80 | ctx.control & ctx.data;
        ctx.readStep = ASTERIX_HACK ? 1 : 0;
        ctx.latestWriteCycleCounter = 0;
    }

    private void checkResetState(MdInputModel.MdPadContext ctx, JoypadProvider.JoypadType type) {
        if (type != JoypadProvider.JoypadType.BUTTON_6) {
            return;
        }
        int fc = this.clock.getCycleCounter();
        if (fc - ctx.latestWriteCycleCounter > 12000) {
            this.resetPad(ctx);
        }
        ctx.latestWriteCycleCounter = fc;
    }

    private int readPad(InputProvider.PlayerNumber n, JoypadProvider.JoypadType type, MdInputModel.MdPadContext ctx) {
        if (type == JoypadProvider.JoypadType.NONE) {
            return 255;
        }
        if (WWF32X_HACK && MdInputModel.isCtrlThInput.test(ctx.control)) {
            int res = (ctx.data | ~ctx.control) & 0xFF;
            return res;
        }
        int step = ctx.readStep;
        int res = switch (MdInputModel.SixButtonState.vals[step]) {
            case MdInputModel.SixButtonState.SA0000_5 -> {
                if (!$assertionsDisabled && MdInputModel.isDataThHigh.test(ctx.data)) {
                    throw new AssertionError();
                }
                yield this.getSA0000(n);
            }
            case MdInputModel.SixButtonState.CBMXYZ_6 -> {
                if (!$assertionsDisabled && !MdInputModel.isDataThHigh.test(ctx.data)) {
                    throw new AssertionError();
                }
                yield this.getCBMXYZ(n);
            }
            case MdInputModel.SixButtonState.SA1111_7 -> {
                if (!$assertionsDisabled && MdInputModel.isDataThHigh.test(ctx.data)) {
                    throw new AssertionError();
                }
                yield this.getSA1111(n);
            }
            default -> {
                if (!$assertionsDisabled && (step & 1) == 0 != MdInputModel.isDataThHigh.test(ctx.data)) {
                    throw new AssertionError(ctx);
                }
                yield (step & 1) == 0 ? this.getCBRLDU(n) : this.getSA00DU(n);
            }
        };
        res = res & ~ctx.readMask | ctx.data & this.ctx1.readMask;
        return res;
    }

    private void writeControlCheck(MdInputModel.MdPadContext ctx, int value) {
        if (value == 64 || value != 0) {
            // empty if block
        }
    }

    public void writeControlRegister1(int value) {
        this.writeControlPad(this.ctx1, this.p1Type, value);
    }

    public void writeControlRegister2(int value) {
        this.writeControlPad(this.ctx2, this.p2Type, value);
    }

    public void writeControlRegister3(int value) {
        this.writeControlPad(this.ctx3, JoypadProvider.JoypadType.BUTTON_3, value);
    }

    private int getSA0000(InputProvider.PlayerNumber n) {
        return this.getValue(n, JoypadProvider.JoypadButton.S) << 5 | this.getValue(n, JoypadProvider.JoypadButton.A) << 4;
    }

    private int getSA1111(InputProvider.PlayerNumber n) {
        return this.getValue(n, JoypadProvider.JoypadButton.S) << 5 | this.getValue(n, JoypadProvider.JoypadButton.A) << 4 | 0xF;
    }

    private int getSA00DU(InputProvider.PlayerNumber n) {
        return this.getValue(n, JoypadProvider.JoypadButton.S) << 5 | this.getValue(n, JoypadProvider.JoypadButton.A) << 4 | this.getValue(n, JoypadProvider.JoypadButton.D) << 1 | this.getValue(n, JoypadProvider.JoypadButton.U);
    }

    private int getCBRLDU(InputProvider.PlayerNumber n) {
        return this.getValue(n, JoypadProvider.JoypadButton.C) << 5 | this.getValue(n, JoypadProvider.JoypadButton.B) << 4 | this.getValue(n, JoypadProvider.JoypadButton.R) << 3 | this.getValue(n, JoypadProvider.JoypadButton.L) << 2 | this.getValue(n, JoypadProvider.JoypadButton.D) << 1 | this.getValue(n, JoypadProvider.JoypadButton.U);
    }

    private int getCBMXYZ(InputProvider.PlayerNumber n) {
        return this.getValue(n, JoypadProvider.JoypadButton.C) << 5 | this.getValue(n, JoypadProvider.JoypadButton.B) << 4 | this.getValue(n, JoypadProvider.JoypadButton.M) << 3 | this.getValue(n, JoypadProvider.JoypadButton.X) << 2 | this.getValue(n, JoypadProvider.JoypadButton.Y) << 1 | this.getValue(n, JoypadProvider.JoypadButton.Z);
    }

    public int readControlRegister1() {
        return this.readControlRegister(this.ctx1);
    }

    public int readControlRegister2() {
        return this.readControlRegister(this.ctx2);
    }

    public int readControlRegister3() {
        return this.readControlRegister(this.ctx3);
    }

    private int readControlRegister(MdInputModel.MdPadContext ctx) {
        return ctx.control;
    }

    @Override
    public void newFrame() {
        super.newFrame();
        this.resetPad(this.ctx1);
        this.resetPad(this.ctx2);
    }
}

