/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.memory;

import java.nio.ByteBuffer;
import java.util.stream.IntStream;
import omegadrive.memory.IMemoryProvider;
import omegadrive.util.LogHelper;
import omegadrive.util.RomHolder;
import omegadrive.util.Size;
import omegadrive.util.Util;
import org.slf4j.Logger;

public class MemoryProvider
implements IMemoryProvider {
    private static final Logger LOG = LogHelper.getLogger(MemoryProvider.class.getSimpleName());
    public static final IMemoryProvider NO_MEMORY = MemoryProvider.createInstance(RomHolder.EMPTY_ROM, 0);
    public static final int M68K_RAM_SIZE = 65536;
    public static final int SG1K_Z80_RAM_SIZE = 1024;
    public static final int MSX_Z80_RAM_SIZE = 16384;
    public static final int SMS_Z80_RAM_SIZE = 8192;
    public static final int CHECKSUM_START_ADDRESS = 398;
    private byte[] ram;
    private int ramSize = 65536;
    private RomHolder romHolder;

    private MemoryProvider() {
    }

    public static IMemoryProvider createMdInstance() {
        return MemoryProvider.createInstance(RomHolder.EMPTY_ROM, 65536);
    }

    public static IMemoryProvider createSg1000Instance() {
        return MemoryProvider.createInstance(RomHolder.EMPTY_ROM, 1024);
    }

    public static IMemoryProvider createMsxInstance() {
        return MemoryProvider.createInstance(RomHolder.EMPTY_ROM, 16384);
    }

    public static IMemoryProvider createSmsInstance() {
        return MemoryProvider.createInstance(RomHolder.EMPTY_ROM, 8192);
    }

    public static IMemoryProvider createInstance(RomHolder romHolder, int ramSize) {
        MemoryProvider m = new MemoryProvider();
        m.romHolder = romHolder;
        m.ram = Util.initMemoryRandomBytes(new byte[ramSize]);
        m.ramSize = ramSize;
        return m;
    }

    public static IMemoryProvider createInstance(byte[] rom, int ramSize) {
        return MemoryProvider.createInstance(new RomHolder(rom), ramSize);
    }

    @Override
    public int readRomByte(int address) {
        return Util.readDataMask(this.romHolder.data, address, this.romHolder.romMask, Size.BYTE);
    }

    @Override
    public byte readRamByte(int address) {
        if (address < this.ramSize) {
            return this.ram[address];
        }
        LOG.error("Invalid RAM read, address : {}", (Object)Util.th(address));
        return 0;
    }

    @Override
    public void writeRamByte(int address, byte data) {
        if (address < this.ramSize) {
            this.ram[address] = data;
        } else {
            LOG.error("Invalid RAM write, address : {}, data: {}", (Object)Util.th(address), (Object)data);
        }
    }

    @Override
    public void setRomData(byte[] data) {
        this.romHolder = new RomHolder(data);
    }

    @Override
    public void setChecksumRomValue(long value) {
        Util.writeDataMask(this.romHolder.data, 398, (byte)(value >> 8 & 0xFFL), this.romHolder.romMask, Size.BYTE);
        Util.writeDataMask(this.romHolder.data, 399, (byte)(value & 0xFFL), this.romHolder.romMask, Size.BYTE);
    }

    @Override
    public byte[] getRamData() {
        return this.ram;
    }

    @Override
    public RomHolder getRomHolder() {
        return this.romHolder;
    }

    @Override
    public void saveContext(ByteBuffer buffer) {
        IntStream.range(0, this.ram.length).forEach(i -> buffer.put((byte)(this.ram[i] & 0xFF)));
    }

    @Override
    public void loadContext(ByteBuffer buffer) {
        IntStream.range(0, this.ram.length).forEach(i -> {
            this.ram[i] = buffer.get();
        });
    }
}

