/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.savestate;

import com.google.common.primitives.Bytes;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.Set;
import omegadrive.Device;
import omegadrive.bus.md.SvpMapper;
import omegadrive.bus.model.MdMainBusProvider;
import omegadrive.cpu.ssp16.Ssp16;
import omegadrive.cpu.ssp16.Ssp16Types;
import omegadrive.cpu.z80.Z80Provider;
import omegadrive.savestate.BaseStateHandler;
import omegadrive.savestate.GstStateHandler;
import omegadrive.savestate.StateUtil;
import omegadrive.sound.fm.FmProvider;
import omegadrive.sound.fm.ym2612.nukeykt.Ym2612Nuke;
import omegadrive.util.LogHelper;
import omegadrive.util.Util;
import org.slf4j.Logger;

public class GshStateHandler
extends GstStateHandler {
    private static final Logger LOG = LogHelper.getLogger(GshStateHandler.class.getSimpleName());
    protected static final String MAGIC_WORD = "GSH";
    protected static final String MAGIC_WORD_GST = "GST";
    protected static final String FM_MAGIC_WORD_NUKE = "NUKE";
    protected static final String SVP_MAGIC_WORD = "SVP0";
    protected static final String fileExtension = "gsh";
    private static final int SSF2_MAPPER_REG_OFFSET = 1088;

    public static BaseStateHandler createInstance(String fileName, BaseStateHandler.Type type, Set<Device> deviceSet) {
        GshStateHandler h = new GshStateHandler();
        h.type = type;
        h.init(fileName);
        h.setDevicesWithContext(deviceSet);
        return h;
    }

    protected GshStateHandler() {
    }

    protected static String handleFileExtension(String fileName) {
        boolean hasExtension = fileName.toLowerCase().contains(".gs");
        return fileName + (!hasExtension ? ".gsh" : "");
    }

    protected void init(String fileNameEx) {
        this.fileName = GshStateHandler.handleFileExtension(fileNameEx);
        if (this.type == BaseStateHandler.Type.SAVE) {
            this.buffer = ByteBuffer.allocate(140408);
            this.buffer.put(MAGIC_WORD.getBytes());
            this.buffer.put(6, (byte)-32).put(7, (byte)64);
        } else {
            this.buffer = StateUtil.loadStateFile(this.fileName, ".gs");
            this.detectStateFileType();
        }
    }

    protected BaseStateHandler detectStateFileType() {
        boolean isSupported;
        String fileType = Util.toStringValue(this.buffer.get(), this.buffer.get(), this.buffer.get());
        boolean bl = isSupported = MAGIC_WORD.equalsIgnoreCase(fileType) || MAGIC_WORD_GST.equalsIgnoreCase(fileType);
        if (!isSupported || this.buffer.capacity() < 140408) {
            LOG.error("Unable to load save state of type: {}, size: {}", (Object)fileType, (Object)this.buffer.capacity());
            return BaseStateHandler.EMPTY_STATE;
        }
        this.version = this.buffer.get(80) & 0xFF;
        this.softwareId = this.buffer.get(81) & 0xFF;
        LOG.info("Savestate type {}, version: {}, softwareId: {}", new Object[]{fileType, this.version, this.softwareId});
        if (MAGIC_WORD_GST.equalsIgnoreCase(fileType)) {
            LOG.warn("Loading a {} savestate, fm sound may not work correctly!", (Object)fileType);
        }
        return this;
    }

    @Override
    public void loadFmState(FmProvider fm) {
        byte[] ba = this.buffer.array();
        int fmNukeStart = Bytes.indexOf((byte[])ba, (byte[])FM_MAGIC_WORD_NUKE.getBytes());
        if (fmNukeStart > -1 && fm instanceof Ym2612Nuke) {
            Ym2612Nuke nukeFm = (Ym2612Nuke)fm;
            Optional<Serializable> res = StateUtil.loadSerializedData(FM_MAGIC_WORD_NUKE, fmNukeStart, ba);
            res.ifPresent(ser -> nukeFm.setState((Ym2612Nuke.Ym3438Context)ser));
        } else {
            super.loadFmState(fm);
        }
    }

    public void loadSvpState(Ssp16 ssp16) {
        byte[] ba = this.buffer.array();
        int svpStart = Bytes.indexOf((byte[])ba, (byte[])SVP_MAGIC_WORD.getBytes());
        if (svpStart > -1 && ssp16 != Ssp16.NO_SVP) {
            Optional<Serializable> res = StateUtil.loadSerializedData(SVP_MAGIC_WORD, svpStart, ba);
            res.ifPresent(ser -> SvpMapper.setSvpContext((Ssp16Types.Svp_t)ser));
        }
    }

    @Override
    public void saveFm(FmProvider fm) {
        super.saveFm(fm);
        if (fm instanceof Ym2612Nuke) {
            Ym2612Nuke.Ym3438Context chip = ((Ym2612Nuke)fm).getState();
            this.buffer = StateUtil.storeSerializedData(FM_MAGIC_WORD_NUKE, chip, this.buffer);
        }
    }

    private void saveSvp(Ssp16 ssp16) {
        if (ssp16 != Ssp16.NO_SVP) {
            this.buffer = StateUtil.storeSerializedData(SVP_MAGIC_WORD, ssp16.getSvpContext(), this.buffer);
        }
    }

    @Override
    public void saveZ80(Z80Provider z80, MdMainBusProvider bus) {
        super.saveZ80(z80, bus);
        this.saveMapper(bus);
        this.saveSvp(SvpMapper.ssp16);
    }

    private void saveMapper(MdMainBusProvider bus) {
        int[] data = bus.getMapperData();
        for (int i = 0; i < data.length; ++i) {
            this.buffer.put(1088 + i, (byte)data[i]);
        }
    }

    @Override
    public void loadZ80(Z80Provider z80, MdMainBusProvider bus) {
        super.loadZ80(z80, bus);
        this.loadMapper(bus);
        this.loadSvpState(SvpMapper.ssp16);
    }

    private void loadMapper(MdMainBusProvider bus) {
        int[] data = new int[8];
        for (int i = 0; i < data.length; ++i) {
            data[i] = this.buffer.get(1088 + i) & 0xFF;
        }
        bus.setMapperData(data);
    }
}

