/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.savestate;

import com.grapeshot.halfnes.NES;
import com.grapeshot.halfnes.state.HalfnesSaveStateHandler;
import java.nio.ByteBuffer;
import java.nio.file.Paths;
import omegadrive.savestate.BaseStateHandler;
import omegadrive.util.FileUtil;

public class NesStateHandler
implements BaseStateHandler {
    private static final String fileExtension = "n00";
    private final HalfnesSaveStateHandler handler = new HalfnesSaveStateHandler();
    private byte[] stateData;
    private String fileName;
    private BaseStateHandler.Type type;
    private NES nes;

    public static NesStateHandler createInstance(String fileName, BaseStateHandler.Type type) {
        return type == BaseStateHandler.Type.LOAD ? NesStateHandler.createLoadInstance(fileName) : NesStateHandler.createSaveInstance(fileName);
    }

    private static NesStateHandler createLoadInstance(String fileName) {
        NesStateHandler n = new NesStateHandler();
        n.fileName = NesStateHandler.handleFileExtension(fileName);
        n.type = BaseStateHandler.Type.LOAD;
        n.stateData = FileUtil.readBinaryFile(Paths.get(n.fileName, new String[0]), fileExtension);
        return n;
    }

    private static NesStateHandler createSaveInstance(String fileName) {
        NesStateHandler n = new NesStateHandler();
        n.fileName = NesStateHandler.handleFileExtension(fileName);
        n.type = BaseStateHandler.Type.SAVE;
        return n;
    }

    public void setNes(NES nes) {
        this.nes = nes;
    }

    private static String handleFileExtension(String fileName) {
        return fileName + (!fileName.toLowerCase().contains(".n0") ? ".n00" : "");
    }

    @Override
    public BaseStateHandler.Type getType() {
        return this.type;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public ByteBuffer getDataBuffer() {
        return ByteBuffer.wrap(this.stateData);
    }

    @Override
    public byte[] getData() {
        return this.stateData;
    }

    @Override
    public void processState() {
        switch (this.type) {
            case LOAD: {
                this.handler.setSaveStateData(this.nes, this.stateData);
                break;
            }
            case SAVE: {
                this.stateData = this.handler.getSaveStateData(this.nes);
            }
        }
    }
}

