/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.savestate;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import com.google.common.primitives.Bytes;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.zip.ZipEntry;
import omegadrive.Device;
import omegadrive.SystemLoader;
import omegadrive.cpu.z80.Z80Helper;
import omegadrive.savestate.BaseStateHandler;
import omegadrive.util.ArrayEndianUtil;
import omegadrive.util.FileUtil;
import omegadrive.util.LogHelper;
import omegadrive.util.Util;
import omegadrive.util.ZipUtil;
import org.slf4j.Logger;
import z80core.Z80;
import z80core.Z80State;

public class StateUtil {
    public static final Map<SystemLoader.SystemType, String> fileExtensionMap = ImmutableMap.of((Object)((Object)SystemLoader.SystemType.SG_1000), (Object)"sgs", (Object)((Object)SystemLoader.SystemType.COLECO), (Object)"cvs", (Object)((Object)SystemLoader.SystemType.MSX), (Object)"mss");
    private static final byte[] arr4 = new byte[4];
    private static final byte[] arr2 = new byte[2];
    public static final BiFunction<ByteBuffer, Integer, Integer> getInt2Fn = (b, pos) -> {
        b.position((int)pos);
        b.get(arr2);
        return ArrayEndianUtil.getUInt32LE(arr2);
    };
    private static final Logger LOG = LogHelper.getLogger(StateUtil.class.getSimpleName());
    public static final BiFunction<ByteBuffer, Integer, Integer> getInt4Fn = (b, pos) -> {
        b.position((int)pos);
        b.get(arr4);
        return ArrayEndianUtil.getUInt32LE(arr4);
    };

    public static void setInt4LEFn(ByteBuffer b, int pos, int val) {
        ArrayEndianUtil.setUInt32LE(val, arr4, 0);
        b.position(pos);
        b.put(arr4);
    }

    public static void setInt2LEFn(ByteBuffer b, int pos, int val) {
        b.put(pos, (byte)(val & 0xFF));
        b.put(pos + 1, (byte)(val >> 8 & 0xFF));
    }

    public static void setDataAsBytes(ByteBuffer buf, int ... data) {
        Arrays.stream(data).forEach(val -> buf.put((byte)(val & 0xFF)));
    }

    public static void setData(ByteBuffer buf, int ... data) {
        Arrays.stream(data).forEach(buf::putInt);
    }

    public static void skip(ByteBuffer buf, int len) {
        buf.position(buf.position() + len);
    }

    public static ByteBuffer extendBuffer(ByteBuffer current, int increaseDelta) {
        ByteBuffer extBuffer = ByteBuffer.allocate(current.capacity() + increaseDelta);
        current.position(0);
        extBuffer.put(current);
        extBuffer.position(current.capacity());
        return extBuffer;
    }

    public static void saveZ80State(ByteBuffer buffer, Z80State s) {
        StateUtil.setDataAsBytes(buffer, s.getRegF(), s.getRegA(), s.getRegC(), s.getRegB(), s.getRegE(), s.getRegD(), s.getRegL(), s.getRegH());
        StateUtil.setDataAsBytes(buffer, s.getRegIX() & 0xFF, s.getRegIX() >> 8, s.getRegIY() & 0xFF, s.getRegIY() >> 8, s.getRegPC() & 0xFF, s.getRegPC() >> 8, s.getRegSP() & 0xFF, s.getRegSP() >> 8);
        StateUtil.setDataAsBytes(buffer, s.getRegFx(), s.getRegAx(), s.getRegCx(), s.getRegBx(), s.getRegEx(), s.getRegDx(), s.getRegLx(), s.getRegHx(), s.getRegI());
        int val = (s.isHalted() ? 1 : 0) << 8 | (s.isIFF2() ? 1 : 0) << 3 | s.getIM().ordinal() << 1 | (s.isIFF1() ? 1 : 0);
        StateUtil.setDataAsBytes(buffer, val);
    }

    public static Z80State loadZ80State(ByteBuffer data) {
        Z80State z80State = new Z80State();
        z80State.setRegAF(ArrayEndianUtil.getUInt32LE(data.get(), data.get()));
        z80State.setRegBC(ArrayEndianUtil.getUInt32LE(data.get(), data.get()));
        z80State.setRegDE(ArrayEndianUtil.getUInt32LE(data.get(), data.get()));
        z80State.setRegHL(ArrayEndianUtil.getUInt32LE(data.get(), data.get()));
        z80State.setRegIX(ArrayEndianUtil.getUInt32LE(data.get(), data.get()));
        z80State.setRegIY(ArrayEndianUtil.getUInt32LE(data.get(), data.get()));
        z80State.setRegPC(ArrayEndianUtil.getUInt32LE(data.get(), data.get()));
        z80State.setRegSP(ArrayEndianUtil.getUInt32LE(data.get(), data.get()));
        z80State.setRegAFx(ArrayEndianUtil.getUInt32LE(data.get(), data.get()));
        z80State.setRegBCx(ArrayEndianUtil.getUInt32LE(data.get(), data.get()));
        z80State.setRegDEx(ArrayEndianUtil.getUInt32LE(data.get(), data.get()));
        z80State.setRegHLx(ArrayEndianUtil.getUInt32LE(data.get(), data.get()));
        z80State.setRegI(data.get() & 0xFF);
        byte val = data.get();
        Z80.IntMode im = Z80Helper.parseIntMode(val >> 1 & 3);
        z80State.setIM(im);
        z80State.setIFF1((val & 1) > 0);
        z80State.setIFF2((val & 8) > 0);
        z80State.setHalted((val & 0x80) > 0);
        return z80State;
    }

    public static void saveZ80StateGst(ByteBuffer buffer, Z80State z80State) {
        StateUtil.setInt4LEFn(buffer, 1028, z80State.getRegAF());
        StateUtil.setInt4LEFn(buffer, 1032, z80State.getRegBC());
        StateUtil.setInt4LEFn(buffer, 1036, z80State.getRegDE());
        StateUtil.setInt4LEFn(buffer, 1040, z80State.getRegHL());
        StateUtil.setInt4LEFn(buffer, 1044, z80State.getRegIX());
        StateUtil.setInt4LEFn(buffer, 1048, z80State.getRegIY());
        StateUtil.setInt4LEFn(buffer, 1052, z80State.getRegPC());
        StateUtil.setInt4LEFn(buffer, 1056, z80State.getRegSP());
        StateUtil.setInt4LEFn(buffer, 1060, z80State.getRegAFx());
        StateUtil.setInt4LEFn(buffer, 1064, z80State.getRegBCx());
        StateUtil.setInt4LEFn(buffer, 1068, z80State.getRegDEx());
        StateUtil.setInt4LEFn(buffer, 1072, z80State.getRegHLx());
        StateUtil.setInt4LEFn(buffer, 1076, z80State.getRegI());
        buffer.put(1078, (byte)(z80State.isIFF1() ? 1 : 0));
    }

    public static Z80State loadZ80StateGst(ByteBuffer buffer) {
        Z80State z80State = new Z80State();
        z80State.setRegAF(getInt2Fn.apply(buffer, 1028).intValue());
        z80State.setRegBC(getInt2Fn.apply(buffer, 1032).intValue());
        z80State.setRegDE(getInt2Fn.apply(buffer, 1036).intValue());
        z80State.setRegHL(getInt2Fn.apply(buffer, 1040).intValue());
        z80State.setRegIX(getInt2Fn.apply(buffer, 1044).intValue());
        z80State.setRegIY(getInt2Fn.apply(buffer, 1048).intValue());
        z80State.setRegPC(getInt2Fn.apply(buffer, 1052).intValue());
        z80State.setRegSP(getInt2Fn.apply(buffer, 1056).intValue());
        z80State.setRegAFx(getInt2Fn.apply(buffer, 1060).intValue());
        z80State.setRegBCx(getInt2Fn.apply(buffer, 1064).intValue());
        z80State.setRegDEx(getInt2Fn.apply(buffer, 1068).intValue());
        z80State.setRegHLx(getInt2Fn.apply(buffer, 1072).intValue());
        z80State.setRegI(getInt2Fn.apply(buffer, 1076).intValue());
        boolean iffN = (buffer.get(1078) & 0xFF) > 0;
        z80State.setIFF1(iffN);
        z80State.setIFF2(iffN);
        return z80State;
    }

    public static Optional<Serializable> loadSerializedData(String magicWord, int dataStart, byte[] data) {
        int dataEnd = StateUtil.getNextPosForPattern(data, dataStart += magicWord.length(), magicWord);
        return Optional.ofNullable(Util.deserializeObject(data, dataStart, dataEnd - dataStart));
    }

    public static ByteBuffer storeSerializedData(String magicWord, Serializable object, ByteBuffer buffer) {
        return StateUtil.storeSerializedData(magicWord, magicWord, object, buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer storeSerializedData(String magicWordStart, String magicWordEnd, Serializable object, ByteBuffer buffer) {
        int prevPos = buffer.position();
        int len = magicWordStart.length() + magicWordEnd.length();
        byte[] data = Util.serializeObject(object);
        buffer = StateUtil.extendBuffer(buffer, data.length + len);
        try {
            buffer.put(magicWordStart.getBytes());
            buffer.put(data);
            buffer.put(magicWordEnd.getBytes());
        }
        catch (Exception var10) {
            LOG.error("Unable to save {} data", (Object)magicWordStart);
        }
        finally {
            buffer.position(prevPos);
        }
        return buffer;
    }

    private static int getNextPosForPattern(byte[] buf, int startPos, String pattern) {
        byte[] ba2 = Arrays.copyOfRange(buf, startPos, buf.length);
        int endPos = Bytes.indexOf((byte[])ba2, (byte[])pattern.getBytes()) + startPos;
        return endPos > startPos ? endPos : buf.length;
    }

    public static void processState(BaseStateHandler state, List<Device> list) {
        if (state.getType() == BaseStateHandler.Type.LOAD) {
            list.forEach(d -> d.loadContext(state.getDataBuffer()));
        } else {
            list.forEach(d -> d.saveContext(state.getDataBuffer()));
        }
    }

    static List<Device> getDeviceOrderList(Set<Class<? extends Device>> deviceClassSet, Set<Device> devs) {
        ArrayList<Device> sysList = new ArrayList<Device>(devs);
        ArrayList<Device> ds = new ArrayList<Device>();
        block0: for (Class<? extends Device> c : deviceClassSet) {
            for (int j = 0; j < sysList.size(); ++j) {
                if (!c.isAssignableFrom(((Device)sysList.get(j)).getClass())) continue;
                ds.add((Device)sysList.get(j));
                continue block0;
            }
        }
        return ds;
    }

    public static String getStateFileName(String fileName, String ... exts) {
        Optional<? extends ZipEntry> opt;
        String fileNameEx = fileName;
        Path p = Paths.get(fileName, new String[0]);
        if (ZipUtil.isCompressedByteStream(p) && (opt = ZipUtil.getSupportedZipEntryIfAny(p, exts)).isPresent()) {
            fileNameEx = opt.get().getName();
        }
        return fileNameEx;
    }

    public static ByteBuffer loadStateFile(String fileName, String ... exts) {
        String ext = Files.getFileExtension((String)StateUtil.getStateFileName(fileName, exts));
        return ByteBuffer.wrap(FileUtil.readBinaryFile(Paths.get(fileName, new String[0]), ext));
    }

    public static <T extends Device> T getInstanceOrThrow(List<Device> deviceList, Class<T> clazz) {
        return (T)((Device)Util.getDeviceIfAny(deviceList, clazz).orElseThrow(() -> new RuntimeException("Unable to find an instance of class: " + String.valueOf(clazz) + ", from list: " + Arrays.toString(deviceList.toArray()))));
    }
}

