/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.sound.fm.ym2413;

import javax.sound.sampled.AudioFormat;
import omegadrive.sound.fm.FmProvider;
import omegadrive.sound.fm.VariableSampleRateSource;
import omegadrive.sound.fm.ym2413.Emu2413;
import omegadrive.sound.fm.ym2413.OPLL;
import omegadrive.util.LogHelper;
import org.slf4j.Logger;

public class Ym2413Provider
extends VariableSampleRateSource {
    private static final Logger LOG = LogHelper.getLogger(Ym2413Provider.class.getSimpleName());
    public static final double FM_RATE = 49716.0;
    private static final int CLOCK_HZ = 3579545;
    final double ratio;
    double rateAccum;
    double adjustedRatio;
    private OPLL opll;
    private int sample;

    protected Ym2413Provider(AudioFormat audioFormat) {
        super(49716.0, audioFormat, "fmDsa");
        this.ratio = this.microsPerOutputSample / this.microsPerInputSample;
    }

    public static FmProvider createInstance(AudioFormat audioFormat) {
        Ym2413Provider p = new Ym2413Provider(audioFormat);
        p.init();
        return p;
    }

    @Override
    public void reset() {
        for (int i = 16; i < 64; ++i) {
            Emu2413.OPLL_writeIO(this.opll, 0, i);
            Emu2413.OPLL_writeIO(this.opll, 1, 0);
        }
        Emu2413.OPLL_reset_patch(this.opll);
        Emu2413.OPLL_reset(this.opll);
    }

    @Override
    public void tick() {
        this.rateAccum += this.adjustedRatio;
        this.spinOnce();
        if (this.rateAccum > 1.0) {
            this.addMonoSample(this.sample);
            this.rateAccum -= 1.0;
        }
    }

    @Override
    public int readRegister(int type, int regNumber) {
        return 0;
    }

    @Override
    public void write(int addr, int data) {
        switch (FmReg.values()[addr]) {
            case ADDR_LATCH_REG: {
                Emu2413.OPLL_writeIO(this.opll, 0, data);
                break;
            }
            case DATA_REG: {
                Emu2413.OPLL_writeIO(this.opll, 1, data);
            }
        }
    }

    @Override
    public void init() {
        Emu2413.OPLL_init();
        this.opll = Emu2413.OPLL_new();
    }

    @Override
    protected void spinOnce() {
        this.sample = Emu2413.OPLL_calc(this.opll);
    }

    @Override
    public void onNewFrame() {
        super.onNewFrame();
        this.adjustedRatio = this.microsPerInputSample / this.fmCalcsPerMicros;
    }

    public static enum FmReg {
        ADDR_LATCH_REG,
        DATA_REG;

    }
}

