/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.sound.fm.ym2612;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import omegadrive.sound.fm.MdFmProvider;
import omegadrive.sound.fm.ym2612.Ym2612RegSupport;
import omegadrive.util.LogHelper;
import omegadrive.util.Util;
import org.slf4j.Logger;

public final class YM2612
extends Ym2612RegSupport
implements MdFmProvider {
    private static final Logger LOG = LogHelper.getLogger(YM2612.class.getSimpleName());
    static final int NULL_RATE_SIZE = 32;
    private static final boolean verbose = false;
    private static final int UPD_SIZE = 4000;
    private static final int OUTP_BITS = 16;
    private static final double PI = Math.PI;
    private static final int ATTACK = 0;
    private static final int DECAY = 1;
    private static final int SUSTAIN = 2;
    private static final int RELEASE = 3;
    private static final int SIN_HBITS = 12;
    private static final int SIN_LBITS = 14;
    private static final int ENV_HBITS = 12;
    private static final int ENV_LBITS = 16;
    private static final int LFO_HBITS = 10;
    private static final int LFO_LBITS = 18;
    private static final int SINLEN = 4096;
    private static final int ENVLEN = 4096;
    private static final int LFOLEN = 1024;
    private static final int TLLEN = 12288;
    private static final int SIN_MSK = 4095;
    private static final int ENV_MSK = 4095;
    private static final int LFO_MSK = 1023;
    private static final double ENV_STEP = 0.0234375;
    private static final int ENV_ATTACK = 0;
    private static final int ENV_DECAY = 0x10000000;
    private static final int ENV_END = 0x20000000;
    private static final int MAX_OUT_BITS = 28;
    private static final int MAX_OUT = 0xFFFFFFF;
    private static final int OUT_BITS = 14;
    private static final int FINAL_SHFT = 15;
    private static final int LIMIT_CH_OUT = 24575;
    private static final int PG_CUT_OFF = 3328;
    private static final int AR_RATE = 399128;
    private static final int DR_RATE = 5514396;
    private static final int LFO_FMS_LBITS = 9;
    private static final int LFO_FMS_BASE = 1;
    private static final int S0 = 0;
    private static final int S1 = 2;
    private static final int S2 = 1;
    private static final int S3 = 3;
    private static final int[] DT_DEF_TAB = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 6, 6, 7, 8, 8, 8, 8, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 11, 12, 13, 14, 16, 16, 16, 16, 2, 2, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 11, 12, 13, 14, 16, 17, 19, 20, 22, 22, 22, 22};
    private static final int[] FKEY_TAB = new int[]{0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 3, 3, 3, 3, 3, 3};
    private static final int[] LFO_AMS_TAB = new int[]{31, 4, 1, 0};
    private static final int[] LFO_FMS_TAB = new int[]{0, 1, 2, 3, 4, 6, 12, 24};
    private final int[] SIN_TAB = new int[4096];
    private final int[] TL_TAB = new int[24576];
    private final int[] ENV_TAB = new int[8200];
    private final int[] DECAY_TO_ATTACK = new int[4096];
    private final int[] FINC_TAB = new int[2048];
    static final int AR_NULL_RATE = 128;
    private final int[] AR_TAB = new int[160];
    static final int DR_NULL_RATE = 96;
    private final int[] DR_TAB = new int[128];
    private final int[][] DT_TAB = new int[8][32];
    private final int[] SL_TAB = new int[16];
    private final int[] LFO_ENV_TAB = new int[1024];
    private final int[] LFO_FREQ_TAB = new int[1024];
    private final int[] LFO_ENV_UP = new int[4000];
    private final int[] LFO_FREQ_UP = new int[4000];
    private final int[] LFO_INC_TAB = new int[8];
    private int in0;
    private int in1;
    private int in2;
    private int in3;
    private int en0;
    private int en1;
    private int en2;
    private int en3;
    private int int_cnt;
    private boolean EnableSSGEG = false;
    private static final int MAIN_SHIFT = 15;
    int YM2612_Clock;
    int YM2612_Rate;
    int YM2612_TimerBase;
    int YM2612_LFOcnt;
    int YM2612_LFOinc;
    int YM2612_TimerA;
    int YM2612_TimerAL;
    int YM2612_TimerAcnt;
    int YM2612_TimerB;
    int YM2612_TimerBL;
    int YM2612_TimerBcnt;
    static double YM2612_TimerA_factor = 18.77;
    static double YM2612_TimerB_factor = 300.34;
    int YM2612_DAC;
    double YM2612_Frequency;
    long YM2612_Inter_Cnt;
    long YM2612_Inter_Step;
    final cChannel[] YM2612_CHANNEL = new cChannel[6];
    volatile int YM2612_Mode;
    volatile int YM2612_Status;
    private Queue<Integer> dacQueue;
    private static int DAC_SILENCE = 128;
    private volatile int dacValue;
    private long lastEvent = 0L;
    static int BUSY_MICROS = 24;
    private static boolean isResetting;
    double microsAcc = 0.0;
    double pcmMicrosAcc = 0.0;
    long busyCyclesMicros = BUSY_MICROS;
    boolean initing = false;
    static double MICROS_PER_PCM;
    double microsPerTick;

    public YM2612(int clock, int sampleRateHz) {
        for (int i = 0; i < 6; ++i) {
            this.YM2612_CHANNEL[i] = new cChannel();
        }
        this.dacQueue = new ConcurrentLinkedQueue<Integer>();
        this.init(clock, sampleRateHz);
    }

    private static double log10(double x) {
        return Math.log(x) / Math.log(10.0);
    }

    @Override
    public final void reset() {
        int i;
        isResetting = true;
        this.YM2612_LFOcnt = 0;
        this.YM2612_TimerA = 0;
        this.YM2612_TimerAL = 1024;
        this.YM2612_TimerAcnt = 0;
        this.YM2612_TimerB = 0;
        this.YM2612_TimerBL = 256;
        this.YM2612_TimerBcnt = 0;
        this.YM2612_DAC = 0;
        this.YM2612_Status = 0;
        this.YM2612_Inter_Cnt = 0L;
        for (i = 0; i < 6; ++i) {
            this.YM2612_CHANNEL[i].Old_OUTd = 0;
            this.YM2612_CHANNEL[i].OUTd = 0;
            this.YM2612_CHANNEL[i].LEFT = -1;
            this.YM2612_CHANNEL[i].RIGHT = -1;
            this.YM2612_CHANNEL[i].ALGO = 0;
            this.YM2612_CHANNEL[i].FB = 31;
            this.YM2612_CHANNEL[i].FMS = 0;
            this.YM2612_CHANNEL[i].AMS = 0;
            for (int j = 0; j < 4; ++j) {
                this.YM2612_CHANNEL[i].S0_OUT[j] = 0;
                this.YM2612_CHANNEL[i].FNUM[j] = 0;
                this.YM2612_CHANNEL[i].FOCT[j] = 0;
                this.YM2612_CHANNEL[i].KC[j] = 0;
                this.YM2612_CHANNEL[i].SLOT[j].Fcnt = 0;
                this.YM2612_CHANNEL[i].SLOT[j].Finc = 0;
                this.YM2612_CHANNEL[i].SLOT[j].Ecnt = 0x20000000;
                this.YM2612_CHANNEL[i].SLOT[j].Einc = 0;
                this.YM2612_CHANNEL[i].SLOT[j].Ecmp = 0;
                this.YM2612_CHANNEL[i].SLOT[j].Ecurp = 3;
                this.YM2612_CHANNEL[i].SLOT[j].ChgEnM = 0;
            }
        }
        for (i = 0; i < 256; ++i) {
            this.ym2612Reg[0][i] = -1;
            this.ym2612Reg[1][i] = -1;
        }
        for (i = 182; i >= 180; --i) {
            this.writeReg(0, i, 192);
            this.writeReg(2, i, 192);
        }
        for (i = 178; i >= 34; --i) {
            this.writeReg(0, i, 0);
            this.writeReg(2, i, 0);
        }
        this.writeReg(0, 42, 128);
        this.dacQueue.clear();
        this.dacValue = DAC_SILENCE;
        isResetting = false;
    }

    private static void logWarn(String msg) {
        if (isResetting) {
            return;
        }
        LOG.warn(msg);
    }

    private void writeReg(int regPart, int regNumber, int data) {
        this.write(regPart, regNumber);
        this.write(regPart + 1, data);
    }

    @Override
    public final int read() {
        return this.YM2612_Status;
    }

    public final void init(int Clock, int Rate) {
        int j;
        double x;
        int i;
        this.initing = true;
        LOG.info("Init");
        if (Rate == 0 || Clock == 0) {
            return;
        }
        this.YM2612_Clock = Clock;
        this.YM2612_Rate = Rate;
        this.YM2612_Frequency = (double)this.YM2612_Clock / (double)this.YM2612_Rate / 144.0;
        this.YM2612_TimerBase = 1;
        this.YM2612_Inter_Step = 16384L;
        this.YM2612_Inter_Cnt = 0L;
        for (i = 0; i < 12288; ++i) {
            if (i >= 3328) {
                this.TL_TAB[i] = 0;
                this.TL_TAB[12288 + i] = 0;
                continue;
            }
            x = 2.68435455E8;
            this.TL_TAB[i] = (int)(x /= Math.pow(10.0, 0.0234375 * (double)i / 20.0));
            this.TL_TAB[12288 + i] = -this.TL_TAB[i];
        }
        this.SIN_TAB[0] = 3328;
        this.SIN_TAB[2048] = 3328;
        for (i = 1; i <= 1024; ++i) {
            x = Math.sin(Math.PI * 2 * (double)i / 4096.0);
            j = (int)((x = 20.0 * YM2612.log10(1.0 / x)) / 0.0234375);
            if (j > 3328) {
                j = 3328;
            }
            this.SIN_TAB[i] = j;
            this.SIN_TAB[2048 - i] = j;
            this.SIN_TAB[2048 + i] = 12288 + j;
            this.SIN_TAB[4096 - i] = 12288 + j;
        }
        for (i = 0; i < 1024; ++i) {
            x = Math.sin(Math.PI * 2 * (double)i / 1024.0);
            x += 1.0;
            x /= 2.0;
            this.LFO_ENV_TAB[i] = (int)(x *= 503.4666666666667);
            x = Math.sin(Math.PI * 2 * (double)i / 1024.0);
            this.LFO_FREQ_TAB[i] = (int)(x *= 511.0);
        }
        for (i = 0; i < 4096; ++i) {
            x = Math.pow((double)(4095 - i) / 4096.0, 8.0);
            this.ENV_TAB[i] = (int)(x *= 4096.0);
            x = Math.pow((double)i / 4096.0, 1.0);
            this.ENV_TAB[4096 + i] = (int)(x *= 4096.0);
        }
        this.ENV_TAB[8192] = 4095;
        j = 4095;
        for (i = 0; i < 4096; ++i) {
            while (j != 0 && this.ENV_TAB[j] < i) {
                --j;
            }
            this.DECAY_TO_ATTACK[i] = j << 16;
        }
        for (i = 0; i < 15; ++i) {
            x = i * 3;
            j = (int)(x /= 0.0234375);
            this.SL_TAB[i] = (j <<= 16) + 0x10000000;
        }
        j = 4095;
        this.SL_TAB[15] = (j <<= 16) + 0x10000000;
        for (i = 0; i < 2048; ++i) {
            x = (double)i * this.YM2612_Frequency;
            x *= 4096.0;
            this.FINC_TAB[i] = (int)(x /= 2.0);
        }
        for (i = 0; i < 4; ++i) {
            this.AR_TAB[i] = 0;
            this.DR_TAB[i] = 0;
        }
        for (i = 0; i < 60; ++i) {
            x = this.YM2612_Frequency;
            x *= 1.0 + (double)(i & 3) * 0.25;
            x *= (double)(1 << (i >> 2));
            this.AR_TAB[i + 4] = (int)((x *= 2.68435456E8) / 399128.0);
            this.DR_TAB[i + 4] = (int)(x / 5514396.0);
        }
        for (i = 64; i < 96; ++i) {
            this.AR_TAB[i] = this.AR_TAB[63];
            this.DR_TAB[i] = this.DR_TAB[63];
            this.AR_TAB[i - 64 + 128] = 0;
            this.DR_TAB[i - 64 + 96] = 0;
        }
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 32; ++j) {
                x = (double)DT_DEF_TAB[(i << 5) + j] * this.YM2612_Frequency * 32.0;
                this.DT_TAB[i + 0][j] = (int)x;
                this.DT_TAB[i + 4][j] = (int)(-x);
            }
        }
        j = (int)((long)this.YM2612_Rate * this.YM2612_Inter_Step / 16384L);
        this.LFO_INC_TAB[0] = (int)(1.06837311488E9 / (double)j);
        this.LFO_INC_TAB[1] = (int)(1.49250113536E9 / (double)j);
        this.LFO_INC_TAB[2] = (int)(1.61598144512E9 / (double)j);
        this.LFO_INC_TAB[3] = (int)(1.70993385472E9 / (double)j);
        this.LFO_INC_TAB[4] = (int)(1.84683593728E9 / (double)j);
        this.LFO_INC_TAB[5] = (int)(2.58503344128E9 / (double)j);
        this.LFO_INC_TAB[6] = (int)(1.29117454336E10 / (double)j);
        this.LFO_INC_TAB[7] = (int)(1.93810399232E10 / (double)j);
        this.reset();
        this.initing = false;
    }

    @Override
    public void setMicrosPerTick(double microsPerTick) {
        this.microsPerTick = microsPerTick;
    }

    @Override
    public void tick() {
        this.microsAcc += this.microsPerTick;
        this.pcmMicrosAcc += this.microsPerTick;
        if (this.microsAcc > 1.0) {
            this.synchronizeTimers((int)this.microsAcc);
            this.microsAcc -= (double)((int)this.microsAcc);
        }
        if (this.pcmMicrosAcc > MICROS_PER_PCM) {
            if (this.YM2612_DAC != 0) {
                this.dacQueue.offer(this.dacValue);
            }
            this.pcmMicrosAcc -= MICROS_PER_PCM;
        }
        this.busyCyclesMicros = (long)((double)this.busyCyclesMicros - this.microsPerTick);
        if (this.busyCyclesMicros <= 0L) {
            this.YM2612_Status &= 0xFFFFFF7F;
        }
    }

    private void logEvent(String str, int addr, int data) {
    }

    @Override
    protected void writeDataPort(int data) {
        int realAddrReg;
        int realAddr = this.addressLatch;
        int regPart = realAddr >= 256 ? 1 : 0;
        int n = realAddrReg = regPart > 0 ? realAddr - 256 : realAddr;
        if (realAddr < 48) {
            this.ym2612Reg[regPart][realAddrReg] = data;
            this.setYM(realAddrReg, data);
        } else {
            if (realAddrReg < 160) {
                this.setSlot(realAddr, data);
            } else {
                this.setChannel(realAddr, data);
            }
            this.setBusyFlag();
        }
    }

    private void setBusyFlag() {
        this.YM2612_Status |= 0x80;
        this.busyCyclesMicros = BUSY_MICROS;
    }

    @Override
    public int updateStereo16(int[] buf_lr, int offset, int count) {
        boolean dacSampleToProcess;
        int end = count * 2 + (offset *= 2);
        this.logEvent("update", offset, end);
        if (this.YM2612_CHANNEL[0].SLOT[0].Finc == -1) {
            this.calc_FINC_CH(this.YM2612_CHANNEL[0]);
        }
        if (this.YM2612_CHANNEL[1].SLOT[0].Finc == -1) {
            this.calc_FINC_CH(this.YM2612_CHANNEL[1]);
        }
        if (this.YM2612_CHANNEL[2].SLOT[0].Finc == -1) {
            if ((this.YM2612_Mode & 0x40) != 0) {
                this.calc_FINC_SL(this.YM2612_CHANNEL[2].SLOT[0], this.FINC_TAB[this.YM2612_CHANNEL[2].FNUM[2]] >> 7 - this.YM2612_CHANNEL[2].FOCT[2], this.YM2612_CHANNEL[2].KC[2]);
                this.calc_FINC_SL(this.YM2612_CHANNEL[2].SLOT[2], this.FINC_TAB[this.YM2612_CHANNEL[2].FNUM[3]] >> 7 - this.YM2612_CHANNEL[2].FOCT[3], this.YM2612_CHANNEL[2].KC[3]);
                this.calc_FINC_SL(this.YM2612_CHANNEL[2].SLOT[1], this.FINC_TAB[this.YM2612_CHANNEL[2].FNUM[1]] >> 7 - this.YM2612_CHANNEL[2].FOCT[1], this.YM2612_CHANNEL[2].KC[1]);
                this.calc_FINC_SL(this.YM2612_CHANNEL[2].SLOT[3], this.FINC_TAB[this.YM2612_CHANNEL[2].FNUM[0]] >> 7 - this.YM2612_CHANNEL[2].FOCT[0], this.YM2612_CHANNEL[2].KC[0]);
            } else {
                this.calc_FINC_CH(this.YM2612_CHANNEL[2]);
            }
        }
        if (this.YM2612_CHANNEL[3].SLOT[0].Finc == -1) {
            this.calc_FINC_CH(this.YM2612_CHANNEL[3]);
        }
        if (this.YM2612_CHANNEL[4].SLOT[0].Finc == -1) {
            this.calc_FINC_CH(this.YM2612_CHANNEL[4]);
        }
        if (this.YM2612_CHANNEL[5].SLOT[0].Finc == -1) {
            this.calc_FINC_CH(this.YM2612_CHANNEL[5]);
        }
        int algo_type = 0;
        if (this.YM2612_LFOinc != 0) {
            for (int o = offset; o < end; o += 2) {
                int i = o >> 1;
                int j = (this.YM2612_LFOcnt += this.YM2612_LFOinc) >> 18 & 0x3FF;
                this.LFO_ENV_UP[i] = this.LFO_ENV_TAB[j];
                this.LFO_FREQ_UP[i] = this.LFO_FREQ_TAB[j];
            }
            algo_type |= 8;
        }
        this.updateChannel(this.YM2612_CHANNEL[0].ALGO + algo_type, this.YM2612_CHANNEL[0], buf_lr, offset, end);
        this.updateChannel(this.YM2612_CHANNEL[1].ALGO + algo_type, this.YM2612_CHANNEL[1], buf_lr, offset, end);
        this.updateChannel(this.YM2612_CHANNEL[2].ALGO + algo_type, this.YM2612_CHANNEL[2], buf_lr, offset, end);
        this.updateChannel(this.YM2612_CHANNEL[3].ALGO + algo_type, this.YM2612_CHANNEL[3], buf_lr, offset, end);
        this.updateChannel(this.YM2612_CHANNEL[4].ALGO + algo_type, this.YM2612_CHANNEL[4], buf_lr, offset, end);
        boolean bl = dacSampleToProcess = this.dacQueue.peek() != null;
        if (this.YM2612_DAC == 0 && !dacSampleToProcess) {
            this.updateChannel(this.YM2612_CHANNEL[5].ALGO + algo_type, this.YM2612_CHANNEL[5], buf_lr, offset, end);
            this.drainDacQueue();
        } else {
            this.updateDac(buf_lr, offset, end, dacSampleToProcess);
        }
        this.YM2612_Inter_Cnt = this.int_cnt;
        return count << 1;
    }

    private void updateDac(int[] buf_lr, int offset, int end, boolean dacSampleToProcess) {
        int i = offset;
        if (dacSampleToProcess) {
            Integer val;
            while ((val = this.dacQueue.poll()) != null && i < end) {
                if (val == DAC_SILENCE) {
                    i += 2;
                    continue;
                }
                int dacValue = val - DAC_SILENCE << 4;
                int n = i;
                buf_lr[n] = buf_lr[n] + dacValue;
                int n2 = i + 1;
                buf_lr[n2] = buf_lr[n2] + dacValue;
                i += 2;
            }
        } else {
            this.drainDacQueue();
        }
    }

    private void drainDacQueue() {
        this.dacQueue.clear();
    }

    private void setTimers(int data) {
        boolean wasLoadB;
        boolean loadA = (data & 1) > 0;
        boolean loadB = (data & 2) > 0;
        boolean resetA = (data & 0x10) > 0;
        boolean resetB = (data & 0x20) > 0;
        boolean wasLoadA = (this.YM2612_Mode & 1) > 0;
        boolean bl = wasLoadB = (this.YM2612_Mode & 2) > 0;
        if (!wasLoadA && loadA) {
            this.YM2612_TimerAcnt = this.YM2612_TimerAL;
        }
        if (!wasLoadB && loadB) {
            this.YM2612_TimerBcnt = this.YM2612_TimerBL;
        }
        this.YM2612_Status &= resetA ? -2 : 255;
        this.YM2612_Status &= resetB ? -3 : 255;
        this.logTimersChange(data);
    }

    private void logTimersChange(int data) {
    }

    private final void synchronizeTimers(int length) {
        if (length <= 0) {
            return;
        }
        int i = this.YM2612_TimerBase * length;
        if ((this.YM2612_Mode & 1) != 0) {
            this.YM2612_TimerAcnt -= i;
            if (this.YM2612_TimerAcnt <= 0) {
                long val = this.YM2612_TimerAcnt;
                this.YM2612_Status |= (this.YM2612_Mode & 4) > 0 ? 1 : 0;
                do {
                    this.YM2612_TimerAcnt += this.YM2612_TimerAL;
                } while (this.YM2612_TimerAcnt < 0);
                if ((this.YM2612_Mode & 0x80) != 0) {
                    this.CSM_Key_Control();
                }
            }
        }
        if ((this.YM2612_Mode & 2) > 0) {
            this.YM2612_TimerBcnt -= i;
            if (this.YM2612_TimerBcnt <= 0) {
                int val = this.YM2612_TimerBcnt;
                this.YM2612_Status |= (this.YM2612_Mode & 8) > 0 ? 2 : 0;
                do {
                    this.YM2612_TimerBcnt += this.YM2612_TimerBL;
                } while (this.YM2612_TimerBcnt < 0);
            }
        }
    }

    private final void calc_FINC_SL(cSlot SL, int finc, int kc) {
        SL.Finc = (finc + SL.DT[kc]) * SL.MUL;
        int ksr = kc >> SL.KSR_S;
        if (SL.KSR != ksr) {
            SL.KSR = ksr;
            SL.EincA = this.AR_TAB[SL.AR + ksr];
            SL.EincD = this.DR_TAB[SL.DR + ksr];
            SL.EincS = this.DR_TAB[SL.SR + ksr];
            SL.EincR = this.DR_TAB[SL.RR + ksr];
            if (SL.Ecurp == 0) {
                SL.Einc = SL.EincA;
            } else if (SL.Ecurp == 1) {
                SL.Einc = SL.EincD;
            } else if (SL.Ecnt < 0x20000000) {
                if (SL.Ecurp == 2) {
                    SL.Einc = SL.EincS;
                } else if (SL.Ecurp == 3) {
                    SL.Einc = SL.EincR;
                }
            }
        }
    }

    private final void calc_FINC_CH(cChannel CH) {
        int finc = this.FINC_TAB[CH.FNUM[0]] >> 7 - CH.FOCT[0];
        int kc = CH.KC[0];
        this.calc_FINC_SL(CH.SLOT[0], finc, kc);
        this.calc_FINC_SL(CH.SLOT[1], finc, kc);
        this.calc_FINC_SL(CH.SLOT[2], finc, kc);
        this.calc_FINC_SL(CH.SLOT[3], finc, kc);
    }

    private final void KEY_ON(cChannel CH, int nsl) {
        cSlot SL = CH.SLOT[nsl];
        if (SL.Ecurp == 3) {
            SL.Fcnt = 0;
            try {
                SL.Ecnt = this.DECAY_TO_ATTACK[this.ENV_TAB[SL.Ecnt >> 16]] + 0 & SL.ChgEnM;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                LOG.error("KEY_ON error", (Throwable)e);
            }
            SL.ChgEnM = -1;
            SL.Einc = SL.EincA;
            SL.Ecmp = 0x10000000;
            SL.Ecurp = 0;
        }
    }

    private final void KEY_OFF(cChannel CH, int nsl) {
        cSlot SL = CH.SLOT[nsl];
        if (SL.Ecurp != 3) {
            if (SL.Ecnt < 0x10000000) {
                SL.Ecnt = (this.ENV_TAB[SL.Ecnt >> 16] << 16) + 0x10000000;
            }
            SL.Einc = SL.EincR;
            SL.Ecmp = 0x20000000;
            SL.Ecurp = 3;
        }
    }

    private final void CSM_Key_Control() {
        this.KEY_ON(this.YM2612_CHANNEL[2], 0);
        this.KEY_ON(this.YM2612_CHANNEL[2], 1);
        this.KEY_ON(this.YM2612_CHANNEL[2], 2);
        this.KEY_ON(this.YM2612_CHANNEL[2], 3);
    }

    private final int setSlot(int address, int data) {
        data &= 0xFF;
        int nch = address & 3;
        if (nch == 3) {
            return 1;
        }
        int nsl = address >> 2 & 3;
        if ((address & 0x100) != 0) {
            nch += 3;
        }
        cChannel CH = this.YM2612_CHANNEL[nch];
        cSlot SL = CH.SLOT[nsl];
        switch (address & 0xF0) {
            case 48: {
                SL.MUL = data & 0xF;
                SL.MUL = SL.MUL != 0 ? (SL.MUL <<= 1) : 1;
                SL.DT = this.DT_TAB[data >> 4 & 7];
                CH.SLOT[0].Finc = -1;
                break;
            }
            case 64: {
                SL.TL = data & 0x7F;
                SL.TLL = SL.TL << 5;
                break;
            }
            case 80: {
                SL.KSR_S = 3 - (data >> 6);
                CH.SLOT[0].Finc = -1;
                SL.AR = (data &= 0x1F) != 0 ? data << 1 : 128;
                SL.EincA = this.AR_TAB[SL.AR + SL.KSR];
                if (SL.Ecurp != 0) break;
                SL.Einc = SL.EincA;
                break;
            }
            case 96: {
                SL.AMSon = data & 0x80;
                SL.AMS = SL.AMSon != 0 ? CH.AMS : 31;
                SL.DR = (data &= 0x1F) != 0 ? data << 1 : 96;
                SL.EincD = this.DR_TAB[SL.DR + SL.KSR];
                if (SL.Ecurp != 1) break;
                SL.Einc = SL.EincD;
                break;
            }
            case 112: {
                SL.SR = (data &= 0x1F) != 0 ? data << 1 : 96;
                SL.EincS = this.DR_TAB[SL.SR + SL.KSR];
                if (SL.Ecurp != 2 || SL.Ecnt >= 0x20000000) break;
                SL.Einc = SL.EincS;
                break;
            }
            case 128: {
                SL.SLL = this.SL_TAB[data >> 4];
                SL.RR = ((data & 0xF) << 2) + 2;
                SL.EincR = this.DR_TAB[SL.RR + SL.KSR];
                if (SL.Ecurp != 3 || SL.Ecnt >= 0x20000000) break;
                SL.Einc = SL.EincR;
                break;
            }
            case 144: {
                if (!this.EnableSSGEG) break;
                if ((data & 8) != 0) {
                    SL.SEG = data & 0xF;
                    break;
                }
                SL.SEG = 0;
                break;
            }
            default: {
                if (isResetting) break;
                LOG.warn("Invalid write to addr: {}, data: {}", (Object)Util.th(address), (Object)Util.th(data));
            }
        }
        return 0;
    }

    private final int setChannel(int address, int data) {
        data &= 0xFF;
        int num = address & 3;
        if (num == 3) {
            return 1;
        }
        switch (address & 0xFC) {
            case 160: {
                if ((address & 0x100) != 0) {
                    num += 3;
                }
                cChannel CH = this.YM2612_CHANNEL[num];
                CH.FNUM[0] = (CH.FNUM[0] & 0x700) + data;
                CH.KC[0] = CH.FOCT[0] << 2 | FKEY_TAB[CH.FNUM[0] >> 7];
                CH.SLOT[0].Finc = -1;
                break;
            }
            case 164: {
                if ((address & 0x100) != 0) {
                    num += 3;
                }
                cChannel CH = this.YM2612_CHANNEL[num];
                CH.FNUM[0] = (CH.FNUM[0] & 0xFF) + ((data & 7) << 8);
                CH.FOCT[0] = (data & 0x38) >> 3;
                CH.KC[0] = CH.FOCT[0] << 2 | FKEY_TAB[CH.FNUM[0] >> 7];
                CH.SLOT[0].Finc = -1;
                break;
            }
            case 168: {
                if (address >= 256) break;
                this.YM2612_CHANNEL[2].FNUM[++num] = (this.YM2612_CHANNEL[2].FNUM[num] & 0x700) + data;
                this.YM2612_CHANNEL[2].KC[num] = this.YM2612_CHANNEL[2].FOCT[num] << 2 | FKEY_TAB[this.YM2612_CHANNEL[2].FNUM[num] >> 7];
                this.YM2612_CHANNEL[2].SLOT[0].Finc = -1;
                break;
            }
            case 172: {
                if (address >= 256) break;
                this.YM2612_CHANNEL[2].FNUM[++num] = (this.YM2612_CHANNEL[2].FNUM[num] & 0xFF) + ((data & 7) << 8);
                this.YM2612_CHANNEL[2].FOCT[num] = (data & 0x38) >> 3;
                this.YM2612_CHANNEL[2].KC[num] = this.YM2612_CHANNEL[2].FOCT[num] << 2 | FKEY_TAB[this.YM2612_CHANNEL[2].FNUM[num] >> 7];
                this.YM2612_CHANNEL[2].SLOT[0].Finc = -1;
                break;
            }
            case 176: {
                if ((address & 0x100) != 0) {
                    num += 3;
                }
                cChannel CH = this.YM2612_CHANNEL[num];
                if (CH.ALGO != (data & 7)) {
                    CH.ALGO = data & 7;
                    CH.SLOT[0].ChgEnM = 0;
                    CH.SLOT[1].ChgEnM = 0;
                    CH.SLOT[2].ChgEnM = 0;
                    CH.SLOT[3].ChgEnM = 0;
                }
                CH.FB = 9 - (data >> 3 & 7);
                break;
            }
            case 180: {
                if ((address & 0x100) != 0) {
                    num += 3;
                }
                cChannel CH = this.YM2612_CHANNEL[num];
                CH.LEFT = (data & 0x80) != 0 ? -1 : 0;
                CH.RIGHT = (data & 0x40) != 0 ? -1 : 0;
                CH.AMS = LFO_AMS_TAB[data >> 4 & 3];
                CH.FMS = LFO_FMS_TAB[data & 7];
                CH.SLOT[0].AMS = CH.SLOT[0].AMSon != 0 ? CH.AMS : 31;
                CH.SLOT[1].AMS = CH.SLOT[1].AMSon != 0 ? CH.AMS : 31;
                CH.SLOT[2].AMS = CH.SLOT[2].AMSon != 0 ? CH.AMS : 31;
                if (CH.SLOT[3].AMSon != 0) {
                    CH.SLOT[3].AMS = CH.AMS;
                    break;
                }
                CH.SLOT[3].AMS = 31;
                break;
            }
            default: {
                if (isResetting) break;
                LOG.warn("Invalid write to addr: {}, data: {}", (Object)Util.th(address), (Object)Util.th(data));
            }
        }
        return 0;
    }

    private int getTimerACount(int YM2612_TimerA) {
        return (int)(YM2612_TimerA_factor * (double)(1024 - YM2612_TimerA));
    }

    private int getTimerBCount(int YM2612_TimerB) {
        return (int)(YM2612_TimerB_factor * (double)(256 - YM2612_TimerB));
    }

    private final int setYM(int address, int data) {
        boolean count = false;
        switch (address) {
            case 33: {
                YM2612.logWarn("Test register write: " + data);
                break;
            }
            case 34: {
                if ((data & 8) != 0) {
                    this.YM2612_LFOinc = this.LFO_INC_TAB[data & 7];
                    break;
                }
                this.YM2612_LFOcnt = 0;
                this.YM2612_LFOinc = 0;
                break;
            }
            case 36: {
                this.YM2612_TimerA = data << 2 & 0x3FC | this.YM2612_TimerA & 3;
                this.YM2612_TimerAL = this.getTimerACount(this.YM2612_TimerA);
                break;
            }
            case 37: {
                this.YM2612_TimerA = this.YM2612_TimerA & 0x3FC | data & 3;
                this.YM2612_TimerAL = this.getTimerACount(this.YM2612_TimerA);
                break;
            }
            case 38: {
                this.YM2612_TimerB = data;
                this.YM2612_TimerBL = this.getTimerBCount(this.YM2612_TimerB);
                break;
            }
            case 39: {
                if (((data ^ this.YM2612_Mode) & 0x40) != 0) {
                    this.YM2612_CHANNEL[2].SLOT[0].Finc = -1;
                }
                this.setTimers(data);
                this.YM2612_Mode = data;
                break;
            }
            case 40: {
                int nch = data & 3;
                if (nch == 3) {
                    return 1;
                }
                if ((data & 4) != 0) {
                    nch += 3;
                }
                cChannel CH = this.YM2612_CHANNEL[nch];
                if ((data & 0x10) != 0) {
                    this.KEY_ON(CH, 0);
                } else {
                    this.KEY_OFF(CH, 0);
                }
                if ((data & 0x20) != 0) {
                    this.KEY_ON(CH, 2);
                } else {
                    this.KEY_OFF(CH, 2);
                }
                if ((data & 0x40) != 0) {
                    this.KEY_ON(CH, 1);
                } else {
                    this.KEY_OFF(CH, 1);
                }
                if ((data & 0x80) != 0) {
                    this.KEY_ON(CH, 3);
                    break;
                }
                this.KEY_OFF(CH, 3);
                break;
            }
            case 42: {
                this.dacValue = data;
                break;
            }
            case 43: {
                int flag;
                this.YM2612_DAC = flag = data & 0x80;
                break;
            }
            default: {
                if (isResetting) break;
                LOG.warn("Unexpected write to addr: {}, data: {}", (Object)Util.th(address), (Object)Util.th(data));
            }
        }
        return 0;
    }

    private final void Env_NULL_Next(cSlot SL) {
    }

    private final void Env_Attack_Next(cSlot SL) {
        SL.Ecnt = 0x10000000;
        SL.Einc = SL.EincD;
        SL.Ecmp = SL.SLL;
        SL.Ecurp = 1;
    }

    private final void Env_Decay_Next(cSlot SL) {
        SL.Ecnt = SL.SLL;
        SL.Einc = SL.EincS;
        SL.Ecmp = 0x20000000;
        SL.Ecurp = 2;
    }

    private final void Env_Sustain_Next(cSlot SL) {
        if (this.EnableSSGEG) {
            if ((SL.SEG & 8) != 0) {
                if ((SL.SEG & 1) != 0) {
                    SL.Ecnt = 0x20000000;
                    SL.Einc = 0;
                    SL.Ecmp = 0x20000001;
                } else {
                    SL.Ecnt = 0;
                    SL.Einc = SL.EincA;
                    SL.Ecmp = 0x10000000;
                    SL.Ecurp = 0;
                }
                SL.SEG ^= (SL.SEG & 2) << 1;
            } else {
                SL.Ecnt = 0x20000000;
                SL.Einc = 0;
                SL.Ecmp = 0x20000001;
            }
        } else {
            SL.Ecnt = 0x20000000;
            SL.Einc = 0;
            SL.Ecmp = 0x20000001;
        }
    }

    private final void Env_Release_Next(cSlot SL) {
        SL.Ecnt = 0x20000000;
        SL.Einc = 0;
        SL.Ecmp = 0x20000001;
    }

    private final void ENV_NEXT_EVENT(int which, cSlot SL) {
        switch (which) {
            case 0: {
                this.Env_Attack_Next(SL);
                return;
            }
            case 1: {
                this.Env_Decay_Next(SL);
                return;
            }
            case 2: {
                this.Env_Sustain_Next(SL);
                return;
            }
            case 3: {
                this.Env_Release_Next(SL);
                return;
            }
        }
    }

    private final void calcChannel(int ALGO, cChannel CH) {
        this.in0 += CH.S0_OUT[0] + CH.S0_OUT[1] >> CH.FB;
        CH.S0_OUT[1] = CH.S0_OUT[0];
        CH.S0_OUT[0] = this.TL_TAB[this.SIN_TAB[this.in0 >> 14 & 0xFFF] + this.en0];
        switch (ALGO) {
            case 0: {
                this.in1 += CH.S0_OUT[1];
                this.in2 += this.TL_TAB[this.SIN_TAB[this.in1 >> 14 & 0xFFF] + this.en1];
                this.in3 += this.TL_TAB[this.SIN_TAB[this.in2 >> 14 & 0xFFF] + this.en2];
                CH.OUTd = this.TL_TAB[this.SIN_TAB[this.in3 >> 14 & 0xFFF] + this.en3] >> 15;
                break;
            }
            case 1: {
                this.in2 += CH.S0_OUT[1] + this.TL_TAB[this.SIN_TAB[this.in1 >> 14 & 0xFFF] + this.en1];
                this.in3 += this.TL_TAB[this.SIN_TAB[this.in2 >> 14 & 0xFFF] + this.en2];
                CH.OUTd = this.TL_TAB[this.SIN_TAB[this.in3 >> 14 & 0xFFF] + this.en3] >> 15;
                break;
            }
            case 2: {
                this.in2 += this.TL_TAB[this.SIN_TAB[this.in1 >> 14 & 0xFFF] + this.en1];
                this.in3 += CH.S0_OUT[1] + this.TL_TAB[this.SIN_TAB[this.in2 >> 14 & 0xFFF] + this.en2];
                CH.OUTd = this.TL_TAB[this.SIN_TAB[this.in3 >> 14 & 0xFFF] + this.en3] >> 15;
                break;
            }
            case 3: {
                this.in1 += CH.S0_OUT[1];
                this.in3 += this.TL_TAB[this.SIN_TAB[this.in1 >> 14 & 0xFFF] + this.en1] + this.TL_TAB[this.SIN_TAB[this.in2 >> 14 & 0xFFF] + this.en2];
                CH.OUTd = this.TL_TAB[this.SIN_TAB[this.in3 >> 14 & 0xFFF] + this.en3] >> 15;
                break;
            }
            case 4: {
                this.in1 += CH.S0_OUT[1];
                this.in3 += this.TL_TAB[this.SIN_TAB[this.in2 >> 14 & 0xFFF] + this.en2];
                CH.OUTd = this.TL_TAB[this.SIN_TAB[this.in3 >> 14 & 0xFFF] + this.en3] + this.TL_TAB[this.SIN_TAB[this.in1 >> 14 & 0xFFF] + this.en1] >> 15;
                break;
            }
            case 5: {
                this.in1 += CH.S0_OUT[1];
                this.in2 += CH.S0_OUT[1];
                this.in3 += CH.S0_OUT[1];
                CH.OUTd = this.TL_TAB[this.SIN_TAB[this.in3 >> 14 & 0xFFF] + this.en3] + this.TL_TAB[this.SIN_TAB[this.in1 >> 14 & 0xFFF] + this.en1] + this.TL_TAB[this.SIN_TAB[this.in2 >> 14 & 0xFFF] + this.en2] >> 15;
                break;
            }
            case 6: {
                this.in1 += CH.S0_OUT[1];
                CH.OUTd = this.TL_TAB[this.SIN_TAB[this.in3 >> 14 & 0xFFF] + this.en3] + this.TL_TAB[this.SIN_TAB[this.in1 >> 14 & 0xFFF] + this.en1] + this.TL_TAB[this.SIN_TAB[this.in2 >> 14 & 0xFFF] + this.en2] >> 15;
                break;
            }
            case 7: {
                CH.OUTd = this.TL_TAB[this.SIN_TAB[this.in3 >> 14 & 0xFFF] + this.en3] + this.TL_TAB[this.SIN_TAB[this.in1 >> 14 & 0xFFF] + this.en1] + this.TL_TAB[this.SIN_TAB[this.in2 >> 14 & 0xFFF] + this.en2] + CH.S0_OUT[1] >> 15;
            }
        }
        if (CH.OUTd > 24575) {
            CH.OUTd = 24575;
        } else if (CH.OUTd < -24575) {
            CH.OUTd = -24575;
        }
    }

    private final void processChannel(cChannel CH, int[] buf_lr, int OFFSET, int END, int ALGO) {
        if (ALGO < 4 ? CH.SLOT[3].Ecnt == 0x20000000 : (ALGO == 4 ? CH.SLOT[2].Ecnt == 0x20000000 && CH.SLOT[3].Ecnt == 0x20000000 : (ALGO < 7 ? CH.SLOT[2].Ecnt == 0x20000000 && CH.SLOT[1].Ecnt == 0x20000000 && CH.SLOT[3].Ecnt == 0x20000000 : CH.SLOT[0].Ecnt == 0x20000000 && CH.SLOT[2].Ecnt == 0x20000000 && CH.SLOT[1].Ecnt == 0x20000000 && CH.SLOT[3].Ecnt == 0x20000000))) {
            return;
        }
        do {
            this.in0 = CH.SLOT[0].Fcnt;
            this.in1 = CH.SLOT[2].Fcnt;
            this.in2 = CH.SLOT[1].Fcnt;
            this.in3 = CH.SLOT[3].Fcnt;
            CH.SLOT[0].Fcnt += CH.SLOT[0].Finc;
            CH.SLOT[2].Fcnt += CH.SLOT[2].Finc;
            CH.SLOT[1].Fcnt += CH.SLOT[1].Finc;
            CH.SLOT[3].Fcnt += CH.SLOT[3].Finc;
            this.en0 = (CH.SLOT[0].SEG & 4) != 0 ? ((this.en0 = this.ENV_TAB[CH.SLOT[0].Ecnt >> 16] + CH.SLOT[0].TLL) > 4095 ? 0 : (this.en0 ^= 0xFFF)) : this.ENV_TAB[CH.SLOT[0].Ecnt >> 16] + CH.SLOT[0].TLL;
            this.en1 = (CH.SLOT[2].SEG & 4) != 0 ? ((this.en1 = this.ENV_TAB[CH.SLOT[2].Ecnt >> 16] + CH.SLOT[2].TLL) > 4095 ? 0 : (this.en1 ^= 0xFFF)) : this.ENV_TAB[CH.SLOT[2].Ecnt >> 16] + CH.SLOT[2].TLL;
            this.en2 = (CH.SLOT[1].SEG & 4) != 0 ? ((this.en2 = this.ENV_TAB[CH.SLOT[1].Ecnt >> 16] + CH.SLOT[1].TLL) > 4095 ? 0 : (this.en2 ^= 0xFFF)) : this.ENV_TAB[CH.SLOT[1].Ecnt >> 16] + CH.SLOT[1].TLL;
            this.en3 = (CH.SLOT[3].SEG & 4) != 0 ? ((this.en3 = this.ENV_TAB[CH.SLOT[3].Ecnt >> 16] + CH.SLOT[3].TLL) > 4095 ? 0 : (this.en3 ^= 0xFFF)) : this.ENV_TAB[CH.SLOT[3].Ecnt >> 16] + CH.SLOT[3].TLL;
            if ((CH.SLOT[0].Ecnt += CH.SLOT[0].Einc) >= CH.SLOT[0].Ecmp) {
                this.ENV_NEXT_EVENT(CH.SLOT[0].Ecurp, CH.SLOT[0]);
            }
            if ((CH.SLOT[2].Ecnt += CH.SLOT[2].Einc) >= CH.SLOT[2].Ecmp) {
                this.ENV_NEXT_EVENT(CH.SLOT[2].Ecurp, CH.SLOT[2]);
            }
            if ((CH.SLOT[1].Ecnt += CH.SLOT[1].Einc) >= CH.SLOT[1].Ecmp) {
                this.ENV_NEXT_EVENT(CH.SLOT[1].Ecurp, CH.SLOT[1]);
            }
            if ((CH.SLOT[3].Ecnt += CH.SLOT[3].Einc) >= CH.SLOT[3].Ecmp) {
                this.ENV_NEXT_EVENT(CH.SLOT[3].Ecurp, CH.SLOT[3]);
            }
            this.calcChannel(ALGO, CH);
            int n = OFFSET;
            buf_lr[n] = buf_lr[n] + (CH.OUTd & CH.LEFT);
            int n2 = OFFSET + 1;
            buf_lr[n2] = buf_lr[n2] + (CH.OUTd & CH.RIGHT);
        } while ((OFFSET += 2) < END);
    }

    private final void processChannel_LFO(cChannel CH, int[] buf_lr, int OFFSET, int END, int ALGO) {
        if (ALGO < 4 ? CH.SLOT[3].Ecnt == 0x20000000 : (ALGO == 4 ? CH.SLOT[2].Ecnt == 0x20000000 && CH.SLOT[3].Ecnt == 0x20000000 : (ALGO < 7 ? CH.SLOT[2].Ecnt == 0x20000000 && CH.SLOT[1].Ecnt == 0x20000000 && CH.SLOT[3].Ecnt == 0x20000000 : CH.SLOT[0].Ecnt == 0x20000000 && CH.SLOT[2].Ecnt == 0x20000000 && CH.SLOT[1].Ecnt == 0x20000000 && CH.SLOT[3].Ecnt == 0x20000000))) {
            return;
        }
        do {
            int i = OFFSET >> 1;
            this.in0 = CH.SLOT[0].Fcnt;
            this.in1 = CH.SLOT[2].Fcnt;
            this.in2 = CH.SLOT[1].Fcnt;
            this.in3 = CH.SLOT[3].Fcnt;
            int freq_LFO = CH.FMS * this.LFO_FREQ_UP[i] >> 9;
            if (freq_LFO != 0) {
                CH.SLOT[0].Fcnt += CH.SLOT[0].Finc + (CH.SLOT[0].Finc * freq_LFO >> 9);
                CH.SLOT[2].Fcnt += CH.SLOT[2].Finc + (CH.SLOT[2].Finc * freq_LFO >> 9);
                CH.SLOT[1].Fcnt += CH.SLOT[1].Finc + (CH.SLOT[1].Finc * freq_LFO >> 9);
                CH.SLOT[3].Fcnt += CH.SLOT[3].Finc + (CH.SLOT[3].Finc * freq_LFO >> 9);
            } else {
                CH.SLOT[0].Fcnt += CH.SLOT[0].Finc;
                CH.SLOT[2].Fcnt += CH.SLOT[2].Finc;
                CH.SLOT[1].Fcnt += CH.SLOT[1].Finc;
                CH.SLOT[3].Fcnt += CH.SLOT[3].Finc;
            }
            int env_LFO = this.LFO_ENV_UP[i];
            this.en0 = (CH.SLOT[0].SEG & 4) != 0 ? ((this.en0 = this.ENV_TAB[CH.SLOT[0].Ecnt >> 16] + CH.SLOT[0].TLL) > 4095 ? 0 : (this.en0 ^ 0xFFF) + (env_LFO >> CH.SLOT[0].AMS)) : this.ENV_TAB[CH.SLOT[0].Ecnt >> 16] + CH.SLOT[0].TLL + (env_LFO >> CH.SLOT[0].AMS);
            this.en1 = (CH.SLOT[2].SEG & 4) != 0 ? ((this.en1 = this.ENV_TAB[CH.SLOT[2].Ecnt >> 16] + CH.SLOT[2].TLL) > 4095 ? 0 : (this.en1 ^ 0xFFF) + (env_LFO >> CH.SLOT[2].AMS)) : this.ENV_TAB[CH.SLOT[2].Ecnt >> 16] + CH.SLOT[2].TLL + (env_LFO >> CH.SLOT[2].AMS);
            this.en2 = (CH.SLOT[1].SEG & 4) != 0 ? ((this.en2 = this.ENV_TAB[CH.SLOT[1].Ecnt >> 16] + CH.SLOT[1].TLL) > 4095 ? 0 : (this.en2 ^ 0xFFF) + (env_LFO >> CH.SLOT[1].AMS)) : this.ENV_TAB[CH.SLOT[1].Ecnt >> 16] + CH.SLOT[1].TLL + (env_LFO >> CH.SLOT[1].AMS);
            this.en3 = (CH.SLOT[3].SEG & 4) != 0 ? ((this.en3 = this.ENV_TAB[CH.SLOT[3].Ecnt >> 16] + CH.SLOT[3].TLL) > 4095 ? 0 : (this.en3 ^ 0xFFF) + (env_LFO >> CH.SLOT[3].AMS)) : this.ENV_TAB[CH.SLOT[3].Ecnt >> 16] + CH.SLOT[3].TLL + (env_LFO >> CH.SLOT[3].AMS);
            if ((CH.SLOT[0].Ecnt += CH.SLOT[0].Einc) >= CH.SLOT[0].Ecmp) {
                this.ENV_NEXT_EVENT(CH.SLOT[0].Ecurp, CH.SLOT[0]);
            }
            if ((CH.SLOT[2].Ecnt += CH.SLOT[2].Einc) >= CH.SLOT[2].Ecmp) {
                this.ENV_NEXT_EVENT(CH.SLOT[2].Ecurp, CH.SLOT[2]);
            }
            if ((CH.SLOT[1].Ecnt += CH.SLOT[1].Einc) >= CH.SLOT[1].Ecmp) {
                this.ENV_NEXT_EVENT(CH.SLOT[1].Ecurp, CH.SLOT[1]);
            }
            if ((CH.SLOT[3].Ecnt += CH.SLOT[3].Einc) >= CH.SLOT[3].Ecmp) {
                this.ENV_NEXT_EVENT(CH.SLOT[3].Ecurp, CH.SLOT[3]);
            }
            this.calcChannel(ALGO, CH);
            int left = CH.OUTd & CH.LEFT;
            int right = CH.OUTd & CH.RIGHT;
            int n = OFFSET;
            buf_lr[n] = buf_lr[n] + left;
            int n2 = OFFSET + 1;
            buf_lr[n2] = buf_lr[n2] + right;
        } while ((OFFSET += 2) < END);
    }

    private final void updateChannel(int ALGO, cChannel CH, int[] buf_lr, int OFFSET, int END) {
        if (ALGO < 8) {
            this.processChannel(CH, buf_lr, OFFSET, END, ALGO);
        } else {
            this.processChannel_LFO(CH, buf_lr, OFFSET, END, ALGO - 8);
        }
    }

    static {
        MICROS_PER_PCM = 25.0;
    }

    private final class cChannel {
        final int[] S0_OUT = new int[4];
        int Old_OUTd;
        int OUTd;
        int LEFT;
        int RIGHT;
        int ALGO;
        int FB;
        int FMS;
        int AMS;
        final int[] FNUM = new int[4];
        final int[] FOCT = new int[4];
        final int[] KC = new int[4];
        final cSlot[] SLOT = new cSlot[4];
        int FFlag;

        public cChannel() {
            for (int i = 0; i < 4; ++i) {
                this.SLOT[i] = new cSlot();
            }
        }
    }

    private final class cSlot {
        int[] DT;
        int MUL;
        int TL;
        int TLL;
        int SLL;
        int KSR_S;
        int KSR;
        int SEG;
        int AR;
        int DR;
        int SR;
        int RR;
        int Fcnt;
        int Finc;
        int Ecurp;
        int Ecnt;
        int Einc;
        int Ecmp;
        int EincA;
        int EincD;
        int EincS;
        int EincR;
        int INd;
        int ChgEnM;
        int AMS;
        int AMSon;

        private cSlot() {
        }
    }

    private final class cYM2612 {
        int Clock;
        int Rate;
        int TimerBase;
        int Status;
        int LFOcnt;
        int LFOinc;
        int TimerA;
        int TimerAL;
        int TimerAcnt;
        int TimerB;
        int TimerBL;
        int TimerBcnt;
        int Mode;
        int DAC;
        double Frequency;
        long Inter_Cnt;
        long Inter_Step;
        final cChannel[] CHANNEL = new cChannel[6];
        final int[][] REG = new int[2][256];

        public cYM2612() {
            for (int i = 0; i < 6; ++i) {
                this.CHANNEL[i] = new cChannel();
            }
        }
    }
}

