/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.sound.fm.ym2612.nukeykt;

import java.io.Serializable;
import java.util.Arrays;
import javax.sound.sampled.AudioFormat;
import omegadrive.sound.fm.MdFmProvider;
import omegadrive.sound.fm.VariableSampleRateSource;
import omegadrive.sound.fm.ym2612.Ym2612RegSupport;
import omegadrive.sound.fm.ym2612.nukeykt.IYm3438;
import omegadrive.sound.fm.ym2612.nukeykt.Ym3438;
import omegadrive.util.LogHelper;
import org.slf4j.Logger;

public class Ym2612Nuke
extends VariableSampleRateSource
implements MdFmProvider {
    private static final Logger LOG = LogHelper.getLogger(Ym2612Nuke.class.getSimpleName());
    private static final int AUDIO_SCALE_BITS = 3;
    private final IYm3438 ym3438 = new Ym3438();
    private IYm3438.IYm3438_Type chip;
    private Ym3438Context state;
    private final Ym2612RegSupport regSupport;
    private static final int syncAudioMode = Integer.parseInt(System.getProperty("helios.md.fm.sync.mode", "2"));
    private static final int syncAudioCycles = Math.max(1, 24 * syncAudioMode);
    private int syncAudioCnt = 0;
    private int prevL;
    private int prevR;
    private double cycleAccum = 0.0;

    public Ym2612Nuke(AudioFormat audioFormat, double sourceSampleRate) {
        this(new IYm3438.IYm3438_Type(), audioFormat, sourceSampleRate);
    }

    private Ym2612Nuke(IYm3438.IYm3438_Type chip, AudioFormat audioFormat, double sourceSampleRate) {
        super(sourceSampleRate / 6.0, audioFormat, "fmNuke", 3);
        this.chip = chip;
        this.ym3438.OPN2_SetChipType(2);
        this.state = new Ym3438Context();
        this.state.chip = chip;
        this.regSupport = new Ym2612RegSupport();
    }

    @Override
    public void setMicrosPerTick(double microsPerTick) {
        this.setMicrosPerInputSample(microsPerTick);
    }

    @Override
    public void reset() {
        super.reset();
        this.ym3438.OPN2_Reset(this.chip);
        this.state.reset();
        this.cycleAccum = 0.0;
        this.prevR = 0;
        this.prevL = 0;
        this.syncAudioCnt = 0;
    }

    @Override
    public int readRegister(int type, int regNumber) {
        return this.regSupport.readRegister(type, regNumber);
    }

    @Override
    public void write(int addr, int data) {
        this.spin();
        this.ym3438.OPN2_Write(this.chip, addr, data);
        this.regSupport.write(addr, data);
    }

    private void addSample() {
        if (this.cycleAccum > this.fmCalcsPerMicros) {
            super.addStereoSample(this.prevL, this.prevR);
            this.cycleAccum -= this.fmCalcsPerMicros;
        }
    }

    @Override
    public int read() {
        this.spin();
        return this.ym3438.OPN2_Read(this.chip, 16384);
    }

    @Override
    public void tick() {
        if (++this.syncAudioCnt == syncAudioCycles) {
            this.spin();
        }
    }

    private void spin() {
        for (int i = 0; i < this.syncAudioCnt; ++i) {
            this.cycleAccum += this.microsPerInputSample;
            this.spinOnce();
            this.addSample();
        }
        this.syncAudioCnt = 0;
    }

    @Override
    protected void spinOnce() {
        this.ym3438.OPN2_Clock(this.chip, this.state.ym3438_accm[this.state.ym3438_cycles]);
        this.state.ym3438_cycles = (this.state.ym3438_cycles + 1) % 24;
        if (this.state.ym3438_cycles == 0) {
            int sampleL = 0;
            int sampleR = 0;
            for (int j = 0; j < 24; ++j) {
                sampleL += this.state.ym3438_accm[j][0];
                sampleR += this.state.ym3438_accm[j][1];
            }
            this.filterAndSet(sampleL, sampleR);
        }
    }

    private void filterAndSet(int sampleL, int sampleR) {
        sampleL = sampleL + this.prevL >> 1;
        sampleR = sampleR + this.prevR >> 1;
        this.state.ym3438_diffLR_sampleL = (sampleL - sampleR & 0xFFFF) << 16 | sampleL & 0xFFFF;
        this.prevL = sampleL;
        this.prevR = sampleR;
    }

    public void setState(Ym3438Context state) {
        this.spin();
        if (state != null) {
            this.state = state;
            this.chip = state.chip;
            this.syncAudioCnt = state.ym3438_cycles;
        } else {
            LOG.warn("Unable to restore state, FM will not work");
            this.chip.reset();
            this.state.reset();
        }
    }

    public Ym3438Context getState() {
        return this.state;
    }

    public static class Ym3438Context
    implements Serializable {
        private static final long serialVersionUID = -2921159132727518547L;
        int ym3438_cycles = 0;
        int ym3438_diffLR_sampleL = 0;
        final int[][] ym3438_accm = new int[24][2];
        IYm3438.IYm3438_Type chip;

        public void reset() {
            this.ym3438_cycles = 0;
            this.ym3438_diffLR_sampleL = 0;
            Arrays.stream(this.ym3438_accm).forEach(row -> Arrays.fill(row, 0));
        }
    }
}

