/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.sound.psg;

import omegadrive.sound.SoundDevice;
import omegadrive.sound.SoundProvider;
import omegadrive.sound.psg.msx.Ay38910Psg;
import omegadrive.sound.psg.white.SN76489Psg;
import omegadrive.util.RegionDetector;

public interface PsgProvider
extends SoundDevice {
    public static final PsgProvider NO_SOUND = new PsgProvider(){

        @Override
        public void write(int data) {
        }

        @Override
        public void updateMono8(byte[] output, int offset, int end) {
        }
    };

    public static PsgProvider createSnInstance(RegionDetector.Region region, int sampleRate) {
        int clockHz = (int)SoundProvider.getPsgSoundClock(region);
        SoundProvider.LOG.info("PSG instance, clockHz: {}, sampleRate: {}", (Object)clockHz, (Object)sampleRate);
        return SN76489Psg.createInstance(clockHz, sampleRate);
    }

    public static PsgProvider createAyInstance(RegionDetector.Region region, int sampleRate) {
        int clockHz = (int)SoundProvider.getPsgSoundClock(region);
        SoundProvider.LOG.info("PSG instance, clockHz: {}, sampleRate: {}", (Object)clockHz, (Object)sampleRate);
        return Ay38910Psg.createInstance(sampleRate);
    }

    public void write(int var1);

    default public void write(int register, int data) {
        this.write(data);
    }

    default public int read(int register) {
        return 255;
    }

    @Override
    default public SoundDevice.SoundDeviceType getType() {
        return SoundDevice.SoundDeviceType.PSG;
    }
}

