/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.system;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.file.Path;
import java.util.Optional;
import java.util.StringJoiner;
import mcd.cart.MegaCdCartInfoProvider;
import mcd.cdd.ExtendedCueSheet;
import omegadrive.SystemLoader;
import omegadrive.cart.MdCartInfoProvider;
import omegadrive.cart.MediaInfoProvider;
import omegadrive.system.SysUtil;
import omegadrive.util.FileUtil;
import omegadrive.util.LogHelper;
import omegadrive.util.RegionDetector;
import omegadrive.util.ZipUtil;
import org.slf4j.Logger;

public class MediaSpecHolder {
    private static final Logger LOG = LogHelper.getLogger(MediaSpecHolder.class.getSimpleName());
    public static final Path NO_PATH = Path.of("NO_PATH", new String[0]);
    public static final MediaSpecHolder NO_ROM = MediaSpecHolder.of(NO_PATH);
    public MediaSpec cartFile;
    public MediaSpec cdFile;
    public SystemLoader.SystemType systemType;
    public RegionDetector.Region region;

    public static MediaInfoProvider getMediaInfoProvider(Path p) {
        MediaInfoProvider mip = new MediaInfoProvider();
        byte[] b = FileUtil.readBinaryFile(p, new String[0]);
        mip.romSize = b.length;
        mip.romName = p.getFileName().toString();
        return mip;
    }

    public static MdCartInfoProvider getMcdInfoProvider(Path p, MediaSpec mediaSpec) {
        MegaCdCartInfoProvider mdi = MegaCdCartInfoProvider.createMcdInstance(mediaSpec);
        mdi.romName = p.getFileName().toString();
        return mdi;
    }

    public static MdCartInfoProvider getMdInfoProvider(Path p, boolean compressed) {
        MdCartInfoProvider mdi = null;
        if (compressed) {
            byte[] b = FileUtil.readBinaryFile(p, new String[0]);
            assert (b.length > 0);
            mdi = MdCartInfoProvider.createMdInstance(b);
        } else {
            try (RandomAccessFile raf = new RandomAccessFile(p.toFile(), "r");){
                mdi = MdCartInfoProvider.createMdInstance(raf);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        mdi.romName = p.getFileName().toString();
        return mdi;
    }

    public static MediaSpecHolder of(Path path) {
        return MediaSpecHolder.of(path, SystemLoader.SystemType.NONE);
    }

    public static MediaSpecHolder of(String filePath) {
        return MediaSpecHolder.of(Path.of(filePath, new String[0]), SystemLoader.SystemType.NONE);
    }

    public static MediaSpecHolder of(File file) {
        return MediaSpecHolder.of(Path.of(file.getAbsolutePath(), new String[0]), SystemLoader.SystemType.NONE);
    }

    public static MediaSpecHolder of(File file, SystemLoader.SystemType systemType) {
        return MediaSpecHolder.of(Path.of(file.getAbsolutePath(), new String[0]), systemType);
    }

    public static MediaSpecHolder of(Path file, SystemLoader.SystemType systemType) {
        MediaSpecHolder r = new MediaSpecHolder();
        r.systemType = systemType;
        SysUtil.RomFileType rft = SysUtil.RomFileType.CART_ROM;
        rft = file.toString().endsWith(".cue") ? SysUtil.RomFileType.BIN_CUE : rft;
        rft = file.toString().endsWith(".iso") ? SysUtil.RomFileType.ISO : rft;
        MediaSpec ms = MediaSpec.of(file, rft, systemType);
        if (rft.isDiscImage()) {
            r.cdFile = ms;
        } else {
            r.cartFile = ms;
        }
        return r;
    }

    public void reload() {
        assert (!this.hasRomCart() || this.cartFile.systemType == SystemLoader.SystemType.NONE || this.cartFile.systemType == this.systemType);
        assert (!this.hasDiscImage() || this.cdFile.systemType == SystemLoader.SystemType.NONE || this.cdFile.systemType == this.systemType);
        if (this.hasRomCart()) {
            this.cartFile.systemType = this.systemType;
            this.cartFile.init();
        }
        if (this.hasDiscImage()) {
            this.cdFile.systemType = this.systemType;
            this.cdFile.init();
        }
    }

    public boolean hasRomCart() {
        return this.cartFile != null && this.cartFile.type == SysUtil.RomFileType.CART_ROM;
    }

    public boolean hasDiscImage() {
        return this.cdFile != null && this.cdFile.type.isDiscImage();
    }

    public MediaSpec getBootableMedia() {
        if (this.hasDiscImage() && this.hasRomCart()) {
            return this.cdFile.bootable ? this.cdFile : this.cartFile;
        }
        if (this.hasRomCart()) {
            return this.cartFile;
        }
        if (this.hasDiscImage()) {
            return this.cdFile;
        }
        return null;
    }

    public RegionDetector.Region getRegion() {
        return this.region;
    }

    public String toInfoString() {
        Object s = this.toString();
        if (this.cartFile != null) {
            s = (String)s + "\n" + String.valueOf(this.cartFile);
        }
        if (this.cdFile != null) {
            s = (String)s + "\n" + String.valueOf(this.cdFile);
        }
        return s;
    }

    public String toString() {
        return String.valueOf((Object)this.systemType) + "," + String.valueOf(this.getBootableMedia().romFile.toAbsolutePath());
    }

    public static class MediaSpec {
        public Path romFile;
        public SysUtil.RomFileType type;
        public MediaInfoProvider mediaInfoProvider;
        public SystemLoader.SystemType systemType;
        public Optional<ExtendedCueSheet> sheetOpt = Optional.empty();
        public int mediaSizeBytes;
        public RegionDetector.Region region;
        public boolean bootable;
        public boolean compressed;

        public static MediaSpec of(Path p, SysUtil.RomFileType t, SystemLoader.SystemType st) {
            MediaSpec m = new MediaSpec();
            m.romFile = p;
            m.type = t;
            m.systemType = st;
            m.compressed = ZipUtil.isCompressedByteStream(p);
            m.init();
            return m;
        }

        protected void init() {
            boolean validPath;
            boolean isCartBased = !this.type.isDiscImage();
            boolean isCartMdBased = isCartBased && this.systemType.isMdBased();
            boolean bl = validPath = !this.romFile.toAbsolutePath().equals(NO_PATH.toAbsolutePath());
            if (isCartMdBased && validPath) {
                this.mediaInfoProvider = MediaSpecHolder.getMdInfoProvider(this.romFile, this.compressed);
                this.mediaSizeBytes = this.mediaInfoProvider.getRomSize();
            } else if (isCartBased && validPath) {
                this.mediaInfoProvider = MediaSpecHolder.getMediaInfoProvider(this.romFile);
                this.mediaSizeBytes = this.mediaInfoProvider.getRomSize();
            } else if (this.type.isDiscImage()) {
                assert (!ZipUtil.isCompressedByteStream(this.romFile));
                assert (!this.compressed);
                this.sheetOpt = Optional.of(new ExtendedCueSheet(this.romFile, this.type));
                this.mediaInfoProvider = MediaSpecHolder.getMcdInfoProvider(this.romFile, this);
            }
        }

        public String toString() {
            return new StringJoiner(", ", MediaSpec.class.getSimpleName() + "[", "]").add("romFile=" + String.valueOf(this.romFile)).add("type=" + String.valueOf((Object)this.type)).add("mediaInfoProvider=" + String.valueOf(this.mediaInfoProvider)).add("systemType=" + String.valueOf((Object)this.systemType)).add("mediaSizeBytes=" + this.mediaSizeBytes).add("region=" + String.valueOf((Object)this.region)).add("bootable=" + this.bootable).add("compressed=" + this.compressed).toString();
        }
    }
}

