/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.system;

import omegadrive.SystemLoader;
import omegadrive.bus.model.Z80BusProvider;
import omegadrive.bus.z80.ColecoBus;
import omegadrive.bus.z80.MsxBus;
import omegadrive.bus.z80.Sg1000Bus;
import omegadrive.cpu.z80.Z80CoreWrapper;
import omegadrive.cpu.z80.Z80Provider;
import omegadrive.input.InputProvider;
import omegadrive.joypad.ColecoPad;
import omegadrive.joypad.MsxPad;
import omegadrive.joypad.TwoButtonsJoypad;
import omegadrive.memory.MemoryProvider;
import omegadrive.savestate.BaseStateHandler;
import omegadrive.system.BaseSystem;
import omegadrive.system.SystemProvider;
import omegadrive.ui.DisplayWindow;
import omegadrive.util.LogHelper;
import omegadrive.util.Util;
import omegadrive.util.VideoMode;
import omegadrive.vdp.Tms9918aVdp;
import org.slf4j.Logger;

public class Z80BaseSystem
extends BaseSystem<Z80BusProvider> {
    private static final Logger LOG = LogHelper.getLogger(Z80BaseSystem.class.getSimpleName());
    protected Z80Provider z80;
    private final Z80Provider.Interrupt vdpInterruptType;
    private static final int VDP_DIVIDER = 1;
    private static final int Z80_DIVIDER = 3;
    private int nextZ80Cycle = 3;

    protected Z80BaseSystem(SystemLoader.SystemType systemType, DisplayWindow emuFrame) {
        super(emuFrame);
        this.systemType = systemType;
        this.vdpInterruptType = systemType == SystemLoader.SystemType.COLECO ? Z80Provider.Interrupt.NMI : Z80Provider.Interrupt.IM1;
    }

    public static SystemProvider createNewInstance(SystemLoader.SystemType systemType, DisplayWindow emuFrame) {
        return new Z80BaseSystem(systemType, emuFrame);
    }

    @Override
    public void init() {
        super.init();
        switch (this.systemType) {
            case SG_1000: {
                this.joypad = new TwoButtonsJoypad();
                this.memory = MemoryProvider.createSg1000Instance();
                this.bus = new Sg1000Bus();
                break;
            }
            case MSX: {
                this.joypad = new MsxPad();
                this.memory = MemoryProvider.createMsxInstance();
                this.bus = new MsxBus();
                break;
            }
            case COLECO: {
                this.joypad = new ColecoPad();
                this.memory = MemoryProvider.createSg1000Instance();
                this.bus = new ColecoBus();
            }
        }
        this.initCommon();
    }

    private void initCommon() {
        this.stateHandler = BaseStateHandler.EMPTY_STATE;
        this.inputProvider = InputProvider.createInstance(this.joypad);
        this.vdp = new Tms9918aVdp();
        this.z80 = Z80CoreWrapper.createInstance(this.systemType, (Z80BusProvider)this.bus);
        ((Z80BusProvider)this.bus).attachDevices(this, this.memory, this.joypad, this.vdp, this.z80, this.sound);
        this.reloadWindowState();
        this.createAndAddVdpEventListener();
    }

    @Override
    protected void loop() {
        this.targetNs = (long)(this.getRegion().getFrameIntervalMs() * (double)Util.MILLI_IN_NS);
        this.updateVideoMode(true);
        do {
            this.runZ80(this.cycleCounter);
            this.runVdp(this.cycleCounter);
            ++this.cycleCounter;
        } while (!this.runningRomFuture.isDone());
    }

    @Override
    protected void postInit() {
        super.postInit();
        this.z80.reset();
    }

    @Override
    protected void resetCycleCounters(int counter) {
        this.nextZ80Cycle -= counter;
    }

    @Override
    protected void updateVideoMode(boolean force) {
        VideoMode vm = this.vdp.getVideoMode();
        if (force || this.displayContext.videoMode != vm) {
            LOG.info("Video mode changed: {}", (Object)vm);
            this.displayContext.videoMode = vm;
        }
    }

    private void runVdp(long counter) {
        if ((counter & 1L) == 1L) {
            this.vdp.runSlot();
        }
    }

    private void runZ80(long counter) {
        if (counter == (long)this.nextZ80Cycle) {
            int cycleDelay = this.z80.executeInstruction();
            this.handleInterrupt();
            cycleDelay = Math.max(1, cycleDelay);
            this.nextZ80Cycle += 3 * cycleDelay;
        }
    }

    private void handleInterrupt() {
        ((Z80BusProvider)this.bus).handleInterrupts(this.vdpInterruptType);
    }
}

