/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.system.gb;

import eu.rekawek.coffeegb.gpu.Display;
import eu.rekawek.coffeegb.gui.Emulator;
import eu.rekawek.coffeegb.gui.SwingController;
import eu.rekawek.coffeegb.sound.SoundOutput;
import java.awt.event.KeyListener;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import omegadrive.SystemLoader;
import omegadrive.bus.model.BaseBusProvider;
import omegadrive.input.InputProvider;
import omegadrive.input.KeyboardInputHelper;
import omegadrive.joypad.ExternalPad;
import omegadrive.memory.MemoryProvider;
import omegadrive.system.BaseSystem;
import omegadrive.system.SysUtil;
import omegadrive.system.SystemProvider;
import omegadrive.system.gb.HeliosDisplay;
import omegadrive.ui.DisplayWindow;
import omegadrive.util.LogHelper;
import omegadrive.util.Util;
import omegadrive.util.VideoMode;
import omegadrive.vdp.model.BaseVdpAdapter;
import org.slf4j.Logger;

public class Gb
extends BaseSystem<BaseBusProvider> {
    private static final Logger LOG = LogHelper.getLogger(Gb.class.getSimpleName());
    private Emulator emulator;
    private final SwingController controller;

    protected Gb(SystemLoader.SystemType systemType, DisplayWindow emuFrame) {
        super(emuFrame);
        this.systemType = systemType;
        Properties properties = this.addKeyboardBindings(new Properties());
        this.controller = SwingController.createIntController((Properties)properties);
    }

    public static SystemProvider createNewInstance(SystemLoader.SystemType systemType, DisplayWindow emuFrame) {
        return new Gb(systemType, emuFrame);
    }

    @Override
    public void init() {
        super.init();
        this.bus = SysUtil.NO_OP_BUS;
        this.vdp = SysUtil.NO_OP_VDP_PROVIDER;
        this.memory = MemoryProvider.NO_MEMORY;
        this.joypad = ExternalPad.createTwoButtonsPad((KeyListener)this.controller);
        this.initCommon();
    }

    private void initCommon() {
        this.inputProvider = InputProvider.createInstance(this.joypad);
        this.reloadWindowState();
    }

    @Override
    protected void loop() {
        LOG.info("Starting game loop");
        this.targetNs = (long)(this.getRegion().getFrameIntervalMs() * (double)Util.MILLI_IN_NS);
        String[] args = new String[]{this.getRomPath().toAbsolutePath().toString()};
        this.emulator = this.createEmulator(args);
        this.emulator.runOnCurrentThread();
        LOG.info("Exiting rom thread loop");
    }

    private Emulator createEmulator(String[] args) {
        try {
            HeliosDisplay display = new HeliosDisplay(this, this.display);
            this.emulator = new Emulator(args, (Display)display, (SoundOutput)this.sound.getFm(), this.controller);
            this.vdp = BaseVdpAdapter.getVdpProviderWrapper(VideoMode.NTSCJ_H20_V18, display);
        }
        catch (Exception e) {
            LOG.error("Unable to start emulation: {}", (Object)this.getRomPath(), (Object)e);
        }
        return this.emulator;
    }

    private Properties addKeyboardBindings(Properties properties) {
        Map map = KeyboardInputHelper.keyboardBindings.row((Object)InputProvider.PlayerNumber.P1);
        map.forEach((k, v) -> properties.put("btn_" + k.getMnemonic(), v));
        return properties;
    }

    @Override
    protected void handleCloseRom() {
        Optional.ofNullable(this.emulator).ifPresent(Emulator::stop);
        super.handleCloseRom();
    }

    @Override
    protected void processSaveState() {
    }

    @Override
    protected void resetCycleCounters(int counter) {
    }

    @Override
    protected void updateVideoMode(boolean force) {
        this.displayContext.videoMode = this.vdp.getVideoMode();
    }
}

