/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.system.nes;

import com.grapeshot.halfnes.audio.AudioOutInterface;
import com.grapeshot.halfnes.ui.ControllerImpl;
import java.awt.event.KeyListener;
import java.nio.file.Path;
import omegadrive.SystemLoader;
import omegadrive.bus.model.BaseBusProvider;
import omegadrive.input.InputProvider;
import omegadrive.joypad.ExternalPad;
import omegadrive.memory.MemoryProvider;
import omegadrive.savestate.BaseStateHandler;
import omegadrive.savestate.NesStateHandler;
import omegadrive.system.BaseSystem;
import omegadrive.system.SysUtil;
import omegadrive.system.SystemProvider;
import omegadrive.system.nes.NesHelper;
import omegadrive.ui.DisplayWindow;
import omegadrive.util.LogHelper;
import omegadrive.util.Util;
import org.slf4j.Logger;

public class Nes
extends BaseSystem<BaseBusProvider> {
    private static final Logger LOG = LogHelper.getLogger(Nes.class.getSimpleName());
    private NesHelper.NesGUIInterface gui;

    protected Nes(SystemLoader.SystemType systemType, DisplayWindow emuFrame) {
        super(emuFrame);
        this.systemType = systemType;
    }

    public static SystemProvider createNewInstance(SystemLoader.SystemType systemType, DisplayWindow emuFrame) {
        return new Nes(systemType, emuFrame);
    }

    private void initCommon() {
        this.inputProvider = InputProvider.createInstance(this.joypad);
        this.reloadWindowState();
    }

    @Override
    protected BaseStateHandler createStateHandler(Path file, BaseStateHandler.Type type) {
        NesStateHandler n = (NesStateHandler)super.createStateHandler(file, type);
        n.setNes(this.gui.getNes());
        return n;
    }

    @Override
    public void init() {
        super.init();
        this.stateHandler = BaseStateHandler.EMPTY_STATE;
        this.bus = SysUtil.NO_OP_BUS;
        this.vdp = SysUtil.NO_OP_VDP_PROVIDER;
        this.memory = MemoryProvider.NO_MEMORY;
        this.joypad = ExternalPad.createTwoButtonsPad((KeyListener)NesHelper.cnt1, (KeyListener)NesHelper.cnt2);
        this.initCommon();
    }

    @Override
    protected void loop() {
        this.targetNs = (long)(this.getRegion().getFrameIntervalMs() * (double)Util.MILLI_IN_NS);
        this.displayContext.videoMode = this.vdp.getVideoMode();
        this.gui = NesHelper.createNes(this.getRomPath(), this, (AudioOutInterface)this.sound.getFm());
        this.vdp = this.gui.getVdpProvider();
        this.gui.run();
    }

    @Override
    protected void handleCloseRom() {
        this.gui.close();
        super.handleCloseRom();
    }

    @Override
    protected void resetCycleCounters(int counter) {
    }

    @Override
    protected void updateVideoMode(boolean force) {
        this.displayContext.videoMode = this.vdp.getVideoMode();
    }

    static {
        ControllerImpl.JINPUT_ENABLE = false;
        LOG.info("Disabling halfNes jinput");
    }
}

