/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.ui;

import com.google.common.collect.TreeBasedTable;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import omegadrive.input.InputProvider;
import omegadrive.input.KeyboardInputHelper;
import omegadrive.joypad.JoypadProvider;
import omegadrive.system.SystemProvider;
import omegadrive.util.FileUtil;
import omegadrive.util.LogHelper;
import org.slf4j.Logger;

public class KeyBindingsHandler {
    private static final Logger LOG = LogHelper.getLogger(KeyBindingsHandler.class.getSimpleName());
    protected static final String DIV = "=";
    protected static final String PLAYER_DIV = "\\.";
    protected static final String PLAYER_LINE_HEAD = "P.";
    public static final String configFile = String.valueOf(System.getProperty("key.config.file", "key.config"));
    protected static InputMap keyMap;
    private static KeyBindingsHandler instance;

    public static synchronized KeyBindingsHandler getInstance() {
        if (instance == null) {
            instance = new KeyBindingsHandler();
            instance.init();
        }
        return instance;
    }

    private static void loadKeyMap() {
        LOG.info("Loading key config file: {}", (Object)configFile);
        List<String> l = FileUtil.readFileContent(configFile);
        keyMap = KeyBindingsHandler.parseConfig(l);
        List<String> l1 = l;
        Arrays.stream(InputProvider.PlayerNumber.values()).forEach(p -> KeyBindingsHandler.parsePlayerConfig(l1, p));
    }

    private void init() {
        KeyBindingsHandler.loadKeyMap();
    }

    protected static InputMap parseConfig(List<String> str) {
        InputMap m = new InputMap();
        try {
            str.forEach(l -> {
                boolean validLine;
                boolean bl = validLine = !(l = l.trim()).isEmpty() && !l.startsWith("#") && !l.startsWith(PLAYER_LINE_HEAD);
                if (validLine) {
                    String[] s = l.split(DIV);
                    Optional<KeyStroke> ksOpt = Optional.ofNullable(KeyStroke.getKeyStroke(s[1]));
                    if (ksOpt.isPresent()) {
                        m.put(ksOpt.get(), (Object)SystemProvider.SystemEvent.valueOf(s[0]));
                    } else {
                        LOG.warn("Unable to parse keyStroke: {}", (Object)s[1]);
                    }
                }
            });
        }
        catch (Exception e) {
            return KeyboardInputHelper.DEFAULT_INPUT_MAP;
        }
        return m.size() == 0 ? KeyboardInputHelper.DEFAULT_INPUT_MAP : m;
    }

    protected static void parsePlayerConfig(List<String> str, InputProvider.PlayerNumber number) {
        try {
            HashMap<String, Integer> playerKeyMap = new HashMap<String, Integer>();
            str.forEach(l -> {
                String[] s1;
                Optional<JoypadProvider.JoypadButton> btn;
                String[] s;
                InputProvider.PlayerNumber pn;
                boolean validLine;
                boolean bl = validLine = !(l = l.trim()).isEmpty() && !l.startsWith("#") && l.startsWith(PLAYER_LINE_HEAD);
                if (validLine && (pn = InputProvider.PlayerNumber.valueOf((s = l.split(PLAYER_DIV))[0] + s[1])) == number && (btn = KeyBindingsHandler.getJoypadButton((s1 = s[2].split(DIV))[0])).isPresent()) {
                    Optional<KeyStroke> ks = Optional.ofNullable(KeyStroke.getKeyStroke(s1[1]));
                    if (ks.isPresent()) {
                        playerKeyMap.put(btn.get().name(), ks.get().getKeyCode());
                    } else {
                        LOG.warn("Unable to parse line: {}", l);
                    }
                }
            });
            if (!playerKeyMap.isEmpty()) {
                KeyboardInputHelper.updatePlayerMappings(number, playerKeyMap);
            }
        }
        catch (Exception e) {
            LOG.warn("Unable to parse key config for player {}", (Object)number);
        }
    }

    private static Optional<JoypadProvider.JoypadButton> getJoypadButton(String configToken) {
        JoypadProvider.JoypadButton btn = null;
        for (JoypadProvider.JoypadButton b : JoypadProvider.JoypadButton.values()) {
            if (!b.getMnemonic().equalsIgnoreCase(configToken)) continue;
            btn = b;
        }
        return Optional.ofNullable(btn);
    }

    public SystemProvider.SystemEvent getSystemEventIfAny(KeyStroke keyStroke) {
        return (SystemProvider.SystemEvent)((Object)Optional.ofNullable(keyMap.get(keyStroke)).orElse((Object)SystemProvider.SystemEvent.NONE));
    }

    public KeyStroke getKeyStrokeForEvent(SystemProvider.SystemEvent event) {
        return Arrays.stream(keyMap.allKeys()).filter(ks -> event == this.getSystemEventIfAny((KeyStroke)ks)).findFirst().orElse(null);
    }

    public static String toConfigString() {
        return String.join((CharSequence)"\n", KeyBindingsHandler.toConfigList());
    }

    private static List<String> toConfigList() {
        ArrayList<String> l = new ArrayList<String>();
        for (KeyStroke ks : keyMap.allKeys()) {
            l.add(keyMap.get(ks).toString() + DIV + ks.toString());
        }
        Collections.sort(l);
        TreeBasedTable table = TreeBasedTable.create();
        table.putAll(KeyboardInputHelper.keyboardBindings);
        table.cellSet().forEach(cell -> {
            String tk = PLAYER_LINE_HEAD + ((InputProvider.PlayerNumber)((Object)((Object)cell.getRowKey()))).name().substring(1) + ".";
            tk = tk + ((JoypadProvider.JoypadButton)((Object)((Object)cell.getColumnKey()))).getMnemonic() + DIV;
            tk = tk + KeyEvent.getKeyText((Integer)cell.getValue()).toUpperCase();
            l.add(tk);
        });
        return l;
    }
}

