/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.ui;

import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JFrame;
import omegadrive.util.LogHelper;
import org.slf4j.Logger;

public class SwingScreenSupport {
    public static final int DEFAULT_SCREEN = Integer.valueOf(System.getProperty("helios.ui.default.screen", "1"));
    private static final Logger LOG = LogHelper.getLogger(SwingScreenSupport.class.getSimpleName());
    private static final GraphicsDevice[] graphicsDevices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
    private static int currentScreen = graphicsDevices.length > 1 ? DEFAULT_SCREEN : 0;

    public static GraphicsDevice setupScreens() {
        LOG.info("Screen detected: #{}", (Object)graphicsDevices.length);
        GraphicsDevice gd = graphicsDevices[currentScreen];
        LOG.info("Initial screen: {}", (Object)gd.getIDstring());
        return gd;
    }

    public static List<String> detectScreens() {
        return Arrays.stream(graphicsDevices).map(Object::toString).collect(Collectors.toList());
    }

    public static int getCurrentScreen() {
        return currentScreen;
    }

    public static GraphicsDevice getGraphicsDevice() {
        return graphicsDevices[currentScreen];
    }

    public static int detectUserScreenChange(GraphicsDevice currentDevice) {
        GraphicsDevice prevDevice = graphicsDevices[currentScreen];
        if (!currentDevice.equals(prevDevice)) {
            for (int i = 0; i < graphicsDevices.length; ++i) {
                if (!graphicsDevices[i].equals(currentDevice)) continue;
                currentScreen = i;
                return i;
            }
        }
        return currentScreen;
    }

    public static void showOnCurrentScreen(JFrame frame) {
        SwingScreenSupport.showOnScreen(currentScreen, frame);
    }

    public static void showOnScreen(int screen, JFrame frame) {
        GraphicsDevice[] gd = graphicsDevices;
        int width = 0;
        int height = 0;
        if (screen > -1 && screen < gd.length) {
            Rectangle bounds = gd[screen].getDefaultConfiguration().getBounds();
            width = bounds.width;
            height = bounds.height;
            frame.setLocation(width / 2 - frame.getSize().width / 2 + bounds.x, height / 2 - frame.getSize().height / 2 + bounds.y);
            frame.setVisible(true);
            LOG.info("Showing on screen: {}", (Object)screen);
            currentScreen = screen;
        } else {
            LOG.error("Unable to set screen: {}", (Object)screen);
        }
    }
}

