/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.ui;

import com.google.common.base.Strings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import omegadrive.SystemLoader;
import omegadrive.input.InputProvider;
import omegadrive.joypad.JoypadProvider;
import omegadrive.system.MediaSpecHolder;
import omegadrive.system.SystemProvider;
import omegadrive.ui.DisplayWindow;
import omegadrive.ui.KeyBindingsHandler;
import omegadrive.ui.MouseCursorHandler;
import omegadrive.ui.PrefStore;
import omegadrive.ui.RenderingStrategy;
import omegadrive.ui.SwingScreenSupport;
import omegadrive.ui.flatlaf.FlatLafHelper;
import omegadrive.ui.util.IconsLoader;
import omegadrive.ui.util.UiFileFilters;
import omegadrive.util.FileUtil;
import omegadrive.util.ImageUtil;
import omegadrive.util.LogHelper;
import omegadrive.util.PriorityThreadFactory;
import omegadrive.util.RegionDetector;
import omegadrive.util.ScreenSizeHelper;
import omegadrive.util.Util;
import omegadrive.util.VideoMode;
import org.slf4j.Logger;

public class SwingWindow
implements DisplayWindow {
    private static final Logger LOG = LogHelper.getLogger(SwingWindow.class.getSimpleName());
    private static final boolean UI_SCALE_ON_THREAD = Boolean.parseBoolean(System.getProperty("ui.scale.on.thread", "true"));
    private static final Path WINDOW_ICONS_PATH = Paths.get("./res", "icon");
    private static final Predicate<Path> ICONS_FILE_FILTER = p -> p.getFileName().toString().startsWith("helios") && p.getFileName().toString().endsWith(".jpg");
    private Dimension fullScreenSize;
    private Dimension outputNonScaledScreenSize = ScreenSizeHelper.DEFAULT_SCALED_SCREEN_SIZE;
    private Dimension outputScreenSize = ScreenSizeHelper.DEFAULT_SCALED_SCREEN_SIZE;
    private BufferedImage dest;
    private int[] pixelsSrc;
    private int[] pixelsDest;
    private double scale = ScreenSizeHelper.DEFAULT_SCALE_FACTOR;
    private final JLabel screenLabel = new JLabel();
    private final JLabel eventInfoLabel = new JLabel("");
    private final JLabel regionLabel = new JLabel("");
    private final JLabel megaCdLedLabel = new JLabel("");
    private final JLabel fpsLabel = new JLabel("");
    private JFrame jFrame;
    private SystemProvider mainEmu;
    private List<AbstractButton> regionItems;
    private JCheckBoxMenuItem fullScreenItem;
    private JCheckBoxMenuItem debugInfoItem;
    private JCheckBoxMenuItem soundEnItem;
    private JMenu recentFilesMenu;
    private JMenu joypadTypeMenu;
    private JMenuItem[] recentFilesItems;
    private final Map<InputProvider.PlayerNumber, JMenu> inputMenusMap;
    private static final int screenChangedCheckFrequency = 60;
    private List<AbstractButton> screenItems;
    private int screenChangedCheckCounter = 60;
    private Dimension nativeScreenSize = ScreenSizeHelper.DEFAULT_BASE_SCREEN_SIZE;
    private final Map<SystemProvider.SystemEvent, AbstractAction> actionMap = new HashMap<SystemProvider.SystemEvent, AbstractAction>();
    private int showInfoCount = 120;
    private Optional<String> actionInfo = Optional.empty();
    private MouseCursorHandler cursorHandler;
    private AWTEventListener awtEventListener;
    private MediaSpecHolder mediaSpec = MediaSpecHolder.NO_ROM;
    private final ExecutorService executorService;
    private Future<?> previousFrame = CompletableFuture.completedFuture(null);
    private DisplayWindow.DisplayContext dcCopy = new DisplayWindow.DisplayContext();

    public SwingWindow(SystemProvider mainEmu) {
        this.mainEmu = mainEmu;
        this.inputMenusMap = new LinkedHashMap<InputProvider.PlayerNumber, JMenu>();
        Arrays.stream(InputProvider.PlayerNumber.values()).forEach(pn -> this.inputMenusMap.put((InputProvider.PlayerNumber)((Object)pn), new JMenu(pn.name())));
        this.executorService = UI_SCALE_ON_THREAD ? Executors.newSingleThreadExecutor(new PriorityThreadFactory("frameSubmitter")) : null;
    }

    @Override
    public void setRomData(MediaSpecHolder rom) {
        this.mediaSpec = rom;
        if (this.mediaSpec == MediaSpecHolder.NO_ROM) {
            return;
        }
        this.jFrame.setTitle("Helios" + this.mainEmu.getSystemType().getShortName() + " " + VERSION + " - " + FileUtil.getFileName(rom.getBootableMedia().romFile));
        RegionDetector.Region region = rom.getRegion();
        Icon icon = IconsLoader.getRegionIcon(region);
        this.regionLabel.setIcon(icon);
        this.regionLabel.setText(icon == null ? region.name() : "");
        this.regionLabel.setToolTipText(region.name());
        this.reloadRecentFiles();
        if (this.mainEmu.getSystemType().isMegaCdAttached()) {
            this.megaCdLedLabel.setIcon(IconsLoader.getLedIcon(0));
        }
    }

    private void addKeyAction(AbstractButton component, SystemProvider.SystemEvent event, ActionListener l) {
        AbstractAction action = this.toAbstractAction(component.getText(), l);
        if (event != SystemProvider.SystemEvent.NONE) {
            action.putValue("AcceleratorKey", KeyBindingsHandler.getInstance().getKeyStrokeForEvent(event));
            this.actionMap.put(event, action);
        }
        component.setAction(action);
    }

    private void addAction(AbstractButton component, ActionListener act) {
        this.addKeyAction(component, SystemProvider.SystemEvent.NONE, act);
    }

    private AbstractAction toAbstractAction(String name, ActionListener listener) {
        return new MyAbstractAction(name, listener);
    }

    private void showHelpMessage(String title, String msg) {
        JTextArea area = new JTextArea(msg);
        area.setEditable(false);
        JScrollPane scrollPane = new JScrollPane(area);
        scrollPane.setPreferredSize(this.jFrame.getPreferredSize());
        JOptionPane.showMessageDialog(this.jFrame, scrollPane, "Help: " + title, 1);
    }

    private void fullScreenAction(ActionEvent doToggle) {
        if (doToggle == null) {
            this.setFullScreen(!this.fullScreenItem.getState());
        }
    }

    private GraphicsDevice getGraphicsDevice() {
        return this.jFrame.getGraphicsConfiguration().getDevice();
    }

    private BufferedImage createImage(GraphicsDevice gd, Dimension d) {
        BufferedImage bi = gd.getDefaultConfiguration().createCompatibleImage(d.width, d.height);
        if (bi.getType() != 1) {
            bi = new BufferedImage(d.width, d.height, 1);
        }
        this.pixelsDest = ImageUtil.getPixels(bi);
        return bi;
    }

    private void showDebugInfo(ActionEvent event) {
        this.showDebugInfo(event == null != this.debugInfoItem.getState());
    }

    private void showDebugInfo(boolean state) {
        SwingUtilities.invokeLater(() -> {
            this.debugInfoItem.setState(state);
            this.jFrame.getJMenuBar().setVisible(state);
            if (!this.fullScreenItem.getState()) {
                this.jFrame.getJMenuBar().setVisible(true);
            }
            this.eventInfoLabel.setVisible(state);
            this.jFrame.repaint();
        });
    }

    @Override
    public void resetScreen() {
        Util.sleep(250L);
        SwingUtilities.invokeLater(() -> {
            Arrays.fill(this.pixelsDest, 0);
            this.screenLabel.invalidate();
            this.screenLabel.repaint();
            this.eventInfoLabel.setText("");
            this.regionLabel.setIcon(null);
            this.regionLabel.setText("");
            this.megaCdLedLabel.setIcon(null);
            this.fpsLabel.setText("");
            this.jFrame.setTitle(FRAME_TITLE_HEAD);
            this.cursorHandler.reset();
            LOG.info("Blanking screen");
        });
    }

    @Override
    public void setFullScreen(boolean value) {
        SwingUtilities.invokeLater(() -> {
            this.fullScreenItem.setState(value);
            LOG.info("Full screen: {}", (Object)this.fullScreenItem.isSelected());
        });
    }

    @Override
    public String getRegionOverride() {
        return this.regionItems.stream().filter(AbstractButton::isSelected).map(AbstractButton::getText).findFirst().orElse(null);
    }

    @Override
    public void renderScreenLinear(DisplayWindow.DisplayContext dc) {
        if (dc.data.length != this.pixelsSrc.length) {
            this.pixelsSrc = (int[])dc.data.clone();
        }
        System.arraycopy(dc.data, 0, this.pixelsSrc, 0, dc.data.length);
        if (UI_SCALE_ON_THREAD) {
            assert (this.checkSlowDown());
            this.dcCopy.megaCdLedState = dc.megaCdLedState;
            this.dcCopy.label = dc.label;
            this.dcCopy.videoMode = dc.videoMode;
            this.dcCopy.fps = dc.fps;
            this.previousFrame = this.executorService.submit(Util.wrapRunnableEx(() -> this.renderScreenLinearInternal(this.pixelsSrc, this.dcCopy)));
        } else {
            this.renderScreenLinearInternal(this.pixelsSrc, dc);
        }
    }

    private boolean checkSlowDown() {
        if (!this.previousFrame.isDone()) {
            LOG.error("Slow frame!!");
        }
        return true;
    }

    @Override
    public void init() {
        Util.registerJmx(this);
        GraphicsDevice gd = SwingScreenSupport.setupScreens();
        this.fullScreenSize = gd.getDefaultConfiguration().getBounds().getSize();
        LOG.info("Full screen size: {}", (Object)this.fullScreenSize);
        LOG.info("Emulation viewport size: {}", (Object)ScreenSizeHelper.DEFAULT_SCALED_SCREEN_SIZE);
        LOG.info("Application size: {}", (Object)ScreenSizeHelper.DEFAULT_FRAME_SIZE);
        this.pixelsSrc = new int[0];
        this.dest = this.createImage(gd, this.outputNonScaledScreenSize);
        this.screenLabel.setIcon(new ImageIcon(this.dest));
        this.addDndListener(this.screenLabel);
        this.jFrame = new JFrame(FRAME_TITLE_HEAD, gd.getDefaultConfiguration());
        this.jFrame.getContentPane().setBackground(Color.BLACK);
        this.jFrame.getContentPane().setForeground(Color.BLACK);
        JMenuBar bar = new JMenuBar();
        JMenu menu = new JMenu("File");
        bar.add(menu);
        JMenu setting = new JMenu("Setting");
        bar.add(setting);
        JMenuItem pauseItem = new JMenuItem("Pause");
        this.addKeyAction(pauseItem, SystemProvider.SystemEvent.TOGGLE_PAUSE, e -> this.handleSystemEvent(SystemProvider.SystemEvent.TOGGLE_PAUSE, null, null));
        setting.add(pauseItem);
        JMenuItem resetItem = new JMenuItem("Hard Reset");
        this.addKeyAction(resetItem, SystemProvider.SystemEvent.RESET, e -> this.mainEmu.reset());
        setting.add(resetItem);
        JMenuItem softResetItem = new JMenuItem("Soft Reset");
        this.addKeyAction(softResetItem, SystemProvider.SystemEvent.SOFT_RESET, e -> this.handleSystemEvent(SystemProvider.SystemEvent.SOFT_RESET, null, null));
        setting.add(softResetItem);
        JMenu regionMenu = new JMenu("Region");
        setting.add(regionMenu);
        JMenu screensMenu = new JMenu("Screens");
        this.createAddScreenItems(screensMenu);
        setting.add(screensMenu);
        JMenu inputMenu = new JMenu("Input");
        this.reloadControllers(InputProvider.DEFAULT_CONTROLLERS);
        this.inputMenusMap.values().forEach(inputMenu::add);
        setting.add(inputMenu);
        this.joypadTypeMenu = new JMenu("Joypad Type");
        this.createAndAddJoypadTypes(this.joypadTypeMenu);
        setting.add(this.joypadTypeMenu);
        JMenu menuView = new JMenu("View");
        bar.add(menuView);
        this.regionItems = this.createRegionItems();
        this.regionItems.forEach(regionMenu::add);
        this.fullScreenItem = new JCheckBoxMenuItem("Full Screen", false);
        this.addKeyAction(this.fullScreenItem, SystemProvider.SystemEvent.TOGGLE_FULL_SCREEN, this::fullScreenAction);
        menuView.add(this.fullScreenItem);
        this.debugInfoItem = new JCheckBoxMenuItem("Debug Info", false);
        this.addKeyAction(this.debugInfoItem, SystemProvider.SystemEvent.SHOW_FPS, this::showDebugInfo);
        menuView.add(this.debugInfoItem);
        JMenu themeMenu = new JMenu("Themes");
        List<AbstractButton> themeItems = this.createThemeItems();
        themeItems.forEach(themeMenu::add);
        if (!themeItems.isEmpty()) {
            menuView.add(themeMenu);
        }
        this.soundEnItem = new JCheckBoxMenuItem("Enable Sound", true);
        this.addKeyAction(this.soundEnItem, SystemProvider.SystemEvent.SOUND_ENABLED, e -> this.handleSystemEvent(SystemProvider.SystemEvent.SOUND_ENABLED, this.soundEnItem.getState(), null));
        setting.add(this.soundEnItem);
        JMenu helpMenu = new JMenu("Help");
        bar.add(helpMenu);
        bar.add(Box.createHorizontalGlue());
        bar.add(this.eventInfoLabel);
        bar.add(Box.createHorizontalGlue());
        JPanel infoPanel = new JPanel();
        BoxLayout bl = new BoxLayout(infoPanel, 0);
        infoPanel.setLayout(bl);
        this.fpsLabel.setMaximumSize(new Dimension(25, 25));
        infoPanel.add(this.fpsLabel);
        infoPanel.add(Box.createHorizontalStrut(2));
        infoPanel.add(this.megaCdLedLabel);
        infoPanel.add(Box.createHorizontalStrut(2));
        infoPanel.add(this.regionLabel);
        bar.add(infoPanel);
        JMenuItem loadRomItem = new JMenuItem("Load ROM");
        this.addKeyAction(loadRomItem, SystemProvider.SystemEvent.NEW_ROM, e -> this.handleNewRom());
        this.recentFilesMenu = new JMenu("Recent Files");
        this.recentFilesItems = new JMenuItem[10];
        IntStream.range(0, this.recentFilesItems.length).forEach(i -> {
            this.recentFilesItems[i] = new JMenuItem();
            this.addKeyAction(this.recentFilesItems[i], SystemProvider.SystemEvent.NONE, e -> this.handleNewRomFromRecent(this.recentFilesItems[i].getToolTipText()));
            this.recentFilesMenu.add(this.recentFilesItems[i]);
        });
        this.reloadRecentFiles();
        JMenuItem closeRomItem = new JMenuItem("Close ROM");
        this.addKeyAction(closeRomItem, SystemProvider.SystemEvent.CLOSE_ROM, e -> this.handleSystemEvent(SystemProvider.SystemEvent.CLOSE_ROM, null, null));
        JMenuItem loadStateItem = new JMenuItem("Load State");
        this.addKeyAction(loadStateItem, SystemProvider.SystemEvent.LOAD_STATE, e -> this.handleLoadState());
        JMenuItem saveStateItem = new JMenuItem("Save State");
        this.addKeyAction(saveStateItem, SystemProvider.SystemEvent.SAVE_STATE, e -> this.handleSaveState());
        JMenuItem quickSaveStateItem = new JMenuItem("Quick Save State");
        this.addKeyAction(quickSaveStateItem, SystemProvider.SystemEvent.QUICK_SAVE, e -> this.handleQuickSaveState());
        JMenuItem quickLoadStateItem = new JMenuItem("Quick Load State");
        this.addKeyAction(quickLoadStateItem, SystemProvider.SystemEvent.QUICK_LOAD, e -> this.handleQuickLoadState());
        JMenuItem exitItem = new JMenuItem("Exit");
        this.addKeyAction(exitItem, SystemProvider.SystemEvent.CLOSE_APP, e -> {
            this.handleSystemEvent(SystemProvider.SystemEvent.CLOSE_APP, null, null);
            System.exit(0);
        });
        JMenuItem aboutItem = new JMenuItem("About");
        this.addAction(aboutItem, e -> this.showHelpMessage(aboutItem.getText(), this.getAboutString()));
        JMenuItem creditsItem = new JMenuItem("Credits");
        this.addAction(creditsItem, e -> this.showHelpMessage(creditsItem.getText(), FileUtil.readFileContentAsString("CREDITS.md")));
        JMenuItem keyBindingsItem = new JMenuItem("Key Bindings");
        this.addAction(keyBindingsItem, e -> this.showHelpMessage(keyBindingsItem.getText(), KeyBindingsHandler.toConfigString()));
        JMenuItem romInfoItem = new JMenuItem("Rom Info");
        this.addAction(romInfoItem, e -> this.showHelpMessage(romInfoItem.getText(), this.mediaSpec.toInfoString()));
        JMenuItem readmeItem = new JMenuItem("Readme");
        this.addAction(readmeItem, e -> this.showHelpMessage(readmeItem.getText(), FileUtil.readFileContentAsString("README.md")));
        JMenuItem licenseItem = new JMenuItem("License");
        this.addAction(licenseItem, e -> this.showHelpMessage(licenseItem.getText(), FileUtil.readFileContentAsString("LICENSE.md")));
        JMenuItem historyItem = new JMenuItem("History");
        this.addAction(historyItem, e -> this.showHelpMessage(historyItem.getText(), FileUtil.readFileContentAsString("HISTORY.md")));
        menu.add(loadRomItem);
        menu.add(this.recentFilesMenu);
        menu.add(closeRomItem);
        menu.add(loadStateItem);
        menu.add(saveStateItem);
        menu.add(quickLoadStateItem);
        menu.add(quickSaveStateItem);
        menu.add(exitItem);
        helpMenu.add(aboutItem);
        helpMenu.add(keyBindingsItem);
        helpMenu.add(romInfoItem);
        helpMenu.add(readmeItem);
        helpMenu.add(creditsItem);
        helpMenu.add(historyItem);
        helpMenu.add(licenseItem);
        this.screenLabel.setHorizontalAlignment(0);
        this.screenLabel.setVerticalAlignment(0);
        this.cursorHandler = new MouseCursorHandler(this.jFrame);
        this.setIcons(this.jFrame);
        this.jFrame.setMinimumSize(ScreenSizeHelper.DEFAULT_FRAME_SIZE);
        this.jFrame.setDefaultCloseOperation(3);
        this.jFrame.setResizable(true);
        this.jFrame.setJMenuBar(bar);
        this.jFrame.add((Component)this.screenLabel, -1);
        this.jFrame.pack();
        SwingScreenSupport.showOnCurrentScreen(this.jFrame);
        this.showDebugInfo(SystemLoader.showFps);
    }

    private void renderScreenLinearInternal(int[] data, DisplayWindow.DisplayContext dc) {
        this.resizeScreen(dc.videoMode);
        RenderingStrategy.renderNearest(data, this.pixelsDest, this.nativeScreenSize, this.outputScreenSize);
        dc.label.ifPresent(l -> this.showEventInfo());
        dc.fps.ifPresent(f -> this.showFpsIcon((double)f, dc.label));
        dc.megaCdLedState.ifPresent(v -> this.megaCdLedLabel.setIcon(IconsLoader.getLedIcon(v)));
        this.screenLabel.repaint();
        this.detectUserScreenChange();
        this.cursorHandler.newFrame();
    }

    private void showFpsIcon(double fps, Optional<String> explain) {
        int limit;
        long fpsr = Math.round(fps);
        String htmlColor = fpsr < (long)(limit = this.mediaSpec.getRegion().getFps() - 1) ? "red" : "lime";
        String s = "<html><font size=\"4\" color=\"" + htmlColor + "\"><b>" + fpsr + "</b></font></html>";
        this.fpsLabel.setText(s);
        explain.ifPresent(this.fpsLabel::setToolTipText);
    }

    private void detectUserScreenChange() {
        if (--this.screenChangedCheckCounter == 0) {
            int newScreen;
            this.screenChangedCheckCounter = 60;
            int prev = SwingScreenSupport.getCurrentScreen();
            if (prev != (newScreen = SwingScreenSupport.detectUserScreenChange(this.jFrame.getGraphicsConfiguration().getDevice()))) {
                LOG.info("Detected user change, showing on screen: {}", (Object)newScreen);
                this.handleScreenChangeItems(this.screenItems, newScreen);
            }
        }
    }

    private void showEventInfo() {
        --this.showInfoCount;
        if (this.actionInfo.isPresent()) {
            this.eventInfoLabel.setText(this.actionInfo.get());
        }
        if (this.showInfoCount <= 0) {
            this.actionInfo = Optional.empty();
            this.eventInfoLabel.setText("");
        }
    }

    private boolean resizeScreen(VideoMode videoMode) {
        boolean goFullScreen = this.fullScreenItem.getState();
        Dimension newBaseScreenSize = ScreenSizeHelper.getScreenSize(videoMode, 1.0, false);
        if (!newBaseScreenSize.equals(this.nativeScreenSize)) {
            this.nativeScreenSize = newBaseScreenSize;
        }
        double scale = ScreenSizeHelper.DEFAULT_SCALE_FACTOR;
        if (goFullScreen) {
            scale = ScreenSizeHelper.getFullScreenScaleFactor(this.fullScreenSize, this.nativeScreenSize);
        }
        return this.resizeScreenInternal(newBaseScreenSize, scale, goFullScreen);
    }

    private boolean resizeScreenInternal(Dimension newScreenSize, double scale, boolean isFullScreen) {
        boolean baseResize;
        boolean scaleChanged = this.scale != scale;
        boolean bl = baseResize = !newScreenSize.equals(this.outputNonScaledScreenSize);
        if (baseResize || scaleChanged) {
            this.outputNonScaledScreenSize = newScreenSize;
            this.scale = scale;
            try {
                Runnable resizeRunnable = this.getResizeRunnable(isFullScreen);
                if (SwingUtilities.isEventDispatchThread()) {
                    resizeRunnable.run();
                } else {
                    SwingUtilities.invokeAndWait(resizeRunnable);
                }
            }
            catch (InterruptedException | InvocationTargetException e) {
                LOG.error(e.getMessage());
            }
            return true;
        }
        return false;
    }

    private Runnable getResizeRunnable(boolean isFullScreen) {
        return () -> {
            this.outputScreenSize = ScreenSizeHelper.getScreenSize(this.nativeScreenSize, this.scale, ScreenSizeHelper.FIX_ASPECT_RATIO);
            this.dest = this.createImage(this.getGraphicsDevice(), this.outputScreenSize);
            this.screenLabel.setIcon(new ImageIcon(this.dest));
            this.jFrame.setPreferredSize(isFullScreen ? this.fullScreenSize : this.nativeScreenSize);
            this.jFrame.getJMenuBar().setVisible(!isFullScreen);
            this.jFrame.pack();
            SwingScreenSupport.showOnCurrentScreen(this.jFrame);
            LOG.info("Emulation Viewport size: {}", (Object)this.outputScreenSize);
            LOG.info("Application size: {}", (Object)this.jFrame.getSize());
        };
    }

    private Optional<MediaSpecHolder> loadFileDialog(Component parent, UiFileFilters.FileResourceType type) {
        return this.fileDialog(parent, type, true);
    }

    private JFileChooser createFileChooser(UiFileFilters.FileResourceType type, boolean load) {
        int dialogType = load ? 0 : 1;
        boolean isSaveState = type == UiFileFilters.FileResourceType.SAVE_STATE_RES;
        String lastFileStr = isSaveState ? PrefStore.lastSaveFile : PrefStore.lastRomFile;
        File lastFile = new File(lastFileStr);
        JFileChooser fileChooser = new JFileChooser(lastFile);
        fileChooser.setDialogType(dialogType);
        FileFilter[] filters = (FileFilter[])UiFileFilters.getFilterSet(type).toArray(FileFilter[]::new);
        Arrays.stream(filters).forEach(fileChooser::addChoosableFileFilter);
        fileChooser.setFileFilter(filters[0]);
        if (lastFile.isFile()) {
            fileChooser.setSelectedFile(lastFile);
        }
        return fileChooser;
    }

    private Optional<File> fileDialogState(Component parent, UiFileFilters.FileResourceType type, boolean load) {
        JFileChooser fileChooser = this.createFileChooser(type, load);
        int result = fileChooser.showDialog(parent, null);
        Optional<File> res = Optional.empty();
        if (result == 0) {
            res = Optional.ofNullable(fileChooser.getSelectedFile());
        }
        return res;
    }

    private Optional<MediaSpecHolder> fileDialog(Component parent, UiFileFilters.FileResourceType type, boolean load) {
        JFileChooser fileChooser = this.createFileChooser(type, load);
        int result = fileChooser.showDialog(parent, null);
        SystemLoader.SystemType systemType = SystemLoader.SystemType.NONE;
        Optional<File> res = Optional.empty();
        if (result == 0) {
            res = Optional.ofNullable(fileChooser.getSelectedFile());
            systemType = UiFileFilters.getSystemTypeFromFilterDesc(type, fileChooser.getFileFilter().getDescription(), this.mainEmu.getSystemType());
        }
        SystemLoader.SystemType st = systemType;
        return res.map(f -> MediaSpecHolder.of(f, st));
    }

    @Override
    public void showInfo(String info) {
        this.actionInfo = Optional.of(info);
        this.showInfoCount = 120;
    }

    private Optional<MediaSpecHolder> loadRomDialog(Component parent) {
        return this.loadFileDialog(parent, UiFileFilters.FileResourceType.ROM);
    }

    private Optional<File> loadStateFileDialog(Component parent) {
        return this.loadFileDialog(parent, UiFileFilters.FileResourceType.SAVE_STATE_RES).map(r -> r.getBootableMedia().romFile.toFile());
    }

    private void handleLoadState() {
        Optional<File> optFile = this.loadStateFileDialog(this.jFrame);
        if (optFile.isPresent()) {
            Path file = optFile.get().toPath();
            this.handleSystemEvent(SystemProvider.SystemEvent.LOAD_STATE, file, file.getFileName().toString());
            PrefStore.lastSaveFile = file.toAbsolutePath().toString();
        }
    }

    private void handleQuickLoadState() {
        Path file = Paths.get(FileUtil.QUICK_SAVE_PATH, "quick_save");
        this.handleSystemEvent(SystemProvider.SystemEvent.QUICK_LOAD, file, file.getFileName().toString());
    }

    private void handleQuickSaveState() {
        Path p = Paths.get(FileUtil.QUICK_SAVE_PATH, "quick_save");
        this.handleSystemEvent(SystemProvider.SystemEvent.QUICK_SAVE, p, p.getFileName().toString());
    }

    private void handleSystemEvent(SystemProvider.SystemEvent event, Object par, String msg) {
        this.mainEmu.handleSystemEvent(event, par);
        this.showInfo(String.valueOf((Object)event) + (String)(Strings.isNullOrEmpty((String)msg) ? "" : ": " + msg));
    }

    private void handleSaveState() {
        Optional<File> optFile = this.fileDialogState(this.jFrame, UiFileFilters.FileResourceType.SAVE_STATE_RES, false);
        optFile.ifPresent(file -> this.handleSystemEvent(SystemProvider.SystemEvent.SAVE_STATE, file.toPath(), file.getName()));
    }

    private void handleNewRom() {
        this.handleSystemEvent(SystemProvider.SystemEvent.CLOSE_ROM, null, null);
        Optional<MediaSpecHolder> optFile = this.loadRomDialog(this.jFrame);
        if (optFile.isPresent()) {
            MediaSpecHolder romSpec = optFile.get();
            SystemLoader.getInstance().handleNewRomFile(romSpec);
            this.reloadRecentFiles();
            this.showInfo(String.valueOf((Object)SystemProvider.SystemEvent.NEW_ROM) + ": " + String.valueOf(romSpec));
            PrefStore.lastRomFile = romSpec.toString();
        }
    }

    private void handleNewRomFromRecent(String path) {
        MediaSpecHolder romSpec = PrefStore.getRomSpecFromRecentItem(path);
        this.showInfo(String.valueOf((Object)SystemProvider.SystemEvent.NEW_ROM) + ": " + String.valueOf(romSpec));
        SystemLoader.getInstance().handleNewRomFile(romSpec);
        PrefStore.lastRomFile = romSpec.toString();
    }

    private void addDndListener(Component component) {
        component.setDropTarget(new DropTarget(){

            @Override
            public synchronized void drop(DropTargetDropEvent e) {
                try {
                    e.acceptDrop(1);
                    Object data = e.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                    if (!(data instanceof List)) {
                        return;
                    }
                    List droppedFiles = (List)data;
                    if (droppedFiles.isEmpty()) {
                        return;
                    }
                    Object firstElement = droppedFiles.get(0);
                    if (!(firstElement instanceof File)) {
                        return;
                    }
                    File file = (File)firstElement;
                    Path path = file.toPath();
                    if (UiFileFilters.ROM_FILTER.accept(file)) {
                        SystemLoader.getInstance().handleNewRomFile(MediaSpecHolder.of(path));
                        SwingWindow.this.reloadRecentFiles();
                        SwingWindow.this.showInfo(String.valueOf((Object)SystemProvider.SystemEvent.NEW_ROM) + ": " + String.valueOf(path.getFileName()));
                    } else if (UiFileFilters.SAVE_STATE_FILTER.accept(file)) {
                        SwingWindow.this.handleSystemEvent(SystemProvider.SystemEvent.LOAD_STATE, path, path.getFileName().toString());
                    }
                }
                catch (Exception ex) {
                    LOG.warn("Unable to process drag and drop event: {}", (Object)e);
                }
            }
        });
    }

    @Override
    public void reloadSystem(SystemProvider systemProvider) {
        Optional.ofNullable(this.mainEmu).ifPresent(sys -> sys.handleSystemEvent(SystemProvider.SystemEvent.CLOSE_ROM, null));
        this.mainEmu = systemProvider;
        Arrays.stream(this.jFrame.getKeyListeners()).forEach(this.jFrame::removeKeyListener);
        Optional.ofNullable(this.mainEmu).ifPresent(sp -> {
            this.setRomData(MediaSpecHolder.NO_ROM);
            boolean en = this.mainEmu.getSystemType() == SystemLoader.SystemType.MD || this.mainEmu.getSystemType() == SystemLoader.SystemType.S32X;
            this.joypadTypeMenu.setEnabled(en);
            this.mainEmu.handleSystemEvent(SystemProvider.SystemEvent.SOUND_ENABLED, this.soundEnItem.getState());
        });
    }

    @Override
    public void addKeyListener(KeyListener keyAdapter) {
        if (this.awtEventListener != null) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.awtEventListener);
        }
        this.awtEventListener = e -> {
            if (e instanceof KeyEvent) {
                KeyEvent ke = (KeyEvent)e;
                this.handleSystemInputEvent(keyAdapter, ke);
                this.handleUiEvent(ke);
            }
        };
        Toolkit.getDefaultToolkit().addAWTEventListener(this.awtEventListener, 8L);
    }

    private void handleSystemInputEvent(KeyListener keyAdapter, KeyEvent ke) {
        switch (ke.getID()) {
            case 401: {
                keyAdapter.keyPressed(ke);
                break;
            }
            case 402: {
                keyAdapter.keyReleased(ke);
                break;
            }
            case 400: {
                keyAdapter.keyTyped(ke);
                break;
            }
            default: {
                LOG.warn("Unknown key event: {}", (Object)ke);
            }
        }
    }

    private void handleUiEvent(KeyEvent ke) {
        boolean menuVisible;
        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(ke);
        SystemProvider.SystemEvent event = KeyBindingsHandler.getInstance().getSystemEventIfAny(keyStroke);
        if (event != null && event != SystemProvider.SystemEvent.NONE && !(menuVisible = this.jFrame.getJMenuBar().isVisible())) {
            Optional.ofNullable(this.actionMap.get((Object)event)).ifPresent(act -> act.actionPerformed(null));
        }
    }

    private List<AbstractButton> createRegionItems() {
        ArrayList<AbstractButton> l = new ArrayList<AbstractButton>();
        l.add(new JRadioButtonMenuItem("AutoDetect", true));
        Arrays.stream(RegionDetector.Region.values()).sorted().forEach(r -> l.add(new JRadioButtonMenuItem(r.name(), false)));
        ButtonGroup bg = new ButtonGroup();
        l.forEach(bg::add);
        return l;
    }

    private List<AbstractButton> createAddScreenItems(JMenu screensMenu) {
        int i;
        List<String> l = SwingScreenSupport.detectScreens();
        this.screenItems = new ArrayList<AbstractButton>();
        for (i = 0; i < l.size(); ++i) {
            String s = l.get(i);
            JRadioButtonMenuItem it = new JRadioButtonMenuItem(s, i == SwingScreenSupport.getCurrentScreen());
            this.screenItems.add(it);
            screensMenu.add(it);
        }
        for (i = 0; i < this.screenItems.size(); ++i) {
            int num = i;
            this.addKeyAction(this.screenItems.get(i), SystemProvider.SystemEvent.NONE, e -> this.handleScreenChange(this.screenItems, num));
        }
        return this.screenItems;
    }

    private List<AbstractButton> createThemeItems() {
        ArrayList<AbstractButton> l = new ArrayList<AbstractButton>();
        FlatLafHelper.lafMap.keySet().forEach(r -> l.add(new JRadioButtonMenuItem((String)r, false)));
        ButtonGroup bg = new ButtonGroup();
        l.forEach(bg::add);
        int i = 0;
        while (i < l.size()) {
            AbstractButton ab = (AbstractButton)l.get(i);
            int idx = i++;
            this.addKeyAction(ab, SystemProvider.SystemEvent.NONE, e -> this.setLaf(l, idx, false));
        }
        SwingUtilities.invokeLater(() -> this.setLaf(l, PrefStore.getSwingUiThemeIndex(), true));
        return l;
    }

    private void setLaf(List<AbstractButton> l, int idx, boolean initSelection) {
        if (l.isEmpty()) {
            LOG.warn("Empty list of lookAndFeels");
            return;
        }
        if (idx < 0 || idx >= l.size()) {
            LOG.warn("Unable to set index: {}, size: {}", (Object)idx, (Object)l.size());
            idx = 0;
        }
        AbstractButton btn = l.get(idx);
        if (initSelection) {
            btn.setSelected(true);
        }
        FlatLafHelper.handleLafChange(btn.getText());
        PrefStore.setSwingUiThemeIndex(idx);
    }

    private void handleScreenChange(List<AbstractButton> items, int newScreen) {
        int cs = SwingScreenSupport.getCurrentScreen();
        if (cs != newScreen) {
            SwingScreenSupport.showOnScreen(newScreen, this.jFrame);
        }
        this.handleScreenChangeItems(items, newScreen);
    }

    private void handleScreenChangeItems(List<AbstractButton> items, int newScreen) {
        for (int i = 0; i < items.size(); ++i) {
            items.get(i).setSelected(i == newScreen);
        }
    }

    private void reloadRecentFiles() {
        List<String> l = PrefStore.getRecentFilesList();
        IntStream.range(0, this.recentFilesItems.length).forEach(i -> {
            String val = i < l.size() ? (String)l.get(i) : "<none>";
            val = Strings.isNullOrEmpty((String)val) ? "<none>" : val;
            String system = PrefStore.getSystemStringFromRecentItem(val);
            int idx = val.lastIndexOf(File.separatorChar);
            String text = i + ". [" + system + "] " + (idx > 0 ? val.substring(idx + 1) : val);
            this.recentFilesItems[i].setVisible(true);
            this.recentFilesItems[i].setEnabled(!Strings.isNullOrEmpty((String)val));
            this.recentFilesItems[i].setText(text);
            this.recentFilesItems[i].setToolTipText(val);
        });
    }

    @Override
    public void reloadControllers(Collection<String> list) {
        for (Map.Entry<InputProvider.PlayerNumber, JMenu> entry : this.inputMenusMap.entrySet()) {
            InputProvider.PlayerNumber pn = entry.getKey();
            JMenu menu = entry.getValue();
            menu.removeAll();
            ArrayList l = new ArrayList();
            list.forEach(c -> {
                JRadioButtonMenuItem item = new JRadioButtonMenuItem((String)c, "Default (Keyboard)".equalsIgnoreCase((String)c));
                this.addAction(item, e -> this.handleSystemEvent(SystemProvider.SystemEvent.CONTROLLER_CHANGE, pn.name() + ":" + c, pn.name() + ":" + c));
                l.add(item);
            });
            ButtonGroup bg = new ButtonGroup();
            l.forEach(bg::add);
            l.forEach(menu::add);
            if (list.size() <= 2 || pn != InputProvider.PlayerNumber.P1) continue;
            LOG.info("Auto-selecting {} using Controller: {}", (Object)pn, (Object)((JRadioButtonMenuItem)l.get(2)).getText());
            ((JRadioButtonMenuItem)l.get(2)).doClick();
        }
    }

    private void createAndAddJoypadTypes(JMenu joypadTypeMenu) {
        for (InputProvider.PlayerNumber pn : InputProvider.PlayerNumber.values()) {
            JMenu pMenu = new JMenu(pn.name());
            ButtonGroup bg = new ButtonGroup();
            for (JoypadProvider.JoypadType type : JoypadProvider.JoypadType.values()) {
                if (type == JoypadProvider.JoypadType.BUTTON_2) continue;
                JRadioButtonMenuItem it = new JRadioButtonMenuItem(type.name(), type == JoypadProvider.JoypadType.BUTTON_6);
                this.addAction(it, e -> this.handleSystemEvent(SystemProvider.SystemEvent.PAD_SETUP_CHANGE, pn.name() + ":" + type.name(), pn.name() + ":" + type.name()));
                bg.add(it);
                pMenu.add(it);
            }
            joypadTypeMenu.add(pMenu);
        }
    }

    private void setIcons(Window w) {
        if (Files.notExists(WINDOW_ICONS_PATH, new LinkOption[0])) {
            LOG.warn("Unable to find icons at: {}", (Object)WINDOW_ICONS_PATH.toAbsolutePath());
            return;
        }
        try {
            List<Path> paths = Files.list(WINDOW_ICONS_PATH).filter(ICONS_FILE_FILTER).toList();
            LOG.info("Window icons found: {}", (Object)Arrays.toString(paths.toArray()));
            List l = paths.stream().map(p -> new ImageIcon(p.toAbsolutePath().toString()).getImage()).collect(Collectors.toList());
            w.setIconImages(l);
        }
        catch (Exception e) {
            LOG.warn("Unable to load icons from: {}", (Object)WINDOW_ICONS_PATH.toAbsolutePath());
        }
    }

    @Override
    public void close() {
        Optional.ofNullable(this.executorService).ifPresent(ExecutorService::shutdownNow);
    }

    private static class MyAbstractAction
    extends AbstractAction {
        private final ActionListener listener;

        public MyAbstractAction(String name, ActionListener listener) {
            super(name);
            this.listener = listener;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.listener.actionPerformed(e);
        }

        @Override
        public void setEnabled(boolean newValue) {
            super.setEnabled(true);
        }
    }
}

