/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.ui.flatlaf;

import com.formdev.flatlaf.FlatDarculaLaf;
import com.formdev.flatlaf.FlatDarkLaf;
import com.formdev.flatlaf.FlatIntelliJLaf;
import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.FlatLightLaf;
import com.google.common.collect.ImmutableSortedMap;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.UIManager;
import omegadrive.util.LogHelper;
import org.slf4j.Logger;

public class FlatLafHelper {
    private static final Logger LOG = LogHelper.getLogger(FlatLafHelper.class.getSimpleName());
    private static final Comparator<String> lfNameComparator = (k1, k2) -> {
        if (!((String)k1).startsWith("Flat")) {
            k1 = "Z" + (String)k1;
        }
        if (!((String)k2).startsWith("Flat")) {
            k2 = "Z" + (String)k2;
        }
        return ((String)k1).compareTo((String)k2);
    };
    public static Map<String, String> lafMap;

    private static void initFlatLaf() {
        try {
            FlatLightLaf.installLafInfo();
            FlatDarkLaf.installLafInfo();
            FlatIntelliJLaf.installLafInfo();
            FlatDarculaLaf.installLafInfo();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        UIManager.LookAndFeelInfo[] lafs = UIManager.getInstalledLookAndFeels();
        TreeMap map = new TreeMap();
        Arrays.stream(lafs).forEach(l -> map.put(l.getName(), l.getClassName()));
        lafMap = ImmutableSortedMap.copyOf(map, lfNameComparator);
        LOG.info("LookAndFeel detected: {}", lafMap);
    }

    public static void handleLafChange(String name) {
        assert (lafMap.containsKey(name));
        try {
            UIManager.setLookAndFeel(lafMap.get(name));
            FlatLaf.updateUI();
            LOG.info("Set look and feel: {}", (Object)name);
        }
        catch (Exception e) {
            LOG.error("Unable to set look and feel: {}, {}", (Object)name, (Object)e.getMessage());
        }
    }

    static {
        FlatLafHelper.initFlatLaf();
    }
}

