/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.ui.util;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import omegadrive.util.LogHelper;
import omegadrive.util.RegionDetector;
import org.slf4j.Logger;

public class IconsLoader {
    private static final Logger LOG = LogHelper.getLogger(IconsLoader.class.getSimpleName());
    private static final Map<RegionDetector.Region, String> regFileMap = Map.of(RegionDetector.Region.EUROPE, "eu_25px.png", RegionDetector.Region.USA, "us_25px.png", RegionDetector.Region.JAPAN, "jp_25px.png");
    private static final String ledFileHead = "mcd-leds_";
    private static final String[] ledFileMap = new String[]{"mcd-leds_00.png", "mcd-leds_01.png", "mcd-leds_10.png", "mcd-leds_11.png"};
    private static final Map<RegionDetector.Region, Icon> flagIconMap = new EnumMap<RegionDetector.Region, Icon>(RegionDetector.Region.class);
    private static final Icon[] ledIconMap = new Icon[ledFileMap.length];
    private static final Path baseLeds = Paths.get(".", "res", "icon", "mcd_leds");
    private static final Path baseFlags = Paths.get(".", "res", "icon", "flags");

    public static Icon getRegionIcon(RegionDetector.Region region) {
        return flagIconMap.get((Object)region);
    }

    public static Icon getLedIcon(int state) {
        assert (state >= 0 && state < ledIconMap.length);
        return ledIconMap[state];
    }

    static {
        try {
            for (Map.Entry<RegionDetector.Region, String> e : regFileMap.entrySet()) {
                Path p = Paths.get(baseFlags.toAbsolutePath().toString(), e.getValue());
                flagIconMap.put(e.getKey(), new ImageIcon(ImageIO.read(p.toFile())));
            }
            LOG.info("Loaded country flags from folder: {}, files: {}", (Object)baseFlags, regFileMap);
        }
        catch (IOException e) {
            LOG.error("Unable to load country flags from folder: {}, files: {}", (Object)baseFlags, regFileMap);
            LOG.error("Error", (Throwable)e);
        }
        try {
            for (int i = 0; i < ledFileMap.length; ++i) {
                Path p = Paths.get(baseLeds.toAbsolutePath().toString(), ledFileMap[i]);
                IconsLoader.ledIconMap[i] = new ImageIcon(ImageIO.read(p.toFile()));
            }
            LOG.info("Loaded megacd led icons from folder: {}, files: {}", (Object)baseLeds, (Object)Arrays.toString(ledFileMap));
        }
        catch (IOException e) {
            LOG.error("Unable to load megacd led icons from folder: {}, files: {}", (Object)baseLeds, regFileMap);
            LOG.error("Error", (Throwable)e);
        }
    }
}

