/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.util;

import java.io.Serializable;
import java.util.Arrays;

public class FastBitSet
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final long LIVE = -1L;
    public static final long DEAD = 0L;
    protected static final int MOD_SIZE_MASK = 63;
    protected static final int LOG_2_SIZE = 6;
    public final int size;
    public final int wordCount;
    protected final long[] words;

    public FastBitSet(int size) {
        int wordCount = FastBitSet.divideSize(size);
        if (wordCount < 0) {
            throw new IllegalArgumentException(Integer.toString(size));
        }
        if (FastBitSet.modSize(size) > 0) {
            ++wordCount;
        }
        this.size = size;
        this.wordCount = wordCount;
        this.words = new long[wordCount];
    }

    public FastBitSet(FastBitSet set) {
        this(set.size);
        this.copy(set);
    }

    public final boolean get(int index) {
        return (this.words[index >>> 6] & 1L << index) != 0L;
    }

    public final int get(int from, int to) {
        int sum;
        int start = from >>> 6;
        int end = to - 1 << 6;
        long startMask = -1L << from;
        long endMask = -1L >>> -to;
        if (start == end) {
            sum = Long.bitCount(this.words[start] & startMask & endMask);
        } else {
            sum = Long.bitCount(this.words[start] & startMask);
            for (int i = start + 1; i < end; ++i) {
                sum += Long.bitCount(this.words[i]);
            }
            sum += Long.bitCount(this.words[end] & endMask);
        }
        return sum;
    }

    public final void set(int index, boolean val) {
        if (val) {
            this.set(index);
        } else {
            this.clear(index);
        }
    }

    public final void set(int index) {
        int n = index >>> 6;
        this.words[n] = this.words[n] | 1L << index;
    }

    public final void set(int from, int to) {
        int start = from >>> 6;
        int end = to - 1 << 6;
        long startMask = -1L << from;
        long endMask = -1L >>> -to;
        if (start == end) {
            int n = start;
            this.words[n] = this.words[n] | startMask & endMask;
        } else {
            int n = start;
            this.words[n] = this.words[n] | startMask;
            for (int i = start + 1; i < end; ++i) {
                this.words[i] = -1L;
            }
            int n2 = end;
            this.words[n2] = this.words[n2] | endMask;
        }
    }

    public final void clear(int index) {
        int n = index >>> 6;
        this.words[n] = this.words[n] & (1L << index ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public final void clear(int from, int to) {
        int start = from >>> 6;
        int end = to - 1 << 6;
        long startMask = -1L << from;
        long endMask = -1L >>> -to;
        if (start == end) {
            int n = start;
            this.words[n] = this.words[n] & (startMask & endMask ^ 0xFFFFFFFFFFFFFFFFL);
        } else {
            int n = start;
            this.words[n] = this.words[n] & (startMask ^ 0xFFFFFFFFFFFFFFFFL);
            for (int i = start + 1; i < end; ++i) {
                this.words[i] = 0L;
            }
            int n2 = end;
            this.words[n2] = this.words[n2] & (endMask ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public void flip(int index) {
        int n = index >>> 6;
        this.words[n] = this.words[n] ^ 1L << index;
    }

    public void flip(int from, int to) {
        int start = from >>> 6;
        int end = to - 1 << 6;
        long startMask = -1L << from;
        long endMask = -1L >>> -to;
        if (start == end) {
            int n = start;
            this.words[n] = this.words[n] ^ startMask & endMask;
        } else {
            int n = start;
            this.words[n] = this.words[n] ^ startMask;
            int i = start + 1;
            while (i < end) {
                int n2 = i++;
                this.words[n2] = this.words[n2] ^ 0xFFFFFFFFFFFFFFFFL;
            }
            int n3 = end;
            this.words[n3] = this.words[n3] ^ endMask;
        }
    }

    public boolean add(int index) {
        int wordIndex = index >>> 6;
        long mask = 1L << index;
        if ((this.words[wordIndex] & mask) != 0L) {
            return false;
        }
        int n = wordIndex;
        this.words[n] = this.words[n] | mask;
        return true;
    }

    public boolean remove(int index) {
        int wordIndex = index >>> 6;
        long mask = 1L << index ^ 0xFFFFFFFFFFFFFFFFL;
        if ((this.words[wordIndex] | mask) != -1L) {
            return false;
        }
        int n = wordIndex;
        this.words[n] = this.words[n] & mask;
        return true;
    }

    public void andWord(int wordIndex, long mask) {
        int n = wordIndex;
        this.words[n] = this.words[n] & mask;
    }

    public void orWord(int wordIndex, long mask) {
        int n = wordIndex;
        this.words[n] = this.words[n] | mask;
    }

    public void xOrWord(int wordIndex, long mask) {
        int n = wordIndex;
        this.words[n] = this.words[n] ^ mask;
    }

    public void notAndWord(int wordIndex, long mask) {
        this.words[wordIndex] = this.words[wordIndex] & mask ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public void notOrWord(int wordIndex, long mask) {
        this.words[wordIndex] = (this.words[wordIndex] | mask) ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public void notXOrWord(int wordIndex, long mask) {
        this.words[wordIndex] = this.words[wordIndex] ^ mask ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public void setWordSegment(int wordIndex, long word, long mask) {
        this.words[wordIndex] = mask & word | (mask ^ 0xFFFFFFFFFFFFFFFFL) & this.words[wordIndex];
    }

    public void flipWord(int wordIndex) {
        int n = wordIndex;
        this.words[n] = this.words[n] ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public void fillWord(int wordIndex) {
        this.words[wordIndex] = -1L;
    }

    public void emptyWord(int wordIndex) {
        this.words[wordIndex] = 0L;
    }

    public long getWord(int wordIndex) {
        return this.words[wordIndex];
    }

    public void setWord(int wordIndex, long word) {
        this.words[wordIndex] = word;
    }

    public final void fill() {
        for (int i = 0; i < this.wordCount; ++i) {
            this.fillWord(i);
        }
    }

    public final void empty() {
        for (int i = 0; i < this.wordCount; ++i) {
            this.emptyWord(i);
        }
    }

    public final void flip() {
        for (int i = 0; i < this.wordCount; ++i) {
            this.flipWord(i);
        }
    }

    public final void and(FastBitSet set) {
        for (int i = 0; i < this.wordCount; ++i) {
            this.andWord(i, set.getWord(i));
        }
    }

    public final void or(FastBitSet set) {
        for (int i = 0; i < this.wordCount; ++i) {
            this.orWord(i, set.getWord(i));
        }
    }

    public final void xOr(FastBitSet set) {
        for (int i = 0; i < this.wordCount; ++i) {
            this.xOrWord(i, set.getWord(i));
        }
    }

    public final void notAnd(FastBitSet set) {
        for (int i = 0; i < this.wordCount; ++i) {
            this.notAndWord(i, set.getWord(i));
        }
    }

    public final void notOr(FastBitSet set) {
        for (int i = 0; i < this.wordCount; ++i) {
            this.notOrWord(i, set.getWord(i));
        }
    }

    public final void notXOr(FastBitSet set) {
        for (int i = 0; i < this.wordCount; ++i) {
            this.notXOrWord(i, set.getWord(i));
        }
    }

    public final void not(FastBitSet set) {
        for (int i = 0; i < this.wordCount; ++i) {
            this.setWord(i, set.getWord(i) ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public final void copy(FastBitSet set) {
        for (int i = 0; i < this.wordCount; ++i) {
            this.setWord(i, set.getWord(i));
        }
    }

    public final void clearHanging() {
        int hanging = FastBitSet.modSize(-this.size);
        if (hanging > 0) {
            this.andWord(this.wordCount - 1, -1L >>> hanging);
        }
    }

    public final boolean isEmpty() {
        this.clearHanging();
        return this.population() == 0;
    }

    public final int population() {
        int population = 0;
        for (int i = 0; i < this.wordCount; ++i) {
            population += Long.bitCount(this.getWord(i));
        }
        return population;
    }

    public final double density(int from, int to) {
        return (double)this.get(from, to) / (double)(to - from);
    }

    public final double density() {
        return (double)this.population() / (double)this.size;
    }

    public static int divideSize(int n) {
        return n >>> 6;
    }

    public static int multiplySize(int n) {
        return n << 6;
    }

    public static int modSize(int n) {
        return n & 0x3F;
    }

    public static long bitMask(int index) {
        return 1L << index;
    }

    public int hashCode() {
        long hash = this.size;
        for (int i = 0; i < this.wordCount; ++i) {
            hash *= 31L;
            hash += this.getWord(i);
        }
        return (int)(hash ^ hash >>> 32);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return obj instanceof FastBitSet && Arrays.equals(this.words, ((FastBitSet)obj).words);
    }
}

