/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.util;

import java.lang.reflect.Method;
import omegadrive.util.JmxLauncherProxy;
import omegadrive.util.LogHelper;
import org.slf4j.Logger;

public class JmxBridge {
    private static final Logger LOG = LogHelper.getLogger(JmxBridge.class.getSimpleName());
    private static boolean JMX_SUPPORT_FLAG;
    private static JmxLauncherProxy proxy;

    public static void registerJmx(Object object) {
        if (JMX_SUPPORT_FLAG) {
            try {
                String name = object.getClass().getSimpleName();
                String objName = proxy.exportToJMX(object, name);
                if (objName != null) {
                    LOG.info("JMX exporting: {}", (Object)objName);
                } else {
                    LOG.warn("JMX exporting failed: {}", (Object)name);
                }
            }
            catch (Exception e) {
                LOG.warn("Unable to export: {}", (Object)object.getClass().getSimpleName());
            }
        }
    }

    static {
        try {
            Class<?> cl = Class.forName("com.jmxwebtools.JmxLauncher");
            Method factoryMethod = cl.getDeclaredMethod("getInstance", new Class[0]);
            proxy = (JmxLauncherProxy)factoryMethod.invoke(null, (Object[])null);
            proxy.launch("Helios");
            JMX_SUPPORT_FLAG = true;
        }
        catch (Exception e) {
            LOG.info("JMX not supported");
            JMX_SUPPORT_FLAG = false;
        }
    }
}

