/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.util;

import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public class LogHelper {
    public static boolean doLog = false;
    public static final boolean isWarnEnabled = LoggerFactory.getLogger((String)"ROOT").isWarnEnabled();
    private Set<String> msgCache = new HashSet<String>();
    private RepeaterDetector rd = new RepeaterDetector();
    private static Set<String> msgCacheShared = new HashSet<String>();

    public static Logger getLogger(String name) {
        return LoggerFactory.getLogger((String)name);
    }

    public static Logger getLogger(Class<?> c) {
        return LoggerFactory.getLogger((String)c.getSimpleName());
    }

    public static String formatMessage(String s, Object ... o) {
        return MessageFormatter.arrayFormat((String)s, (Object[])o).getMessage();
    }

    public static void logInfo(Logger log, String str, Object ... o) {
        if (doLog) {
            log.info(LogHelper.formatMessage(str, o));
        }
    }

    public static void logWarnOnceWhenEn(Logger log, String str, Object ... o) {
        if (!isWarnEnabled) {
            return;
        }
        String msg = LogHelper.formatMessage(str, o);
        if (msgCacheShared.add(msg)) {
            LogHelper.logWarn(log, msg + " (ONCE)");
        }
    }

    public static void logWarnOnce(Logger log, String str, Object ... o) {
        if (!isWarnEnabled) {
            return;
        }
        String msg = LogHelper.formatMessage(str, o);
        if (msgCacheShared.add(msg)) {
            log.warn(msg + " (ONCE)");
        }
    }

    public void logWarningOnceWhenEnRepeat(Logger log, String str, Object ... o) {
        if (!isWarnEnabled) {
            return;
        }
        String msg = LogHelper.formatMessage(str, o);
        if (this.msgCache.add(msg)) {
            LogHelper.logWarn(log, msg + " (ONCE)");
        } else {
            this.checkRepeat(log, msg);
        }
    }

    private void checkRepeat(Logger log, String msg) {
        if (this.rd.msg.equals(msg)) {
            boolean logRepeat = this.rd.hit();
            if (logRepeat) {
                LogHelper.logWarn(log, msg + " - RP: " + this.rd.cnt);
            }
        } else {
            this.rd.reset();
            this.rd.msg = msg;
        }
    }

    private static void logWarn(Logger log, String msg) {
        if (doLog) {
            log.warn(msg);
        }
    }

    public void clearData() {
        System.out.println("LogHelper: clearing msg cache, size: " + this.msgCache.size());
        this.msgCache.clear();
        this.rd.reset();
    }

    public static void clear() {
        msgCacheShared.clear();
    }

    private static class RepeaterDetector {
        public String msg = "";
        public long cnt = 0L;
        public long nextLog = 10L;

        private RepeaterDetector() {
        }

        public boolean hit() {
            if (++this.cnt % this.nextLog == 0L) {
                this.nextLog *= 10L;
                return true;
            }
            return false;
        }

        public void reset() {
            this.msg = "";
            this.cnt = 0L;
            this.nextLog = 10L;
        }
    }
}

