/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.util;

import java.nio.ByteBuffer;
import omegadrive.util.Size;

public class RegSpec {
    public static final RegSpec INVALID_REG = new RegSpec("INVALID", -1, 0, Size.LONG);
    public final String name;
    public final int fullAddr;
    public final int bufferAddr;
    public final int addrMask;
    public final Size regSize;
    private final int sizeIndex;
    public final int writableBitMask;
    public final int preserveBitMask;
    private static final BytePosReg[] bprVals = BytePosReg.values();

    public RegSpec(String name, int fullAddr, int addrMask, Size size) {
        this(name, fullAddr, addrMask, size.getMask(), 0, size);
    }

    public RegSpec(String name, int fullAddr, int addrMask, int writableBitMask, int preserveBitMask, Size size) {
        this.name = name;
        this.fullAddr = fullAddr;
        this.bufferAddr = fullAddr & addrMask;
        this.addrMask = addrMask;
        this.regSize = size;
        this.sizeIndex = size.getByteSize() - 1;
        this.writableBitMask = writableBitMask & size.getMask();
        this.preserveBitMask = preserveBitMask & size.getMask();
    }

    public boolean write(ByteBuffer b, int value, Size size) {
        return this.write(b, BytePosReg.BYTE_0, value, size);
    }

    public boolean write(ByteBuffer b, int regPos, int value, Size size) {
        return this.write(b, bprVals[regPos - this.bufferAddr], value, size);
    }

    public boolean write(ByteBuffer b, BytePosReg bytePosReg, int value, Size size) {
        int bytePos = bytePosReg.ordinal();
        assert (bytePos <= this.sizeIndex);
        assert (this != INVALID_REG);
        return switch (size) {
            default -> throw new IncompatibleClassChangeError();
            case Size.WORD -> {
                if (!$assertionsDisabled && this.regSize == Size.BYTE) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && (bytePos & 1) != 0) {
                    throw new AssertionError();
                }
                int shift = this.sizeIndex - 1 - bytePos << 3;
                boolean res = this.writeByteWithinWL(b, bytePos, value << shift);
                yield res |= this.writeByteWithinWL(b, bytePos + 1, value << shift);
            }
            case Size.LONG -> {
                if (!$assertionsDisabled && this.regSize != Size.LONG) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && bytePos != 0) {
                    throw new AssertionError();
                }
                boolean res = this.writeByteWithinWL(b, 0, value);
                res |= this.writeByteWithinWL(b, 1, value);
                res |= this.writeByteWithinWL(b, 2, value);
                yield res |= this.writeByteWithinWL(b, 3, value);
            }
            case Size.BYTE -> this.writeByteRaw(b, bytePos & this.sizeIndex, value);
        };
    }

    private boolean writeByteRaw(ByteBuffer b, int pos, int value) {
        return this.writeByteWithinWL(b, pos, value << (this.sizeIndex - pos << 3));
    }

    public boolean writeByteWithinWL(ByteBuffer b, int pos, int value) {
        assert (pos <= this.sizeIndex);
        int shift = this.sizeIndex - pos << 3;
        int byteMask = this.writableBitMask >> shift & 0xFF;
        int orMask = this.preserveBitMask >> shift & 0xFF;
        if (byteMask == 0) {
            return false;
        }
        byte v = (byte)(value >> shift & byteMask | orMask);
        if (b.get(this.bufferAddr + pos) != v) {
            b.put(this.bufferAddr + pos, v);
            return true;
        }
        return false;
    }

    public static enum BytePosReg {
        BYTE_0,
        BYTE_1,
        BYTE_2,
        BYTE_3;

    }
}

